/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.XmlSmartCompletionProvider;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.emmet.completion.EmmetAbbreviationCompletionProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlCompletionContributor
extends CompletionContributor {
    public static final Key<Boolean> WORD_COMPLETION_COMPATIBLE = Key.create((String)"WORD_COMPLETION_COMPATIBLE");
    public static final EntityRefInsertHandler ENTITY_INSERT_HANDLER = new EntityRefInsertHandler();
    @NonNls
    public static final String TAG_NAME_COMPLETION_FEATURE = "tag.name.completion";
    private static final InsertHandlerDecorator<LookupElement> QUOTE_EATER = new InsertHandlerDecorator<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
            char completionChar = context.getCompletionChar();
            if (completionChar == '\'' || completionChar == '\"') {
                char c;
                context.setAddCompletionChar(false);
                item.getDelegate().handleInsert(context);
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                int tailOffset = editor.getCaretModel().getOffset();
                if (document.getTextLength() > tailOffset && ((c = document.getCharsSequence().charAt(tailOffset)) == completionChar || completionChar == '\'')) {
                    editor.getCaretModel().moveToOffset(tailOffset + 1);
                }
            } else {
                item.getDelegate().handleInsert(context);
            }
        }
    };

    public XmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlFile()), new EmmetAbbreviationCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlFile()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position = parameters2.getPosition();
                IElementType type2 = position.getNode().getElementType();
                if (type2 != XmlTokenType.XML_DATA_CHARACTERS && type2 != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    return;
                }
                if (position.getPrevSibling() != null && position.getPrevSibling().textMatches((CharSequence)"&") || position.textContains('&')) {
                    PrefixMatcher matcher = result2.getPrefixMatcher();
                    String prefix = matcher.getPrefix();
                    if (prefix.startsWith("&")) {
                        prefix = prefix.substring(1);
                    } else if (prefix.contains("&")) {
                        prefix = prefix.substring(prefix.indexOf("&") + 1);
                    }
                    XmlCompletionContributor.addEntityRefCompletions(position, result2.withPrefixMatcher(prefix));
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position = parameters2.getPosition();
                if (!position.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
                    return;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttributeValue.class, (boolean)false);
                if (attributeValue == null) {
                    return;
                }
                THashSet usedWords = new THashSet();
                Ref addWordVariants = Ref.create((Object)true);
                result2.runRemainingContributors(parameters2, arg_0 -> 3.lambda$addCompletions$0(addWordVariants, (Set)usedWords, result2, arg_0));
                if (((Boolean)addWordVariants.get()).booleanValue()) {
                    addWordVariants.set((Object)(attributeValue.getReferences().length == 0 ? 1 : 0));
                }
                if (((Boolean)addWordVariants.get()).booleanValue() && parameters2.getInvocationCount() > 0) {
                    WordCompletionContributor.addWordCompletionVariants(result2, parameters2, (Set<String>)usedWords);
                }
            }

            private static /* synthetic */ void lambda$addCompletions$0(Ref addWordVariants, Set usedWords, @NotNull CompletionResultSet result2, CompletionResult r) {
                if (r.getLookupElement().getUserData(WORD_COMPLETION_COMPATIBLE) == null) {
                    addWordVariants.set((Object)false);
                }
                usedWords.add(r.getLookupElement().getLookupString());
                result2.passResult(r.withLookupElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)r.getLookupElement(), (InsertHandler)QUOTE_EATER)));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withElementType(XmlTokenType.XML_DATA_CHARACTERS), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
                XmlTag simpleContent;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parameters2.getPosition(), XmlTag.class, (boolean)false);
                if (tag != null && !XmlCompletionContributor.hasEnumerationReference(parameters2, result2) && (simpleContent = XmlUtil.getSchemaSimpleContent(tag)) != null) {
                    XmlUtil.processEnumerationValues(simpleContent, (Processor<XmlTag>)((Processor)element -> {
                        String value2 = element.getAttributeValue("value");
                        assert (value2 != null);
                        result2.addElement((LookupElement)LookupElementBuilder.create((String)value2));
                        return true;
                    }));
                }
            }
        });
    }

    static boolean hasEnumerationReference(CompletionParameters parameters2, CompletionResultSet result2) {
        Ref hasRef = Ref.create((Object)false);
        LegacyCompletionContributor.processReferences(parameters2, result2, (PairConsumer<PsiReference, CompletionResultSet>)((PairConsumer)(reference, resultSet) -> {
            if (reference instanceof XmlEnumeratedValueReference) {
                hasRef.set((Object)true);
            }
        }));
        return (Boolean)hasRef.get();
    }

    public static boolean isXmlNameCompletion(CompletionParameters parameters2) {
        ASTNode node = parameters2.getPosition().getNode();
        return node != null && node.getElementType() == XmlTokenType.XML_NAME;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        super.fillCompletionVariants(parameters2, result2);
        if (result2.isStopped()) {
            return;
        }
        PsiElement element = parameters2.getPosition();
        if (parameters2.isExtendedCompletion()) {
            XmlCompletionContributor.completeTagName(parameters2, result2);
        } else if (parameters2.getCompletionType() == CompletionType.SMART) {
            new XmlSmartCompletionProvider().complete(parameters2, result2, element);
        }
    }

    static void completeTagName(CompletionParameters parameters2, CompletionResultSet result2) {
        PsiElement element = parameters2.getPosition();
        if (!XmlCompletionContributor.isXmlNameCompletion(parameters2)) {
            return;
        }
        result2.stopHere();
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlTag) || !(parameters2.getOriginalFile() instanceof XmlFile)) {
            return;
        }
        XmlTag tag = (XmlTag)parent;
        String namespace = tag.getNamespace();
        String prefix = result2.getPrefixMatcher().getPrefix();
        int pos = prefix.indexOf(58);
        PsiReference reference = tag.getReference();
        String namespacePrefix = tag.getNamespacePrefix();
        if (reference != null && !namespace.isEmpty() && !namespacePrefix.isEmpty()) {
            result2.runRemainingContributors(parameters2, true);
        } else {
            CompletionResultSet newResult = result2.withPrefixMatcher(pos >= 0 ? prefix.substring(pos + 1) : prefix);
            XmlFile file2 = (XmlFile)parameters2.getOriginalFile();
            List<XmlExtension.TagInfo> names = XmlExtension.getExtension((PsiFile)file2).getAvailableTagNames(file2, tag);
            for (XmlExtension.TagInfo info : names) {
                LookupElement item = XmlCompletionContributor.createLookupElement(info, info.namespace, namespacePrefix.isEmpty() ? null : namespacePrefix);
                newResult.addElement(item);
            }
        }
    }

    public static LookupElement createLookupElement(XmlExtension.TagInfo tagInfo, String tailText, @Nullable String namespacePrefix) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)tagInfo, (String)tagInfo.name).withInsertHandler((InsertHandler)new ExtendedTagInsertHandler(tagInfo.name, tagInfo.namespace, namespacePrefix));
        if (!StringUtil.isEmpty((String)tailText)) {
            builder = builder.withTypeText(tailText, true);
        }
        return builder;
    }

    public String advertise(@NotNull CompletionParameters parameters2) {
        if (XmlCompletionContributor.isXmlNameCompletion(parameters2) && parameters2.getCompletionType() == CompletionType.BASIC && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(TAG_NAME_COMPLETION_FEATURE, parameters2.getPosition().getProject())) {
            String shortcut = XmlCompletionContributor.getActionShortcut((String)"CodeCompletion");
            return XmlBundle.message((String)"tag.name.completion.hint", (Object[])new Object[]{shortcut});
        }
        return super.advertise(parameters2);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement at;
        int offset = context.getStartOffset();
        PsiFile file2 = context.getFile();
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, XmlAttributeValue.class, (boolean)true);
        if (attributeValue != null && offset == attributeValue.getTextRange().getStartOffset()) {
            context.setDummyIdentifier("");
        }
        if ((at = file2.findElementAt(offset)) != null && at.getNode().getElementType() == XmlTokenType.XML_NAME && at.getParent() instanceof XmlAttribute) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, at.getTextRange().getEndOffset());
        }
        if (at != null && at.getParent() instanceof XmlAttributeValue) {
            int end = at.getParent().getTextRange().getEndOffset();
            Document document = context.getEditor().getDocument();
            int lineEnd = document.getLineEndOffset(document.getLineNumber(offset));
            if (lineEnd < end) {
                context.setReplacementOffset(lineEnd);
            }
        }
    }

    private static void addEntityRefCompletions(PsiElement context, final CompletionResultSet resultSet) {
        XmlDocument document;
        XmlFile containingFile = null;
        XmlFile descriptorFile = null;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        if (tag != null) {
            containingFile = (XmlFile)tag.getContainingFile();
            descriptorFile = XmlUtil.findDescriptorFile(tag, containingFile);
        }
        if (HtmlUtil.isHtml5Context((XmlElement)tag)) {
            descriptorFile = XmlUtil.findXmlFile((PsiFile)containingFile, Html5SchemaProvider.getCharsDtdLocation());
        } else if (tag == null && (document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class)) != null) {
            String namespace;
            XmlNSDescriptor nsDescriptor;
            containingFile = (XmlFile)document.getContainingFile();
            FileType ft = containingFile.getFileType();
            if (HtmlUtil.isHtml5Document(document)) {
                descriptorFile = XmlUtil.findXmlFile((PsiFile)containingFile, Html5SchemaProvider.getCharsDtdLocation());
            } else if (ft != StdFileTypes.XML && (nsDescriptor = document.getDefaultNSDescriptor(namespace = ft == StdFileTypes.XHTML || ft == StdFileTypes.JSPX ? "http://www.w3.org/1999/xhtml" : "http://www.w3.org/1999/html", true)) != null) {
                descriptorFile = nsDescriptor.getDescriptorFile();
            }
        }
        if (descriptorFile != null && containingFile != null) {
            XmlProlog element;
            final boolean acceptSystemEntities = containingFile.getFileType() == StdFileTypes.XML;
            PsiElementProcessor processor2 = new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    LookupElementBuilder _item;
                    XmlEntityDecl xmlEntityDecl;
                    if (element instanceof XmlEntityDecl && ((xmlEntityDecl = (XmlEntityDecl)element).isInternalReference() || acceptSystemEntities) && (_item = XmlCompletionContributor.buildEntityLookupItem(xmlEntityDecl)) != null) {
                        resultSet.addElement((LookupElement)_item);
                        resultSet.stopHere();
                    }
                    return true;
                }
            };
            XmlUtil.processXmlElements((XmlElement)descriptorFile, processor2, true);
            if (descriptorFile != containingFile && acceptSystemEntities && (element = containingFile.getDocument().getProlog()) != null) {
                XmlUtil.processXmlElements((XmlElement)element, processor2, true);
            }
        }
    }

    @Nullable
    private static LookupElementBuilder buildEntityLookupItem(@NotNull XmlEntityDecl decl) {
        String valueText;
        int i2;
        ASTNode[] nodes;
        String name = decl.getName();
        if (name == null) {
            return null;
        }
        LookupElementBuilder result2 = LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)ENTITY_INSERT_HANDLER);
        XmlAttributeValue value2 = decl.getValueElement();
        ASTNode node = value2.getNode();
        if (node != null && (nodes = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CHAR_ENTITY_REF}))).length == 1 && (i2 = (valueText = nodes[0].getText()).indexOf(35)) > 0) {
            String s = valueText.substring(i2 + 1);
            s = StringUtil.trimEnd((String)s, (String)";");
            try {
                int unicodeChar = Integer.valueOf(s);
                return result2.withTypeText(String.valueOf((char)unicodeChar));
            }
            catch (NumberFormatException e) {
                return result2;
            }
        }
        return result2;
    }

    private static class EntityRefInsertHandler
    extends BasicInsertHandler<LookupElement> {
        private EntityRefInsertHandler() {
        }

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            context.setAddCompletionChar(false);
            CaretModel caretModel = context.getEditor().getCaretModel();
            context.getEditor().getDocument().insertString(caretModel.getOffset(), (CharSequence)";");
            caretModel.moveToOffset(caretModel.getOffset() + 1);
        }
    }
}

