/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class XmlLocationCompletionContributor
extends CompletionContributor {
    public static final Function<Object, LookupElement> MAPPING = o -> o instanceof LookupElement ? (LookupElement)o : LookupElementBuilder.create((Object)o);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiReference reference = parameters2.getPosition().getContainingFile().findReferenceAt(parameters2.getOffset());
        if (reference instanceof URLReference) {
            if (((URLReference)reference).isSchemaLocation()) {
                Object[] objects = XmlLocationCompletionContributor.completeSchemaLocation(reference.getElement());
                result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
                return;
            }
            Object[] objects = XmlLocationCompletionContributor.completeNamespace(reference.getElement());
            result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
            return;
        }
        if (reference instanceof PsiMultiReference) {
            reference = ((PsiMultiReference)reference).getReferences()[0];
        }
        if (reference instanceof DependentNSReference) {
            MultiMap<String, String> map2 = ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(parameters2.getOriginalFile().getProject());
            String namespace = ((DependentNSReference)reference).getNamespaceReference().getCanonicalText();
            Collection strings = map2.get((Object)namespace);
            for (String string : strings) {
                if (namespace.equals(string)) continue;
                result2.consume(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)string), (double)100.0));
            }
            if (!strings.isEmpty()) {
                result2.stopHere();
            }
        }
    }

    private static Object[] completeNamespace(PsiElement myElement) {
        XmlFile file2 = (XmlFile)myElement.getContainingFile();
        PsiElement parent = myElement.getParent();
        HashSet<String> preferred = new HashSet<String>();
        if (parent instanceof XmlAttribute && "xmlns".equals(((XmlAttribute)parent).getName())) {
            XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper((PsiFile)file2);
            preferred.addAll(helper.guessUnboundNamespaces(parent.getParent(), file2));
        }
        HashSet list = new HashSet();
        for (XmlSchemaProvider provider2 : (XmlSchemaProvider[])Extensions.getExtensions((ExtensionPointName)XmlSchemaProvider.EP_NAME)) {
            if (!provider2.isAvailable(file2)) continue;
            list.addAll(provider2.getAvailableNamespaces(file2, null));
        }
        if (!list.isEmpty()) {
            return ArrayUtil.toObjectArray(list);
        }
        Object[] resourceUrls = ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(myElement.getProject()).keySet().toArray();
        XmlDocument document = file2.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        ArrayList additionalNs = new ArrayList();
        if (rootTag != null) {
            URLReference.processWsdlSchemas(rootTag, (Processor<XmlTag>)((Processor)xmlTag -> {
                String s = xmlTag.getAttributeValue("targetNamespace");
                if (s != null) {
                    additionalNs.add(s);
                }
                return true;
            }));
        }
        resourceUrls = ArrayUtil.mergeArrays((Object[])resourceUrls, (Object[])ArrayUtil.toStringArray(additionalNs));
        return ContainerUtil.map2Array((Object[])resourceUrls, o -> {
            LookupElementBuilder builder = LookupElementBuilder.create((Object)o);
            return preferred.contains(o) ? PrioritizedLookupElement.withPriority((LookupElement)builder, (double)100.0) : builder;
        });
    }

    private static Object[] completeSchemaLocation(PsiElement element) {
        XmlTag tag = (XmlTag)element.getParent().getParent();
        Object[] attributes = tag.getAttributes();
        PsiReference[] refs = element.getReferences();
        return ContainerUtil.mapNotNull((Object[])attributes, attribute -> {
            String attributeValue = attribute.getValue();
            return attributeValue != null && attribute.isNamespaceDeclaration() && ContainerUtil.find((Object[])refs, ref -> ref.getCanonicalText().equals(attributeValue)) == null ? attributeValue + " " : null;
        }, (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY);
    }
}

