/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlSmartCompletionProvider {
    public void complete(CompletionParameters parameters2, CompletionResultSet result2, PsiElement element) {
        if (!XmlCompletionContributor.isXmlNameCompletion(parameters2)) {
            return;
        }
        result2.stopHere();
        if (!(element.getParent() instanceof XmlTag)) {
            return;
        }
        XmlTag tag = (XmlTag)element.getParent();
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return;
        }
        XmlContentDFA dfa = XmlContentDFA.getContentDFA(parentTag);
        if (dfa == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            for (XmlTag subTag : parentTag.getSubTags()) {
                if (subTag == tag) break;
                dfa.transition(subTag);
            }
            List<XmlElementDescriptor> elements = dfa.getPossibleElements();
            for (XmlElementDescriptor elementDescriptor : elements) {
                XmlSmartCompletionProvider.addElementToResult(elementDescriptor, result2);
            }
        });
    }

    private static void addElementToResult(@NotNull XmlElementDescriptor descriptor, CompletionResultSet result2) {
        String name;
        XmlTagInsertHandler insertHandler = XmlTagInsertHandler.INSTANCE;
        if (descriptor instanceof XmlElementDescriptorImpl && (name = descriptor.getName()) != null) {
            insertHandler = new ExtendedTagInsertHandler(name, ((XmlElementDescriptorImpl)descriptor).getNamespace(), null);
        }
        result2.addElement((LookupElement)XmlSmartCompletionProvider.createLookupElement(descriptor).withInsertHandler((InsertHandler)insertHandler));
    }

    public static LookupElementBuilder createLookupElement(@NotNull XmlElementDescriptor descriptor) {
        LookupElementBuilder builder = LookupElementBuilder.create((String)descriptor.getName());
        if (descriptor instanceof XmlElementDescriptorImpl) {
            builder = builder.withTypeText(((XmlElementDescriptorImpl)descriptor).getNamespace(), true);
        }
        return builder;
    }
}

