/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.FlatteningIterator;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiftShorterItemsClassifier
extends Classifier<LookupElement> {
    private final TreeSet<String> mySortedStrings = new TreeSet();
    private final MultiMap<String, LookupElement> myElements = LiftShorterItemsClassifier.createMultiMap(false);
    private final MultiMap<LookupElement, LookupElement> myToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final MultiMap<LookupElement, LookupElement> myReversedToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final LiftingCondition myCondition;
    private final boolean myLiftBefore;
    private int myCount = 0;

    public LiftShorterItemsClassifier(String name, Classifier<LookupElement> next, LiftingCondition condition2, boolean liftBefore) {
        super(next, name);
        this.myCondition = condition2;
        this.myLiftBefore = liftBefore;
    }

    @Override
    public void addElement(@NotNull LookupElement added, @NotNull ProcessingContext context) {
        ++this.myCount;
        for (String string : CompletionUtil.iterateLookupStrings(added)) {
            if (string.length() == 0) continue;
            this.myElements.putValue((Object)string, (Object)added);
            this.mySortedStrings.add(string);
            NavigableSet<String> after2 = this.mySortedStrings.tailSet(string, false);
            for (String s : after2) {
                if (!s.startsWith(string)) break;
                for (LookupElement longer : this.myElements.get((Object)s)) {
                    this.updateLongerItem(added, longer);
                }
            }
        }
        super.addElement(added, context);
        this.calculateToLift(added);
    }

    private void updateLongerItem(LookupElement shorter, LookupElement longer) {
        if (this.myCondition.shouldLift(shorter, longer)) {
            this.myToLift.putValue((Object)longer, (Object)shorter);
            this.myReversedToLift.putValue((Object)shorter, (Object)longer);
        }
    }

    private void calculateToLift(LookupElement element) {
        for (String string : CompletionUtil.iterateLookupStrings(element)) {
            for (int len = 1; len < string.length(); ++len) {
                String prefix = string.substring(0, len);
                for (LookupElement shorterElement : this.myElements.get((Object)prefix)) {
                    if (!this.myCondition.shouldLift(shorterElement, element)) continue;
                    this.myToLift.putValue((Object)element, (Object)shorterElement);
                    this.myReversedToLift.putValue((Object)shorterElement, (Object)element);
                }
            }
        }
    }

    @Override
    @NotNull
    public Iterable<LookupElement> classify(@NotNull Iterable<LookupElement> source, @NotNull ProcessingContext context) {
        return this.liftShorterElements(source, null, context);
    }

    private Iterable<LookupElement> liftShorterElements(Iterable<LookupElement> source, @Nullable THashSet<LookupElement> lifted, ProcessingContext context) {
        THashSet srcSet = ContainerUtil.newIdentityTroveSet((int)(source instanceof Collection ? ((Collection)source).size() : this.myCount));
        ContainerUtil.addAll((Collection)srcSet, source);
        if (srcSet.size() < 2) {
            return this.myNext.classify(source, context);
        }
        return new LiftingIterable((Set<LookupElement>)srcSet, context, source, lifted);
    }

    @Override
    @NotNull
    public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<LookupElement> items, @NotNull ProcessingContext context) {
        THashSet lifted = ContainerUtil.newIdentityTroveSet();
        Iterable<LookupElement> iterable = this.liftShorterElements(ContainerUtil.newArrayList(items), (THashSet<LookupElement>)lifted, context);
        return ContainerUtil.map(iterable, element -> new Pair(element, (Object)lifted.contains(element)));
    }

    @Override
    public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
        for (String s : CompletionUtil.iterateLookupStrings(element)) {
            this.myElements.remove((Object)s, (Object)element);
            if (!this.myElements.get((Object)s).isEmpty()) continue;
            this.mySortedStrings.remove(s);
        }
        LiftShorterItemsClassifier.removeFromMap(element, this.myToLift, this.myReversedToLift);
        LiftShorterItemsClassifier.removeFromMap(element, this.myReversedToLift, this.myToLift);
        super.removeElement(element, context);
    }

    private static void removeFromMap(LookupElement key2, MultiMap<LookupElement, LookupElement> mainMap, MultiMap<LookupElement, LookupElement> inverseMap) {
        Collection removed = mainMap.remove((Object)key2);
        if (removed == null) {
            return;
        }
        for (LookupElement reference : ContainerUtil.newArrayList((Iterable)removed)) {
            inverseMap.remove((Object)reference, (Object)key2);
        }
    }

    @NotNull
    private static <K, V> MultiMap<K, V> createMultiMap(final boolean identityKeys) {
        return new MultiMap<K, V>(){

            @NotNull
            protected Map<K, Collection<V>> createMap() {
                if (identityKeys) {
                    return ContainerUtil.newIdentityHashMap();
                }
                return ContainerUtil.newTroveMap();
            }

            public boolean remove(K key2, V value2) {
                List elements = (List)this.get(key2);
                int i2 = ContainerUtil.indexOfIdentity((List)elements, value2);
                if (i2 >= 0) {
                    elements.remove(i2);
                    if (elements.isEmpty()) {
                        this.remove(key2);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private class LiftingIterable
    implements Iterable<LookupElement> {
        private final Set<LookupElement> mySrcSet;
        private final ProcessingContext myContext;
        private final Iterable<LookupElement> mySource;
        private final THashSet<LookupElement> myLifted;

        public LiftingIterable(Set<LookupElement> srcSet, ProcessingContext context, Iterable<LookupElement> source, THashSet<LookupElement> lifted) {
            this.mySrcSet = srcSet;
            this.myContext = context;
            this.mySource = source;
            this.myLifted = lifted;
        }

        @Override
        public Iterator<LookupElement> iterator() {
            THashSet processed2 = ContainerUtil.newIdentityTroveSet((int)this.mySrcSet.size());
            THashSet arraysProcessed = ContainerUtil.newIdentityTroveSet();
            Iterable<LookupElement> next = LiftShorterItemsClassifier.this.myNext.classify(this.mySource, this.myContext);
            Iterator base = FilteringIterator.create(next.iterator(), arg_0 -> LiftingIterable.lambda$iterator$0((Set)processed2, arg_0));
            return new FlatteningIterator<LookupElement, LookupElement>(base, (Set)arraysProcessed, (Set)processed2){
                final /* synthetic */ Set val$arraysProcessed;
                final /* synthetic */ Set val$processed;
                {
                    this.val$arraysProcessed = set2;
                    this.val$processed = set3;
                    super(x0);
                }

                protected Iterator<LookupElement> createValueIterator(LookupElement element) {
                    List<LookupElement> shorter = this.addShorterElements(LiftShorterItemsClassifier.this.myToLift.get((Object)element));
                    List<LookupElement> singleton = Collections.singletonList(element);
                    if (shorter != null) {
                        if (LiftingIterable.this.myLifted != null) {
                            LiftingIterable.this.myLifted.addAll(shorter);
                        }
                        Iterable<LookupElement> lifted = LiftShorterItemsClassifier.this.myNext.classify(shorter, LiftingIterable.this.myContext);
                        return (LiftShorterItemsClassifier.this.myLiftBefore ? ContainerUtil.concat((Iterable[])new Iterable[]{lifted, singleton}) : ContainerUtil.concat((Iterable[])new Iterable[]{singleton, lifted})).iterator();
                    }
                    return singleton.iterator();
                }

                @Nullable
                private List<LookupElement> addShorterElements(@Nullable Collection<LookupElement> from) {
                    ArrayList<LookupElement> toLift = null;
                    if (from == null) {
                        return null;
                    }
                    if (this.val$arraysProcessed.add(from)) {
                        for (LookupElement shorterElement : from) {
                            if (!LiftingIterable.this.mySrcSet.contains(shorterElement) || !this.val$processed.add(shorterElement)) continue;
                            if (toLift == null) {
                                toLift = new ArrayList<LookupElement>();
                            }
                            toLift.add(shorterElement);
                        }
                    }
                    return toLift;
                }
            };
        }

        private static /* synthetic */ boolean lambda$iterator$0(Set processed2, LookupElement element) {
            return processed2.add(element);
        }
    }

    public static class LiftingCondition {
        public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
            return true;
        }
    }
}

