/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.codeInsight.controlflow.impl.ControlFlowImpl;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowBuilder {
    public List<Instruction> instructions = ContainerUtil.newArrayList();
    public Instruction prevInstruction;
    public List<Pair<PsiElement, Instruction>> pending = ContainerUtil.newArrayList();
    public int instructionCount = 0;

    @Nullable
    public Instruction findInstructionByElement(PsiElement element) {
        for (int i2 = this.instructions.size() - 1; i2 >= 0; --i2) {
            Instruction instruction = this.instructions.get(i2);
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    public void addEdge(Instruction beginInstruction, Instruction endInstruction) {
        if (beginInstruction == null || endInstruction == null) {
            return;
        }
        if (!beginInstruction.allSucc().contains(endInstruction)) {
            beginInstruction.allSucc().add(endInstruction);
        }
        if (!endInstruction.allPred().contains(beginInstruction)) {
            endInstruction.allPred().add(beginInstruction);
        }
    }

    public void addNode(Instruction instruction) {
        this.instructions.add(instruction);
        if (this.prevInstruction != null) {
            this.addEdge(this.prevInstruction, instruction);
        }
        this.prevInstruction = instruction;
    }

    public void flowAbrupted() {
        this.prevInstruction = null;
    }

    public void addPendingEdge(@Nullable PsiElement pendingScope, Instruction instruction) {
        int i2;
        if (instruction == null) {
            return;
        }
        if (pendingScope != null) {
            Pair<PsiElement, Instruction> pair;
            PsiElement scope;
            for (i2 = 0; i2 < this.pending.size() && ((scope = (PsiElement)(pair = this.pending.get(i2)).getFirst()) == null || PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)pendingScope, (boolean)true)); ++i2) {
            }
        }
        this.pending.add(i2, (Pair<PsiElement, Instruction>)Pair.create((Object)pendingScope, (Object)instruction));
    }

    public void checkPending(@NotNull Instruction instruction) {
        PsiElement element = instruction.getElement();
        if (element == null) {
            for (Pair<PsiElement, Instruction> pair : this.pending) {
                this.addEdge((Instruction)pair.getSecond(), instruction);
            }
            this.pending.clear();
        } else {
            for (int i2 = this.pending.size() - 1; i2 >= 0; --i2) {
                Pair<PsiElement, Instruction> pair = this.pending.get(i2);
                PsiElement scopeWhenToAdd = (PsiElement)pair.getFirst();
                if (scopeWhenToAdd == null) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)scopeWhenToAdd, (PsiElement)element, (boolean)false)) break;
                this.addEdge((Instruction)pair.getSecond(), instruction);
                this.pending.remove(i2);
            }
        }
    }

    public Instruction startNode(@Nullable PsiElement element) {
        InstructionImpl instruction = new InstructionImpl(this, element);
        this.addNode(instruction);
        this.checkPending(instruction);
        return instruction;
    }

    public Instruction startConditionalNode(PsiElement element, PsiElement condition2, boolean result2) {
        ConditionalInstructionImpl instruction = new ConditionalInstructionImpl(this, element, condition2, result2);
        this.addNode(instruction);
        this.checkPending(instruction);
        return instruction;
    }

    public ControlFlow build(PsiElementVisitor visitor, PsiElement element) {
        this.startNode(null);
        element.acceptChildren(visitor);
        this.checkPending(this.startNode(null));
        List<Instruction> result2 = this.instructions;
        return new ControlFlowImpl(result2.toArray(new Instruction[result2.size()]));
    }

    public void processPending(PendingProcessor processor2) {
        List<Pair<PsiElement, Instruction>> pending = this.pending;
        this.pending = new ArrayList<Pair<PsiElement, Instruction>>();
        for (Pair<PsiElement, Instruction> pair : pending) {
            processor2.process((PsiElement)pair.getFirst(), (Instruction)pair.getSecond());
        }
    }

    public static interface PendingProcessor {
        public void process(PsiElement var1, Instruction var2);
    }
}

