/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRainbowVisitor
extends RainbowVisitor {
    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        return file2 instanceof PsiJavaFile;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        PsiElement context;
        if ((element instanceof PsiReferenceExpression || element instanceof PsiLocalVariable || element instanceof PsiParameter || element instanceof PsiDocParamRef) && (context = PsiTreeUtil.findFirstParent((PsiElement)element, p -> p instanceof PsiMethod)) != null) {
            PsiElement rainbowElement;
            Object object = rainbowElement = element instanceof PsiReferenceExpression || element instanceof PsiDocParamRef ? element : ((PsiVariable)element).getNameIdentifier();
            PsiElement resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : (element instanceof PsiDocParamRef ? (element.getReference() == null ? null : element.getReference().resolve()) : element);
            HighlightInfo attrs = this.getRainbowSymbolKey(context, rainbowElement, resolved);
            this.addInfo(attrs);
        }
    }

    @Nullable
    private HighlightInfo getRainbowSymbolKey(@NotNull PsiElement context, PsiElement rainbowElement, PsiElement resolved) {
        String name;
        if (rainbowElement == null || resolved == null) {
            return null;
        }
        if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && (name = ((PsiVariable)resolved).getName()) != null) {
            return this.getInfo(context, rainbowElement, name, resolved instanceof PsiLocalVariable ? JavaHighlightingColors.LOCAL_VARIABLE_ATTRIBUTES : (rainbowElement instanceof PsiDocTagValue ? JavaHighlightingColors.DOC_COMMENT_TAG_VALUE : JavaHighlightingColors.PARAMETER_ATTRIBUTES));
        }
        return null;
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new JavaRainbowVisitor();
    }
}

