/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipRendererProvider;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipUtil;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeInsight.daemon.impl.ErrorStripeHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.PsiChangeHandler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.TogglePopupHintsPanel;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonListeners
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonListeners");
    private final Project myProject;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private final FileEditorManager myFileEditorManager;
    private final UndoManager myUndoManager;
    private final ProjectLevelVcsManager myProjectLevelVcsManager;
    private final VcsDirtyScopeManager myVcsDirtyScopeManager;
    private final FileStatusManager myFileStatusManager;
    @NotNull
    private final ActionManager myActionManager;
    private final TooltipController myTooltipController;
    private boolean myEscPressed;
    private volatile boolean cutOperationJustHappened;
    private final DaemonCodeAnalyzer.DaemonListener myDaemonEventPublisher;
    private static final Key<Boolean> DAEMON_INITIALIZED = Key.create((String)"DAEMON_INITIALIZED");
    private TogglePopupHintsPanel myTogglePopupHintsPanel;

    public static DaemonListeners getInstance(Project project2) {
        return (DaemonListeners)project2.getComponent(DaemonListeners.class);
    }

    public DaemonListeners(@NotNull Project project2, @NotNull DaemonCodeAnalyzerImpl daemonCodeAnalyzer, final @NotNull EditorTracker editorTracker, @NotNull EditorFactory editorFactory, @NotNull PsiDocumentManager psiDocumentManager, @NotNull CommandProcessor commandProcessor, @NotNull EditorColorsManager editorColorsManager, final @NotNull Application application, @NotNull ProjectInspectionProfileManager inspectionProjectProfileManager, @NotNull TodoConfiguration todoConfiguration, @NotNull ActionManagerEx actionManagerEx, @NotNull VirtualFileManager virtualFileManager, @NotNull NamedScopeManager namedScopeManager, @NotNull DependencyValidationManager dependencyValidationManager, final @NotNull FileDocumentManager fileDocumentManager, final @NotNull PsiManager psiManager, @NotNull FileEditorManager fileEditorManager, @NotNull TooltipController tooltipController, @NotNull UndoManager undoManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager, @NotNull VcsDirtyScopeManager vcsDirtyScopeManager, @NotNull FileStatusManager fileStatusManager) {
        this.myProject = project2;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myFileEditorManager = fileEditorManager;
        this.myUndoManager = undoManager;
        this.myProjectLevelVcsManager = projectLevelVcsManager;
        this.myVcsDirtyScopeManager = vcsDirtyScopeManager;
        this.myFileStatusManager = fileStatusManager;
        this.myActionManager = actionManagerEx;
        this.myTooltipController = tooltipController;
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, null, (Object)Boolean.TRUE);
        LOG.assertTrue(replaced, (Object)("Daemon listeners already initialized for the project " + this.myProject));
        MessageBus messageBus = this.myProject.getMessageBus();
        this.myDaemonEventPublisher = (DaemonCodeAnalyzer.DaemonListener)messageBus.syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC);
        if (project2.isDefault()) {
            return;
        }
        MessageBusConnection connection = messageBus.connect((Disposable)this);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                DaemonListeners.this.stopDaemon(false, "App closing");
            }
        });
        EditorEventMulticaster eventMulticaster = editorFactory.getEventMulticaster();
        eventMulticaster.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                Project project2;
                Document document = e.getDocument();
                VirtualFile virtualFile = fileDocumentManager.getFile(document);
                Project project3 = project2 = virtualFile == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
                if (!DaemonListeners.this.worthBothering(document, project2)) {
                    return;
                }
                DaemonListeners.this.stopDaemon(true, "Document change");
                UpdateHighlightersUtil.updateHighlightersByTyping(DaemonListeners.this.myProject, e);
            }
        }, (Disposable)this);
        eventMulticaster.addCaretListener((CaretListener)new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                Editor editor = e.getEditor();
                if (!editor.getComponent().isShowing() && !application.isUnitTestMode() || !DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                    return;
                }
                if (!application.isUnitTestMode()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!editor.getComponent().isShowing() || DaemonListeners.this.myProject.isDisposed()) {
                            return;
                        }
                        DaemonListeners.this.myDaemonCodeAnalyzer.hideLastIntentionHint();
                    }, ModalityState.current());
                }
            }
        }, (Disposable)this);
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)new MyEditorMouseMotionListener(), (Disposable)this);
        eventMulticaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(this.myTooltipController), (Disposable)this);
        EditorTrackerListener editorTrackerListener = new EditorTrackerListener(){
            private List<Editor> myActiveEditors = Collections.emptyList();

            @Override
            public void activeEditorsChanged(@NotNull List<Editor> editors) {
                List<Editor> activeEditors = editorTracker.getActiveEditors();
                if (this.myActiveEditors.equals(activeEditors)) {
                    return;
                }
                this.myActiveEditors = activeEditors;
                DaemonListeners.this.stopDaemon(true, "Active editor change");
                if (ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext()) {
                    DaemonListeners.this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(true);
                }
                for (Editor editor : activeEditors) {
                    DaemonListeners.repaintErrorStripeRenderer(editor, DaemonListeners.this.myProject);
                }
            }
        };
        editorTracker.addEditorTrackerListener(editorTrackerListener, this);
        EditorFactoryListener editorFactoryListener = new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                Editor editor = event.getEditor();
                Document document = editor.getDocument();
                Project editorProject = editor.getProject();
                PsiFile file2 = editorProject == null ? null : PsiDocumentManager.getInstance((Project)editorProject).getPsiFile(document);
                boolean showing = editor.getComponent().isShowing();
                boolean worthBothering = DaemonListeners.this.worthBothering(document, editorProject);
                if (!showing || !worthBothering) {
                    LOG.debug("Not worth bothering about editor created for : " + file2 + " because editor isShowing(): " + showing + "; project is open and file is mine: " + worthBothering);
                    return;
                }
                DaemonListeners.repaintErrorStripeRenderer(editor, DaemonListeners.this.myProject);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                UIUtil.invokeLaterIfNeeded(DaemonListeners.this.myDaemonCodeAnalyzer::hideLastIntentionHint);
            }
        };
        editorFactory.addEditorFactoryListener(editorFactoryListener, (Disposable)this);
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)psiDocumentManager;
        PsiChangeHandler changeHandler = new PsiChangeHandler(this.myProject, documentManager, editorFactory, connection, daemonCodeAnalyzer.getFileStatusMap());
        Disposer.register((Disposable)this, (Disposable)changeHandler);
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)changeHandler, (Disposable)changeHandler);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Project roots changed");
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode started");
            }

            public void exitDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode finished");
            }
        });
        connection.subscribe(PowerSaveMode.TOPIC, () -> this.stopDaemon(true, "Power save mode change"));
        connection.subscribe(EditorColorsManager.TOPIC, scheme2 -> this.stopDaemonAndRestartAllFiles("Editor color scheme changed"));
        commandProcessor.addCommandListener((CommandListener)new MyCommandListener(), (Disposable)this);
        application.addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)this);
        inspectionProjectProfileManager.addProfileChangeListener(new MyProfileChangeListener(), this);
        todoConfiguration.addPropertyChangeListener(new MyTodoListener(), this);
        todoConfiguration.colorSettingsChanged();
        actionManagerEx.addAnActionListener((AnActionListener)new MyAnActionListener(), (Disposable)this);
        virtualFileManager.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                String propertyName = event.getPropertyName();
                if ("name".equals(propertyName)) {
                    Document document;
                    PsiFile psiFile;
                    DaemonListeners.this.stopDaemonAndRestartAllFiles("Virtual file name changed");
                    VirtualFile virtualFile = event.getFile();
                    PsiFile psiFile2 = psiFile = !virtualFile.isValid() ? null : ((PsiManagerEx)psiManager).getFileManager().getCachedPsiFile(virtualFile);
                    if (psiFile != null && !DaemonListeners.this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile) && (document = fileDocumentManager.getCachedDocument(virtualFile)) != null) {
                        EditorColorsScheme editorColorScheme = null;
                        UpdateHighlightersUtil.setHighlightersToEditor(DaemonListeners.this.myProject, document, 0, document.getTextLength(), Collections.emptyList(), editorColorScheme, 4);
                    }
                }
                if (!propertyName.equals("writable")) {
                    DaemonListeners.this.stopDaemon(true, "Virtual file property change");
                }
            }
        }, (Disposable)this);
        ((EditorEventMulticasterEx)eventMulticaster).addErrorStripeListener(new ErrorStripeHandler(this.myProject), this);
        ModalityStateListener modalityStateListener = entering -> {
            boolean inModalContext = Registry.is((String)"ide.perProjectModality") || LaterInvocator.isInModalContext();
            this.stopDaemon(inModalContext, "Modality change. Was modal: " + inModalContext);
            this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(inModalContext);
        };
        LaterInvocator.addModalityStateListener(modalityStateListener, this);
        messageBus.connect().subscribe(SeverityRegistrar.SEVERITIES_CHANGED_TOPIC, () -> this.stopDaemonAndRestartAllFiles("Severities changed"));
        if (RefResolveService.ENABLED) {
            RefResolveService resolveService = RefResolveService.getInstance((Project)project2);
            resolveService.addListener((Disposable)this, new RefResolveService.Listener(){

                public void allFilesResolved() {
                    DaemonListeners.this.stopDaemon(true, "RefResolveService is up to date");
                }
            });
        }
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet renamed: " + oldName + " -> " + facet.getName());
            }

            public void facetAdded(@NotNull Facet facet) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet added: " + facet.getName());
            }

            public void facetRemoved(@NotNull Facet facet) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet removed: " + facet.getName());
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet changed: " + facet.getName());
            }
        });
    }

    private boolean worthBothering(Document document, Project project2) {
        if (document == null) {
            return true;
        }
        if (project2 != null && project2 != this.myProject) {
            return false;
        }
        PsiFile psiFile = this.myPsiDocumentManager.getCachedPsiFile(document);
        return psiFile != null && psiFile.getOriginalFile() == psiFile;
    }

    public void dispose() {
        this.stopDaemonAndRestartAllFiles("Project closed");
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
        LOG.assertTrue(replaced, (Object)("Daemon listeners already disposed for the project " + this.myProject));
    }

    public static boolean canChangeFileSilently(@NotNull PsiFileSystemItem file2) {
        Project project2 = file2.getProject();
        DaemonListeners listeners = DaemonListeners.getInstance(project2);
        if (listeners == null) {
            return true;
        }
        if (listeners.cutOperationJustHappened) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file2 instanceof PsiCodeFragment) {
            return true;
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project2, (VirtualFile)virtualFile, (boolean)false)) {
            return false;
        }
        Result vcs = listeners.vcsThinksItChanged(virtualFile);
        if (vcs == Result.CHANGED) {
            return true;
        }
        if (vcs == Result.UNCHANGED) {
            return false;
        }
        return listeners.canUndo(virtualFile);
    }

    private boolean canUndo(@NotNull VirtualFile virtualFile) {
        for (FileEditor editor : this.myFileEditorManager.getEditors(virtualFile)) {
            if (!this.myUndoManager.isUndoAvailable(editor)) continue;
            return true;
        }
        return false;
    }

    private Result vcsThinksItChanged(VirtualFile virtualFile) {
        boolean vcsIsThinking;
        AbstractVcs activeVcs = this.myProjectLevelVcsManager.getVcsFor(virtualFile);
        if (activeVcs == null) {
            return Result.NOT_SURE;
        }
        FilePath path = VcsUtil.getFilePath((VirtualFile)virtualFile);
        boolean bl = vcsIsThinking = !this.myVcsDirtyScopeManager.whatFilesDirty(Collections.singletonList(path)).isEmpty();
        if (vcsIsThinking) {
            return Result.NOT_SURE;
        }
        FileStatus status = this.myFileStatusManager.getStatus(virtualFile);
        if (status == FileStatus.UNKNOWN) {
            return Result.NOT_SURE;
        }
        return status == FileStatus.MODIFIED || status == FileStatus.ADDED ? Result.CHANGED : Result.UNCHANGED;
    }

    public void updateStatusBar() {
        if (this.myTogglePopupHintsPanel != null) {
            this.myTogglePopupHintsPanel.updateStatus();
        }
    }

    private void stopDaemon(boolean toRestartAlarm, @NonNls @NotNull String reason) {
        if (this.myDaemonCodeAnalyzer.stopProcess(toRestartAlarm, reason)) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    private void stopDaemonAndRestartAllFiles(@NotNull String reason) {
        if (this.myDaemonCodeAnalyzer.doRestart()) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    public static void repaintErrorStripeRenderer(@NotNull Editor editor, @NotNull Project project2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!project2.isInitialized()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        EditorMarkupModel markup = (EditorMarkupModel)editor.getMarkupModel();
        markup.setErrorPanelPopupHandler(new DaemonEditorPopup(psiFile));
        markup.setErrorStripTooltipRendererProvider(new DaemonTooltipRendererProvider(project2));
        markup.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().ERROR_STRIPE_MARK_MIN_HEIGHT);
        TrafficLightRenderer.setOrRefreshErrorStripeRenderer(markup, project2, document, psiFile);
    }

    private class MyEditorMouseMotionListener
    implements EditorMouseMotionListener {
        private MyEditorMouseMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(EditorMouseEvent e) {
            Editor editor = e.getEditor();
            if (DaemonListeners.this.myProject != editor.getProject()) {
                return;
            }
            if (editor.getComponent().getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING) != null) {
                return;
            }
            boolean shown = false;
            try {
                VisualPosition visual = editor.xyToVisualPosition(e.getMouseEvent().getPoint());
                if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(visual)) {
                    return;
                }
                LogicalPosition logical = editor.visualToLogicalPosition(visual);
                if (e.getArea() == EditorMouseEventArea.EDITING_AREA && !UIUtil.isControlKeyDown((MouseEvent)e.getMouseEvent())) {
                    int offset = editor.logicalPositionToOffset(logical);
                    if (editor.offsetToLogicalPosition((int)offset).column != logical.column) {
                        return;
                    }
                    HighlightInfo info = DaemonListeners.this.myDaemonCodeAnalyzer.findHighlightByOffset(editor.getDocument(), offset, false);
                    if (info == null || info.getDescription() == null) {
                        IdeTooltipManager.getInstance().hideCurrent(e.getMouseEvent());
                        return;
                    }
                    DaemonTooltipUtil.showInfoTooltip(info, editor, offset);
                    shown = true;
                }
            }
            finally {
                if (!shown && !DaemonListeners.this.myTooltipController.shouldSurvive(e.getMouseEvent())) {
                    DaemonTooltipUtil.cancelTooltips();
                }
            }
        }

        public void mouseDragged(EditorMouseEvent e) {
            DaemonListeners.this.myTooltipController.cancelTooltips();
        }
    }

    private static class MyEditorMouseListener
    extends EditorMouseAdapter {
        @NotNull
        private final TooltipController myTooltipController;

        MyEditorMouseListener(@NotNull TooltipController tooltipController) {
            this.myTooltipController = tooltipController;
        }

        public void mouseExited(EditorMouseEvent e) {
            if (!this.myTooltipController.shouldSurvive(e.getMouseEvent())) {
                DaemonTooltipUtil.cancelTooltips();
            }
        }
    }

    private class MyAnActionListener
    extends AnActionListener.Adapter {
        private final AnAction escapeAction;

        private MyAnActionListener() {
            this.escapeAction = DaemonListeners.this.myActionManager.getAction("EditorEscape");
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            DaemonListeners.this.myEscPressed = action == this.escapeAction;
        }

        public void beforeEditorTyping(char c, DataContext dataContext) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor != null && !DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Editor typing");
        }
    }

    private class MyProfileChangeListener
    implements ProfileChangeAdapter {
        private MyProfileChangeListener() {
        }

        public void profileChanged(InspectionProfile profile2) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile changed");
        }

        public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile2) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile activated");
        }

        public void profilesInitialized() {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (DaemonListeners.this.myProject.isDisposed()) {
                    return;
                }
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(DaemonListeners.this.myProject);
                DaemonListeners.this.myTogglePopupHintsPanel = new TogglePopupHintsPanel(DaemonListeners.this.myProject);
                statusBar.addWidget((StatusBarWidget)DaemonListeners.this.myTogglePopupHintsPanel, (Disposable)DaemonListeners.this.myProject);
                DaemonListeners.this.updateStatusBar();
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Inspection profiles activated");
            });
        }
    }

    private class MyTodoListener
    implements PropertyChangeListener {
        private MyTodoListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if ("todoPatterns".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo patterns changed");
            }
        }
    }

    private class MyCommandListener
    extends CommandAdapter {
        private final String myCutActionName;

        private MyCommandListener() {
            this.myCutActionName = DaemonListeners.this.myActionManager.getAction("EditorCut").getTemplatePresentation().getText();
        }

        public void commandStarted(CommandEvent event) {
            Document affectedDocument = this.extractDocumentFromCommand(event);
            if (!DaemonListeners.this.worthBothering(affectedDocument, event.getProject())) {
                return;
            }
            DaemonListeners.this.cutOperationJustHappened = this.myCutActionName.equals(event.getCommandName());
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling code highlighting by command:" + event.getCommand());
            }
            DaemonListeners.this.stopDaemon(false, "Command start");
        }

        @Nullable
        private Document extractDocumentFromCommand(CommandEvent event) {
            Document affectedDocument = event.getDocument();
            if (affectedDocument != null) {
                return affectedDocument;
            }
            Object id = event.getCommandGroupId();
            if (id instanceof Document) {
                affectedDocument = (Document)id;
            } else if (id instanceof DocCommandGroupId) {
                affectedDocument = ((DocCommandGroupId)id).getDocument();
            }
            return affectedDocument;
        }

        public void commandFinished(CommandEvent event) {
            Document affectedDocument = this.extractDocumentFromCommand(event);
            if (!DaemonListeners.this.worthBothering(affectedDocument, event.getProject())) {
                return;
            }
            if (DaemonListeners.this.myEscPressed) {
                DaemonListeners.this.myEscPressed = false;
                if (affectedDocument != null && !DaemonListeners.this.myDaemonCodeAnalyzer.getFileStatusMap().allDirtyScopesAreNull(affectedDocument)) {
                    DaemonListeners.this.stopDaemon(true, "Command finish");
                }
            } else if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                DaemonListeners.this.stopDaemon(true, "Command finish");
            }
        }
    }

    private class MyApplicationListener
    extends ApplicationAdapter {
        private boolean myDaemonWasRunning;

        private MyApplicationListener() {
        }

        public void beforeWriteActionStart(@NotNull Object action) {
            this.myDaemonWasRunning = DaemonListeners.this.myDaemonCodeAnalyzer.isRunning();
            if (!this.myDaemonWasRunning) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Write action start");
        }

        public void writeActionFinished(@NotNull Object action) {
            DaemonListeners.this.stopDaemon(true, "Write action finish");
        }
    }

    private static enum Result {
        CHANGED,
        UNCHANGED,
        NOT_SURE;

    }
}

