/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightInfoProcessor
extends HighlightInfoProcessor {
    private final Alarm repaintIconAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    @Override
    public void highlightsInsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @NotNull List<HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictRange, int groupId) {
        PsiFile psiFile = session2.getPsiFile();
        Project project2 = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (document == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        TextRange priorityIntersection = priorityRange.intersection(restrictRange);
        Editor editor = session2.getEditor();
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (modificationStamp != document.getModificationStamp()) {
                return;
            }
            if (priorityIntersection != null) {
                MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project2, true);
                EditorColorsScheme scheme2 = session2.getColorsScheme();
                UpdateHighlightersUtil.setHighlightersInRange(project2, document, priorityIntersection, scheme2, infos, (MarkupModelEx)markupModel, groupId);
            }
            if (editor != null && !editor.isDisposed()) {
                if (!DumbService.isDumb((Project)project2)) {
                    new ShowAutoImportPass(project2, psiFile, editor).doApplyInformationToEditor();
                }
                DaemonListeners.repaintErrorStripeRenderer(editor, project2);
            }
        });
    }

    @Override
    public void highlightsOutsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @NotNull List<HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        PsiFile psiFile = session2.getPsiFile();
        Project project2 = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (document == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (project2.isDisposed() || modificationStamp != document.getModificationStamp()) {
                return;
            }
            EditorColorsScheme scheme2 = session2.getColorsScheme();
            UpdateHighlightersUtil.setHighlightersOutsideRange(project2, document, psiFile, infos, scheme2, restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), ProperTextRange.create((Segment)priorityRange), groupId);
            Editor editor = session2.getEditor();
            if (editor != null) {
                DaemonListeners.repaintErrorStripeRenderer(editor, project2);
            }
        });
    }

    @Override
    public void allHighlightsForRangeAreProduced(@NotNull HighlightingSession session2, @NotNull TextRange elementRange, @Nullable List<HighlightInfo> infos) {
        PsiFile psiFile = session2.getPsiFile();
        DefaultHighlightInfoProcessor.killAbandonedHighlightsUnder(psiFile, elementRange, infos, session2);
    }

    private static void killAbandonedHighlightsUnder(@NotNull PsiFile psiFile, @NotNull TextRange range, @Nullable List<HighlightInfo> infos, @NotNull HighlightingSession highlightingSession) {
        Project project2 = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (document == null) {
            return;
        }
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, range.getStartOffset(), range.getEndOffset(), (Processor<HighlightInfo>)((Processor)existing -> {
            if (existing.isBijective() && existing.getGroup() == 4 && range.equalsToRange(existing.getActualStartOffset(), existing.getActualEndOffset())) {
                if (infos != null) {
                    for (HighlightInfo created : infos) {
                        if (!existing.equalsByActualOffset(created)) continue;
                        return true;
                    }
                }
                ((HighlightingSessionImpl)highlightingSession).queueDisposeHighlighterFor((HighlightInfo)existing);
            }
            return true;
        }));
    }

    @Override
    public void infoIsAvailable(@NotNull HighlightingSession session2, @NotNull HighlightInfo info, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        HighlightingSessionImpl impl = (HighlightingSessionImpl)session2;
        impl.queueHighlightInfo(info, restrictedRange, groupId);
    }

    @Override
    public void progressIsAdvanced(@NotNull HighlightingSession highlightingSession, double progress) {
        PsiFile file2 = highlightingSession.getPsiFile();
        Editor editor = highlightingSession.getEditor();
        this.repaintTrafficIcon(file2, editor, progress);
    }

    private void repaintTrafficIcon(@NotNull PsiFile file2, Editor editor, double progress) {
        if (ApplicationManager.getApplication().isCommandLine()) {
            return;
        }
        if (this.repaintIconAlarm.isEmpty() || progress >= 1.0) {
            this.repaintIconAlarm.addRequest(() -> {
                Project myProject = file2.getProject();
                if (myProject.isDisposed()) {
                    return;
                }
                Editor myeditor = editor;
                if (myeditor == null) {
                    myeditor = PsiUtilBase.findEditor((PsiElement)file2);
                }
                if (myeditor == null || myeditor.isDisposed()) {
                    return;
                }
                EditorMarkupModelImpl markup = (EditorMarkupModelImpl)myeditor.getMarkupModel();
                markup.repaintTrafficLightIcon();
                DaemonListeners.repaintErrorStripeRenderer(myeditor, myProject);
            }, 50, null);
        }
    }
}

