/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightUtil {
    @Nullable
    public static HighlightInfo checkBadCharacter(@NotNull PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null && node.getElementType() == TokenType.BAD_CHARACTER) {
            char c = element.textToCharArray()[0];
            boolean printable = StringUtil.isPrintableUnicode((char)c) && !Character.isSpaceChar(c);
            String hex = String.format("U+%04X", c);
            String text = "Illegal character: " + (printable ? c + " (" + hex + ")" : hex);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(text).create();
        }
        return null;
    }
}

