/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionProvider;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EditorNotificationActions {
    public static void collectDescriptorsForEditor(@NotNull Editor editor, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors) {
        Project project2 = editor.getProject();
        if (project2 == null) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        if (!(fileEditorManager instanceof FileEditorManagerImpl)) {
            return;
        }
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        List<JComponent> components = ((FileEditorManagerImpl)fileEditorManager).getTopComponents((FileEditor)fileEditor);
        for (JComponent component : components) {
            IntentionActionWithOptions action;
            if (!(component instanceof IntentionActionProvider) || (action = ((IntentionActionProvider)component).getIntentionAction()) == null) continue;
            descriptors.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)action, action.getOptions(), null));
        }
    }
}

