/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusMap
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.FileStatusMap");
    public static final String CHANGES_NOT_ALLOWED_DURING_HIGHLIGHTING = "PSI/document/model changes are not allowed during highlighting";
    private final Project myProject;
    private final Map<Document, FileStatus> myDocumentToStatusMap = new WeakHashMap();
    private volatile boolean myAllowDirt = true;
    private static final RangeMarker WHOLE_FILE_DIRTY_MARKER = new RangeMarker(){

        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        public int getStartOffset() {
            throw new UnsupportedOperationException();
        }

        public int getEndOffset() {
            throw new UnsupportedOperationException();
        }

        public boolean isValid() {
            return false;
        }

        public void setGreedyToLeft(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public void setGreedyToRight(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToRight() {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToLeft() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
        }

        public <T> T getUserData(@NotNull Key<T> key2) {
            return null;
        }

        public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "WHOLE_FILE";
        }
    };
    private static final ConcurrentMap<Thread, Integer> threads = new ConcurrentHashMap<Thread, Integer>();

    public FileStatusMap(@NotNull Project project2) {
        this.myProject = project2;
    }

    public void dispose() {
        this.markAllFilesDirty("FileStatusMap dispose");
    }

    @Nullable(value="null means the file is clean")
    public static TextRange getDirtyTextRange(@NotNull Editor editor, int passId) {
        Document document = editor.getDocument();
        FileStatusMap me = DaemonCodeAnalyzerEx.getInstanceEx(editor.getProject()).getFileStatusMap();
        TextRange dirtyScope = me.getFileDirtyScope(document, passId);
        if (dirtyScope == null) {
            return null;
        }
        TextRange documentRange = TextRange.from((int)0, (int)document.getTextLength());
        return documentRange.intersection(dirtyScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorFoundFlag(@NotNull Project project2, @NotNull Document document, boolean errorFound) {
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                if (!errorFound) {
                    return;
                }
                status = new FileStatus(project2);
                this.myDocumentToStatusMap.put(document, status);
            }
            status.errorFound = errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasErrorFound(@NotNull Document document) {
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && status.errorFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAllFilesDirty(@NotNull @NonNls Object reason) {
        this.assertAllowModifications();
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            if (!this.myDocumentToStatusMap.isEmpty()) {
                FileStatusMap.log("Mark all dirty: ", reason);
            }
            this.myDocumentToStatusMap.clear();
        }
    }

    private void assertAllowModifications() {
        try {
            assert (this.myAllowDirt) : "PSI/document/model changes are not allowed during highlighting";
        }
        finally {
            this.myAllowDirt = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileUpToDate(@NotNull Document document, int passId) {
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.computeIfAbsent(document, __ -> new FileStatus(this.myProject));
            status.defensivelyMarked = false;
            if (passId == 9) {
                status.wolfPassFinished = true;
            } else if (status.dirtyScopes.containsKey(passId)) {
                status.setDirtyScope(passId, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, int passId) {
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
                return null;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return file2 == null ? null : file2.getTextRange();
            }
            if (status.defensivelyMarked) {
                status.markWholeFileDirty(this.myProject);
                status.defensivelyMarked = false;
            }
            if (!status.dirtyScopes.containsKey(passId)) {
                throw new IllegalStateException("Unknown pass " + passId);
            }
            RangeMarker marker = (RangeMarker)status.dirtyScopes.get(passId);
            TextRange textRange = marker == null ? null : (marker.isValid() ? TextRange.create((Segment)marker) : new TextRange(0, document.getTextLength()));
            return textRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirtyDefensively(@NotNull PsiFile file2, @NotNull @NonNls Object reason) {
        this.assertAllowModifications();
        FileStatusMap.log("Mark dirty file defensively: ", file2.getName(), reason);
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file2);
            if (document == null) {
                return;
            }
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            status.defensivelyMarked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFileScopeDirty(@NotNull Document document, @NotNull TextRange scope, int fileLength, @NotNull @NonNls Object reason) {
        this.assertAllowModifications();
        FileStatusMap.log("Mark scope dirty: ", scope, reason);
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            if (status == null) {
                return;
            }
            if (status.defensivelyMarked) {
                status.defensivelyMarked = false;
            }
            status.combineScopesWith(scope, fileLength, document);
        }
    }

    @NotNull
    private static RangeMarker combineScopes(RangeMarker old, @NotNull TextRange scope, int textLength, @NotNull Document document) {
        if (old == null) {
            if (scope.equalsToRange(0, textLength)) {
                return WHOLE_FILE_DIRTY_MARKER;
            }
            return document.createRangeMarker(scope);
        }
        if (old == WHOLE_FILE_DIRTY_MARKER) {
            return old;
        }
        TextRange oldRange = TextRange.create((Segment)old);
        TextRange union = scope.union(oldRange);
        if (old.isValid() && union.equals((Object)oldRange)) {
            return old;
        }
        if (union.getEndOffset() > textLength) {
            union = union.intersection(new TextRange(0, textLength));
        }
        assert (union != null);
        return document.createRangeMarker(union);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allDirtyScopesAreNull(@NotNull Document document) {
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            FileStatus status = this.myDocumentToStatusMap.get(document);
            return status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAllDirtyScopesAreNull(@NotNull Document document) {
        Map<Document, FileStatus> map2 = this.myDocumentToStatusMap;
        synchronized (map2) {
            FileStatus status = this.myDocumentToStatusMap.get(document);
            assert (status != null && !status.defensivelyMarked && status.wolfPassFinished && status.allDirtyScopesAreNull()) : status;
        }
    }

    void allowDirt(boolean allow) {
        this.myAllowDirt = allow;
    }

    private static int getThreadNum() {
        return (Integer)ConcurrencyUtil.cacheOrGet(threads, (Object)Thread.currentThread(), (Object)threads.size());
    }

    public static void log(Object ... info) {
        if (LOG.isDebugEnabled()) {
            String s = StringUtil.repeatSymbol((char)' ', (int)(FileStatusMap.getThreadNum() * 4)) + Arrays.asList(info) + "\n";
            LOG.debug(s);
        }
    }

    private static class FileStatus {
        private boolean defensivelyMarked;
        private boolean wolfPassFinished;
        private final TIntObjectHashMap<RangeMarker> dirtyScopes = new TIntObjectHashMap();
        private boolean errorFound;

        private FileStatus(@NotNull Project project2) {
            this.markWholeFileDirty(project2);
        }

        private void markWholeFileDirty(@NotNull Project project2) {
            this.setDirtyScope(4, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(8, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(7, WHOLE_FILE_DIRTY_MARKER);
            this.setDirtyScope(11, WHOLE_FILE_DIRTY_MARKER);
            TextEditorHighlightingPassRegistrarEx registrar = (TextEditorHighlightingPassRegistrarEx)TextEditorHighlightingPassRegistrar.getInstance(project2);
            for (DirtyScopeTrackingHighlightingPassFactory factory : registrar.getDirtyScopeTrackingFactories()) {
                this.setDirtyScope(factory.getPassId(), WHOLE_FILE_DIRTY_MARKER);
            }
        }

        private boolean allDirtyScopesAreNull() {
            for (Object o : this.dirtyScopes.getValues()) {
                if (o == null) continue;
                return false;
            }
            return true;
        }

        private void combineScopesWith(@NotNull TextRange scope, int fileLength, @NotNull Document document) {
            this.dirtyScopes.transformValues(oldScope -> {
                RangeMarker newScope = FileStatusMap.combineScopes(oldScope, scope, fileLength, document);
                if (newScope != oldScope && oldScope != null) {
                    oldScope.dispose();
                }
                return newScope;
            });
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("defensivelyMarked = ").append(this.defensivelyMarked);
            s.append("; wolfPassFinfished = ").append(this.wolfPassFinished);
            s.append("; errorFound = ").append(this.errorFound);
            s.append("; dirtyScopes: (");
            this.dirtyScopes.forEachEntry((passId, rangeMarker) -> {
                s.append(" pass: ").append(passId).append(" -> ").append((Object)(rangeMarker == WHOLE_FILE_DIRTY_MARKER ? "Whole file" : rangeMarker)).append(";");
                return true;
            });
            s.append(")");
            return s.toString();
        }

        private void setDirtyScope(int passId, RangeMarker scope) {
            RangeMarker marker = (RangeMarker)this.dirtyScopes.get(passId);
            if (marker != scope) {
                if (marker != null) {
                    marker.dispose();
                }
                this.dirtyScopes.put(passId, (Object)scope);
            }
        }
    }
}

