/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingSessionImpl
implements HighlightingSession {
    @NotNull
    private final PsiFile myPsiFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    private final Map<TextRange, RangeMarker> myRanges2markersCache = new THashMap();
    private final TransferToEDTQueue<Runnable> myEDTQueue;
    private static final Key<ConcurrentMap<PsiFile, HighlightingSession>> HIGHLIGHTING_SESSION = Key.create((String)"HIGHLIGHTING_SESSION");

    private HighlightingSessionImpl(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, EditorColorsScheme editorColorsScheme) {
        this.myPsiFile = psiFile;
        this.myEditor = editor;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myProject = psiFile.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
        this.myEDTQueue = new TransferToEDTQueue("Apply highlighting results", runnable2 -> {
            runnable2.run();
            return true;
        }, o -> this.myProject.isDisposed() || this.getProgressIndicator().isCanceled(), 200);
    }

    void applyInEDT(@NotNull Runnable runnable2) {
        this.myEDTQueue.offer((Object)runnable2);
    }

    public static HighlightingSession getHighlightingSession(@NotNull PsiFile psiFile, @NotNull ProgressIndicator progressIndicator) {
        Map map2 = (Map)((DaemonProgressIndicator)progressIndicator).getUserData(HIGHLIGHTING_SESSION);
        return map2 == null ? null : (HighlightingSession)map2.get(psiFile);
    }

    @NotNull
    static HighlightingSession getOrCreateHighlightingSession(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme) {
        HighlightingSession session2 = HighlightingSessionImpl.getHighlightingSession(psiFile, progressIndicator);
        if (session2 == null) {
            ConcurrentMap map2 = (ConcurrentMap)progressIndicator.getUserData(HIGHLIGHTING_SESSION);
            if (map2 == null) {
                map2 = (ConcurrentMap)progressIndicator.putUserDataIfAbsent(HIGHLIGHTING_SESSION, ContainerUtil.newConcurrentMap());
            }
            session2 = (HighlightingSession)ConcurrencyUtil.cacheOrGet((ConcurrentMap)map2, (Object)psiFile, (Object)new HighlightingSessionImpl(psiFile, editor, progressIndicator, editorColorsScheme));
        }
        return session2;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    void queueHighlightInfo(@NotNull HighlightInfo info, @NotNull TextRange restrictedRange, int groupId) {
        this.myEDTQueue.offer(() -> {
            EditorColorsScheme colorsScheme = this.getColorsScheme();
            UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.myProject, this.getDocument(), this.getPsiFile(), restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), info, colorsScheme, groupId, this.myRanges2markersCache);
        });
    }

    void queueDisposeHighlighterFor(@NotNull HighlightInfo info) {
        RangeHighlighterEx highlighter = info.getHighlighter();
        if (highlighter == null) {
            return;
        }
        this.myEDTQueue.offer(() -> {
            Object actualInfo = highlighter.getErrorStripeTooltip();
            if (actualInfo == info && info.getHighlighter() == highlighter) {
                highlighter.dispose();
            }
        });
    }

    void waitForHighlightInfosApplied() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEDTQueue.drain();
    }
}

