/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ProjectIconsAccessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element instanceof PsiAssignmentExpression) {
            PsiElement var;
            PsiExpression lExpression = ((PsiAssignmentExpression)element).getLExpression();
            PsiExpression expr = ((PsiAssignmentExpression)element).getRExpression();
            if (lExpression instanceof PsiReferenceExpression && (var = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
                return IconLineMarkerProvider.createIconLineMarker(((PsiVariable)var).getType(), expr);
            }
        } else if (element instanceof PsiReturnStatement) {
            PsiReturnStatement psiReturnStatement = (PsiReturnStatement)element;
            PsiExpression value2 = psiReturnStatement.getReturnValue();
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method2 != null) {
                PsiType returnType = method2.getReturnType();
                LineMarkerInfo<PsiElement> result2 = IconLineMarkerProvider.createIconLineMarker(returnType, value2);
                if (result2 != null || !ProjectIconsAccessor.isIconClassType(returnType) || value2 == null) {
                    return result2;
                }
                if (IconLineMarkerProvider.methodContainsReturnStatementOnly(method2)) {
                    for (PsiReference ref : value2.getReferences()) {
                        PsiElement field = ref.resolve();
                        if (!(field instanceof PsiField)) continue;
                        return IconLineMarkerProvider.createIconLineMarker(returnType, ((PsiField)field).getInitializer(), (PsiElement)psiReturnStatement);
                    }
                }
            }
        } else if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            PsiUtilCore.ensureValid((PsiElement)var);
            PsiType type2 = var.getType();
            if (!type2.isValid()) {
                PsiUtil.ensureValidType((PsiType)type2, (String)("in variable: " + var + " of " + var.getClass()));
            }
            return IconLineMarkerProvider.createIconLineMarker(type2, var.getInitializer());
        }
        return null;
    }

    private static boolean methodContainsReturnStatementOnly(@NotNull PsiMethod method2) {
        PsiCodeBlock body2 = method2.getBody();
        if (body2 == null || body2.getStatements().length != 1) {
            return false;
        }
        return body2.getStatements()[0] instanceof PsiReturnStatement;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createIconLineMarker(PsiType type2, @Nullable PsiExpression initializer) {
        return IconLineMarkerProvider.createIconLineMarker(type2, initializer, (PsiElement)initializer);
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createIconLineMarker(PsiType type2, @Nullable PsiExpression initializer, PsiElement bindingElement) {
        if (initializer == null) {
            return null;
        }
        final Project project2 = initializer.getProject();
        final VirtualFile file2 = ProjectIconsAccessor.getInstance(project2).resolveIconFile(type2, initializer);
        if (file2 == null) {
            return null;
        }
        Icon icon = ProjectIconsAccessor.getInstance(project2).getIcon(file2);
        if (icon == null) {
            return null;
        }
        GutterIconNavigationHandler<PsiElement> navHandler = new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                FileEditorManager.getInstance((Project)project2).openFile(file2, true);
            }
        };
        return new LineMarkerInfo(bindingElement, bindingElement.getTextRange(), icon, 11, null, (GutterIconNavigationHandler)navHandler, GutterIconRenderer.Alignment.LEFT);
    }

    @NotNull
    public String getName() {
        return "Icon preview";
    }

    public boolean isEnabledByDefault() {
        return DaemonCodeAnalyzerSettings.getInstance().SHOW_SMALL_ICONS_IN_GUTTER;
    }
}

