/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.concurrency.JobLauncher;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineMarkerProvider
extends LineMarkerProviderDescriptor {
    protected final DaemonCodeAnalyzerSettings myDaemonSettings;
    protected final EditorColorsManager myColorsManager;
    private final GutterIconDescriptor.Option myLambdaOption = new GutterIconDescriptor.Option("java.lambda", "Lambda", AllIcons.Gutter.ImplementingFunctionalInterface);
    private final GutterIconDescriptor.Option myOverriddenOption = new GutterIconDescriptor.Option("java.overridden", "Overridden method", AllIcons.Gutter.OverridenMethod);
    private final GutterIconDescriptor.Option myImplementedOption = new GutterIconDescriptor.Option("java.implemented", "Implemented method", AllIcons.Gutter.ImplementedMethod);
    private final GutterIconDescriptor.Option myOverridingOption = new GutterIconDescriptor.Option("java.overriding", "Overriding method", AllIcons.Gutter.OverridingMethod);
    private final GutterIconDescriptor.Option myImplementingOption = new GutterIconDescriptor.Option("java.implementing", "Implementing method", AllIcons.Gutter.ImplementingMethod);

    public JavaLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiMethod) {
            if (!this.myOverridingOption.isEnabled() && !this.myImplementingOption.isEnabled()) {
                return null;
            }
            PsiMethod method2 = (PsiMethod)parent;
            MethodSignatureBackedByPsiMethod superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method2, null, (boolean)true, (boolean)false).findFirst();
            if (superSignature != null) {
                Icon icon;
                boolean overrides;
                boolean bl = overrides = method2.hasModifierProperty("abstract") == superSignature.getMethod().hasModifierProperty("abstract");
                if (overrides) {
                    if (!this.myOverridingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.OverridingMethod;
                } else {
                    if (!this.myImplementingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.ImplementingMethod;
                }
                return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(element, icon, 11);
            }
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
        PsiElement firstChild = element.getFirstChild();
        if (interfaceMethod != null && firstChild != null && this.myLambdaOption.isEnabled()) {
            return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(firstChild, AllIcons.Gutter.ImplementingFunctionalInterface, 11);
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && firstChild == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                PsiFile file2 = element1.getContainingFile();
                Document document = file2 == null ? null : PsiDocumentManager.getInstance((Project)file2.getProject()).getLastCommittedDocument(file2);
                boolean drawSeparator = false;
                if (document != null) {
                    CharSequence documentChars = document.getCharsSequence();
                    int category = JavaLineMarkerProvider.getCategory(element1, documentChars);
                    for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                        int category1 = JavaLineMarkerProvider.getCategory(child, documentChars);
                        if (category1 == 0) continue;
                        drawSeparator = category != 1 || category1 != 1;
                        break;
                    }
                }
                if (drawSeparator) {
                    LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme2 = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme2.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createSuperMethodLineMarkerInfo(@NotNull PsiElement name, @NotNull Icon icon, int passId) {
        ArrowUpLineMarkerInfo info = new ArrowUpLineMarkerInfo(name, icon, MarkerType.OVERRIDING_METHOD, passId);
        return NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Go to super method", (String)"GotoSuperMethod");
    }

    private static int getCategory(@NotNull PsiElement element, @NotNull CharSequence documentChars) {
        if (element instanceof PsiField || element instanceof PsiTypeParameter) {
            return 1;
        }
        if (element instanceof PsiClass || element instanceof PsiClassInitializer) {
            return 2;
        }
        if (element instanceof PsiMethod) {
            int end;
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return 1;
            }
            TextRange textRange = element.getTextRange();
            int start = textRange.getStartOffset();
            int crlf = StringUtil.getLineBreakCount((CharSequence)documentChars.subSequence(start, end = Math.min(documentChars.length(), textRange.getEndOffset())));
            return crlf == 0 ? 1 : 2;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<Computable> tasks = new ArrayList<Computable>();
        MultiMap byClass = MultiMap.create();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            ProgressManager.checkCanceled();
            if (!(element instanceof PsiIdentifier)) continue;
            PsiElement parent = element.getParent();
            if (parent instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)parent;
                PsiClass psiClass = method2.getContainingClass();
                if (!PsiUtil.canBeOverriden((PsiMethod)method2) || psiClass == null) continue;
                byClass.putValue((Object)psiClass, (Object)method2);
                continue;
            }
            if (!(parent instanceof PsiClass) || parent instanceof PsiTypeParameter) continue;
            tasks.add(() -> this.collectInheritingClasses((PsiClass)parent));
        }
        for (PsiClass psiClass : byClass.keySet()) {
            Collection methods = byClass.get((Object)psiClass);
            tasks.add(() -> JavaLineMarkerProvider.collectSiblingInheritedMethods(methods));
            tasks.add(() -> this.collectOverridingMethods(methods, psiClass));
        }
        Object lock = new Object();
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(tasks, indicator, true, computable -> {
            List infos = (List)computable.compute();
            Object object = lock;
            synchronized (object) {
                result2.addAll(infos);
            }
            return true;
        });
    }

    private static List<LineMarkerInfo> collectSiblingInheritedMethods(@NotNull Collection<PsiMethod> methods) {
        Map<PsiMethod, FindSuperElementsHelper.SiblingInfo> map2 = FindSuperElementsHelper.getSiblingInheritanceInfos(methods);
        return ContainerUtil.map(map2.keySet(), method2 -> {
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method2);
            ArrowUpLineMarkerInfo upInfo = new ArrowUpLineMarkerInfo(range, AllIcons.Gutter.SiblingInheritedMethod, MarkerType.SIBLING_OVERRIDING_METHOD, 11);
            return NavigateAction.setNavigateAction((LineMarkerInfo)upInfo, (String)"Go to super method", (String)"GotoSuperMethod");
        });
    }

    @NotNull
    private static PsiElement getMethodRange(@NotNull PsiMethod method2) {
        PsiIdentifier range;
        if (method2.isPhysical()) {
            range = method2.getNameIdentifier();
        } else {
            PsiElement navigationElement = method2.getNavigationElement();
            PsiElement psiElement = range = navigationElement instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier() : navigationElement;
        }
        if (range == null) {
            range = method2;
        }
        return range;
    }

    protected List<LineMarkerInfo> collectInheritingClasses(@NotNull PsiClass aClass) {
        if (aClass.hasModifierProperty("final")) {
            return Collections.emptyList();
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return Collections.emptyList();
        }
        PsiClass subClass = (PsiClass)DirectClassInheritorsSearch.search((PsiClass)aClass).findFirst();
        if (subClass != null || FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null) {
            Icon icon;
            if (aClass.isInterface()) {
                if (!this.myImplementedOption.isEnabled()) {
                    return Collections.emptyList();
                }
                icon = AllIcons.Gutter.ImplementedMethod;
            } else {
                if (!this.myOverriddenOption.isEnabled()) {
                    return Collections.emptyList();
                }
                icon = AllIcons.Gutter.OverridenMethod;
            }
            PsiIdentifier range = aClass.getNameIdentifier();
            if (range == null) {
                range = aClass;
            }
            MarkerType type2 = MarkerType.SUBCLASSED_CLASS;
            LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, 11, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(aClass.isInterface() ? "Go to implementation(s)" : "Go to subclass(es)"), (String)"GotoImplementation");
            return Collections.singletonList(info);
        }
        return Collections.emptyList();
    }

    private List<LineMarkerInfo> collectOverridingMethods(@NotNull Iterable<PsiMethod> _methods, @NotNull PsiClass containingClass) {
        PsiMethod interfaceMethod;
        if (!this.myOverriddenOption.isEnabled() && !this.myImplementedOption.isEnabled()) {
            return Collections.emptyList();
        }
        com.intellij.util.containers.HashSet overridden = new com.intellij.util.containers.HashSet();
        HashSet methodSet = ContainerUtil.newHashSet(_methods);
        AllOverridingMethodsSearch.search((PsiClass)containingClass).forEach(arg_0 -> JavaLineMarkerProvider.lambda$collectOverridingMethods$5(methodSet, (Set)overridden, arg_0));
        if (!methodSet.isEmpty() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)containingClass)) != null && FunctionalExpressionSearch.search((PsiClass)containingClass).findFirst() != null) {
            overridden.add(interfaceMethod);
        }
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>();
        for (PsiMethod method2 : overridden) {
            boolean overrides;
            ProgressManager.checkCanceled();
            boolean bl = overrides = !method2.hasModifierProperty("abstract");
            if (overrides ? !this.myOverriddenOption.isEnabled() : !this.myImplementedOption.isEnabled()) {
                return Collections.emptyList();
            }
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method2);
            MarkerType type2 = MarkerType.OVERRIDDEN_METHOD;
            Icon icon = overrides ? AllIcons.Gutter.OverridenMethod : AllIcons.Gutter.ImplementedMethod;
            LineMarkerInfo info = new LineMarkerInfo(range, range.getTextRange(), icon, 11, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(overrides ? "Go to overriding methods" : "Go to implementation(s)"), (String)"GotoImplementation");
            result2.add(info);
        }
        return result2;
    }

    public String getName() {
        return "Java line markers";
    }

    public GutterIconDescriptor.Option[] getOptions() {
        return new GutterIconDescriptor.Option[]{this.myLambdaOption, this.myOverriddenOption, this.myImplementedOption, this.myOverridingOption, this.myImplementingOption};
    }

    private static /* synthetic */ boolean lambda$collectOverridingMethods$5(Set methodSet, Set overridden, Pair pair) {
        ProgressManager.checkCanceled();
        PsiMethod superMethod = (PsiMethod)pair.getFirst();
        if (methodSet.remove(superMethod)) {
            overridden.add(superMethod);
        }
        return !methodSet.isEmpty();
    }

    private static class ArrowUpLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private ArrowUpLineMarkerInfo(@NotNull PsiElement element, @NotNull Icon icon, @NotNull MarkerType markerType, int passId) {
            super(element, element.getTextRange(), icon, passId, markerType.getTooltip(), markerType.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (!(info instanceof ArrowUpLineMarkerInfo)) {
                return false;
            }
            PsiElement otherElement = info.getElement();
            PsiElement myElement = this.getElement();
            return otherElement != null && myElement != null;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            return this.myIcon;
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            return element -> "Multiple method overrides";
        }

        public String getElementPresentation(PsiElement element) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiFunctionalExpression) {
                return PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)parent));
            }
            return super.getElementPresentation(element);
        }
    }
}

