/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineMarkersUtil {
    private static final Logger LOG = Logger.getInstance(LineMarkersUtil.class);
    private static final Key<LineMarkerInfo> LINE_MARKER_INFO = Key.create((String)"LINE_MARKER_INFO");

    LineMarkersUtil() {
    }

    static boolean processLineMarkers(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, int group, @NotNull Processor<LineMarkerInfo> processor2) {
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        return markupModel.processRangeHighlightersOverlappingWith(bounds.getStartOffset(), bounds.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            LineMarkerInfo info = LineMarkersUtil.getLineMarkerInfo(highlighter);
            return info == null || group != -1 && info.updatePass != group || processor2.process((Object)info);
        }));
    }

    static void setLineMarkersToEditor(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, @NotNull Collection<LineMarkerInfo> markers, int group) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        HighlightersRecycler toReuse = new HighlightersRecycler();
        LineMarkersUtil.processLineMarkers(project2, document, bounds, group, (Processor<LineMarkerInfo>)((Processor)info -> {
            toReuse.recycleHighlighter(info.highlighter);
            return true;
        }));
        if (LOG.isDebugEnabled()) {
            List<LineMarkerInfo> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project2);
            LOG.debug("LineMarkersUtil.setLineMarkersToEditor(markers: " + markers + ", group: " + group + "); oldMarkers: " + oldMarkers + "; reused: " + toReuse.forAllInGarbageBin().size());
        }
        for (LineMarkerInfo lineMarkerInfo : markers) {
            TextRange elementRange;
            TextRange textRange;
            PsiElement element = lineMarkerInfo.getElement();
            if (element == null || (textRange = element.getTextRange()) == null || !TextRange.containsRange((Segment)bounds, (Segment)(elementRange = InjectedLanguageManager.getInstance((Project)project2).injectedToHost(element, textRange)))) continue;
            LineMarkersUtil.createOrReuseLineMarker(lineMarkerInfo, markupModel, toReuse);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
        }
    }

    @NotNull
    private static RangeHighlighter createOrReuseLineMarker(@NotNull LineMarkerInfo info, @NotNull MarkupModel markupModel, @Nullable HighlightersRecycler toReuse) {
        boolean lineSeparatorPlacementChanged;
        RangeHighlighter highlighter;
        RangeHighlighter rangeHighlighter = highlighter = toReuse == null ? null : toReuse.pickupHighlighterFromGarbageBin(info.startOffset, info.endOffset, 3000);
        if (highlighter == null) {
            highlighter = markupModel.addRangeHighlighter(info.startOffset, info.endOffset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        }
        highlighter.putUserData(LINE_MARKER_INFO, (Object)info);
        LineMarkerInfo.LineMarkerGutterIconRenderer newRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)info.createGutterRenderer();
        LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer = highlighter.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)highlighter.getGutterIconRenderer() : null;
        boolean rendererChanged = oldRenderer == null || newRenderer == null || !newRenderer.equals((Object)oldRenderer);
        boolean lineSeparatorColorChanged = !Comparing.equal((Object)highlighter.getLineSeparatorColor(), (Object)info.separatorColor);
        boolean bl = lineSeparatorPlacementChanged = !Comparing.equal((Object)highlighter.getLineSeparatorPlacement(), (Object)info.separatorPlacement);
        if (rendererChanged || lineSeparatorColorChanged || lineSeparatorPlacementChanged) {
            ((MarkupModelEx)markupModel).changeAttributesInBatch((RangeHighlighterEx)highlighter, (Consumer<RangeHighlighterEx>)((Consumer)markerEx -> {
                if (rendererChanged) {
                    markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                }
                if (lineSeparatorColorChanged) {
                    markerEx.setLineSeparatorColor(info.separatorColor);
                }
                if (lineSeparatorPlacementChanged) {
                    markerEx.setLineSeparatorPlacement(info.separatorPlacement);
                }
            }));
        }
        info.highlighter = highlighter;
        return highlighter;
    }

    static void addLineMarkerToEditorIncrementally(@NotNull Project project2, @NotNull Document document, @NotNull LineMarkerInfo marker) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        LineMarkerInfo[] markerInTheWay = new LineMarkerInfo[]{null};
        boolean allIsClear = markupModel.processRangeHighlightersOverlappingWith(marker.startOffset, marker.endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            markerInTheWay[0] = LineMarkersUtil.getLineMarkerInfo(highlighter);
            return markerInTheWay[0] == null;
        }));
        if (allIsClear) {
            LineMarkersUtil.createOrReuseLineMarker(marker, markupModel, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersUtil.addLineMarkerToEditorIncrementally: " + marker + " " + (allIsClear ? "created" : " (was not added because " + markerInTheWay[0] + " was in the way)"));
        }
    }

    private static LineMarkerInfo getLineMarkerInfo(@NotNull RangeHighlighter highlighter) {
        return (LineMarkerInfo)highlighter.getUserData(LINE_MARKER_INFO);
    }
}

