/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalDescriptorsUtil;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LocalInspectionsPass");
    public static final TextRange EMPTY_PRIORITY_RANGE = TextRange.EMPTY_RANGE;
    private static final Condition<PsiFile> SHOULD_INSPECT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)file2);
    private final TextRange myPriorityRange;
    private final boolean myIgnoreSuppressed;
    private final ConcurrentMap<PsiFile, List<InspectionResult>> result = ContainerUtil.newConcurrentMap();
    private static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.inspection", (Object[])new Object[0]);
    private volatile List<HighlightInfo> myInfos = Collections.emptyList();
    private final String myShortcutText;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionProfileWrapper myProfileWrapper;
    private boolean myFailFastOnAcquireReadAction;
    private final Map<TextRange, RangeMarker> ranges2markersCache = new THashMap();
    private final TransferToEDTQueue<Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator>> myTransferToEDTQueue = new TransferToEDTQueue("Apply inspection results", (Processor)new Processor<Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator>>(){
        private final InspectionProfile inspectionProfile;
        private final InjectedLanguageManager ilManager;
        private final List<HighlightInfo> infos;
        private final PsiDocumentManager documentManager;
        {
            this.inspectionProfile = InspectionProjectProfileManager.getInstance(LocalInspectionsPass.this.myProject).getCurrentProfile();
            this.ilManager = InjectedLanguageManager.getInstance((Project)LocalInspectionsPass.this.myProject);
            this.infos = new ArrayList<HighlightInfo>(2);
            this.documentManager = PsiDocumentManager.getInstance((Project)LocalInspectionsPass.this.myProject);
        }

        public boolean process(Trinity<ProblemDescriptor, LocalInspectionToolWrapper, ProgressIndicator> trinity) {
            ProgressIndicator indicator = (ProgressIndicator)trinity.getThird();
            if (indicator.isCanceled()) {
                return false;
            }
            ProblemDescriptor descriptor = (ProblemDescriptor)trinity.first;
            LocalInspectionToolWrapper tool = (LocalInspectionToolWrapper)((Object)trinity.second);
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement == null) {
                return true;
            }
            PsiFile file2 = psiElement.getContainingFile();
            Document thisDocument = this.documentManager.getDocument(file2);
            HighlightSeverity severity = this.inspectionProfile.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)file2).getSeverity();
            this.infos.clear();
            LocalInspectionsPass.this.createHighlightsForDescriptor(this.infos, LocalInspectionsPass.this.emptyActionRegistered, this.ilManager, file2, thisDocument, tool, severity, descriptor, psiElement);
            for (HighlightInfo info : this.infos) {
                EditorColorsScheme colorsScheme = LocalInspectionsPass.this.getColorsScheme();
                UpdateHighlightersUtil.addHighlighterToEditorIncrementally(LocalInspectionsPass.this.myProject, LocalInspectionsPass.this.myDocument, LocalInspectionsPass.this.getFile(), LocalInspectionsPass.this.myRestrictRange.getStartOffset(), LocalInspectionsPass.this.myRestrictRange.getEndOffset(), info, colorsScheme, LocalInspectionsPass.this.getId(), LocalInspectionsPass.this.ranges2markersCache);
            }
            return true;
        }
    }, this.myProject.getDisposed(), 200);
    private final Set<Pair<TextRange, String>> emptyActionRegistered = Collections.synchronizedSet(new THashSet());

    public LocalInspectionsPass(@NotNull PsiFile file2, @Nullable Document document, int startOffset, int endOffset, @NotNull TextRange priorityRange, boolean ignoreSuppressed, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        super(file2.getProject(), document, PRESENTABLE_NAME, file2, null, new TextRange(startOffset, endOffset), true, highlightInfoProcessor);
        Keymap keymap;
        assert (file2.isPhysical()) : "can't inspect non-physical file: " + file2 + "; " + file2.getVirtualFile();
        this.myPriorityRange = priorityRange;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.setId(7);
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        this.myShortcutText = keymapManager2 != null ? ((keymap = keymapManager2.getActiveKeymap()) == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts("ShowErrorDescription")) + ")") : "";
        InspectionProfileImpl profileToUse = ProjectInspectionProfileManager.getInstance(this.myProject).getCurrentProfile();
        Function custom = (Function)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        InspectionProfileWrapper inspectionProfileWrapper = this.myProfileWrapper = custom == null ? new InspectionProfileWrapper(profileToUse) : (InspectionProfileWrapper)custom.apply(profileToUse);
        assert (this.myProfileWrapper != null);
        this.mySeverityRegistrar = this.myProfileWrapper.getInspectionProfile().getProfileManager().getSeverityRegistrar();
        this.setProgressLimit(600L);
    }

    @NotNull
    private PsiFile getFile() {
        return this.myFile;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        try {
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)this.getFile())) {
                return;
            }
            this.inspect(this.getInspectionTools(this.myProfileWrapper), InspectionManager.getInstance((Project)this.myProject), true, true, progress);
        }
        finally {
            this.disposeDescriptors();
        }
    }

    private void disposeDescriptors() {
        this.result.clear();
    }

    public void doInspectInBatch(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionManager iManager, @NotNull List<LocalInspectionToolWrapper> toolWrappers) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        this.inspect(new ArrayList<LocalInspectionToolWrapper>(toolWrappers), iManager, false, false, progress);
        this.addDescriptorsFromInjectedResults(iManager, context);
        List resultList = (List)this.result.get(this.getFile());
        if (resultList == null) {
            return;
        }
        for (InspectionResult inspectionResult : resultList) {
            LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
            for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                this.addDescriptors(toolWrapper, descriptor, context);
            }
        }
    }

    private void addDescriptors(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull ProblemDescriptor descriptor, @NotNull GlobalInspectionContextImpl context) {
        InspectionToolPresentation toolPresentation = context.getPresentation(toolWrapper);
        LocalDescriptorsUtil.addProblemDescriptors(Collections.singletonList(descriptor), toolPresentation, this.myIgnoreSuppressed, context, (LocalInspectionTool)toolWrapper.getTool());
    }

    private void addDescriptorsFromInjectedResults(@NotNull InspectionManager iManager, @NotNull GlobalInspectionContextImpl context) {
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        for (Map.Entry entry : this.result.entrySet()) {
            PsiFile file2 = (PsiFile)entry.getKey();
            if (file2 == this.getFile()) continue;
            DocumentWindow documentRange = (DocumentWindow)documentManager.getDocument(file2);
            List resultList = (List)entry.getValue();
            for (InspectionResult inspectionResult : resultList) {
                LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
                for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                    PsiElement psiElement = descriptor.getPsiElement();
                    if (psiElement == null || SuppressionUtil.inspectionResultSuppressed(psiElement, (LocalInspectionTool)toolWrapper.getTool())) continue;
                    List editables = ilManager.intersectWithAllEditableFragments(file2, ((ProblemDescriptorBase)descriptor).getTextRange());
                    for (TextRange editable : editables) {
                        TextRange hostRange = documentRange.injectedToHost(editable);
                        QuickFix[] fixes = descriptor.getFixes();
                        LocalQuickFix[] localFixes = null;
                        if (fixes != null) {
                            localFixes = new LocalQuickFix[fixes.length];
                            for (int k = 0; k < fixes.length; ++k) {
                                QuickFix fix = fixes[k];
                                localFixes[k] = (LocalQuickFix)fix;
                            }
                        }
                        ProblemDescriptor patchedDescriptor = iManager.createProblemDescriptor((PsiElement)this.getFile(), hostRange, descriptor.getDescriptionTemplate(), descriptor.getHighlightType(), true, localFixes);
                        this.addDescriptors(toolWrapper, patchedDescriptor, context);
                    }
                }
            }
        }
    }

    private void inspect(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator progress) {
        this.myFailFastOnAcquireReadAction = failFastOnAcquireReadAction;
        if (toolWrappers.isEmpty()) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, this.myPriorityRange, SHOULD_INSPECT_FILTER, (Processor<Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List inside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.inside));
        List outside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.outside, d.parents)));
        Set<String> elementDialectIds = InspectionEngine.calcElementDialectIds(inside, outside);
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedLanguageIds = InspectionEngine.getToolsToSpecifiedLanguages(toolWrappers);
        this.setProgressLimit((long)toolToSpecifiedLanguageIds.size() * 2L);
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset());
        List<InspectionContext> init = this.visitPriorityElementsAndInit(toolToSpecifiedLanguageIds, iManager, isOnTheFly, progress, inside, session2, elementDialectIds);
        this.inspectInjectedPsi(inside, isOnTheFly, progress, iManager, true, toolWrappers);
        this.visitRestElementsAndCleanup(progress, outside, session2, init, elementDialectIds);
        this.inspectInjectedPsi(outside, isOnTheFly, progress, iManager, false, toolWrappers);
        progress.checkCanceled();
        this.myInfos = new ArrayList<HighlightInfo>();
        this.addHighlightsFromResults(this.myInfos, progress);
    }

    @NotNull
    private List<InspectionContext> visitPriorityElementsAndInit(@NotNull Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedLanguageIds, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull LocalInspectionToolSession session2, @NotNull Set<String> elementDialectIds) {
        ArrayList<InspectionContext> init = new ArrayList<InspectionContext>();
        ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>> entries = new ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>>(toolToSpecifiedLanguageIds.entrySet());
        Processor processor2 = pair -> {
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)((Object)((Object)pair.getKey()));
            Set dialectIdsSpecifiedForTool = (Set)pair.getValue();
            this.runToolOnElements(toolWrapper, dialectIdsSpecifiedForTool, iManager, isOnTheFly, indicator, elements, session2, init, elementDialectIds);
            return true;
        };
        boolean result2 = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries, indicator, this.myFailFastOnAcquireReadAction, processor2);
        if (!result2) {
            throw new ProcessCanceledException();
        }
        return init;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runToolOnElements(final @NotNull LocalInspectionToolWrapper toolWrapper, Set<String> dialectIdsSpecifiedForTool, @NotNull InspectionManager iManager, boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull LocalInspectionToolSession session2, @NotNull List<InspectionContext> init, @NotNull Set<String> elementDialectIds) {
        indicator.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        final boolean[] applyIncrementally = new boolean[]{isOnTheFly};
        ProblemsHolder holder = new ProblemsHolder(iManager, this.getFile(), isOnTheFly){

            public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                super.registerProblem(descriptor);
                if (applyIncrementally[0]) {
                    LocalInspectionsPass.this.addDescriptorIncrementally(descriptor, toolWrapper, indicator);
                }
            }
        };
        PsiElementVisitor visitor = InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements, elementDialectIds, dialectIdsSpecifiedForTool);
        List<InspectionContext> list = init;
        synchronized (list) {
            init.add(new InspectionContext(toolWrapper, holder, holder.getResultCount(), visitor, dialectIdsSpecifiedForTool));
        }
        this.advanceProgress(1L);
        if (holder.hasResults()) {
            this.appendDescriptors(this.getFile(), holder.getResults(), toolWrapper);
        }
        applyIncrementally[0] = false;
    }

    private void visitRestElementsAndCleanup(@NotNull ProgressIndicator indicator, @NotNull List<PsiElement> elements, @NotNull LocalInspectionToolSession session2, @NotNull List<InspectionContext> init, @NotNull Set<String> elementDialectIds) {
        Processor processor2 = context -> {
            indicator.checkCanceled();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            InspectionEngine.acceptElements(elements, ((InspectionContext)context).visitor, elementDialectIds, ((InspectionContext)context).dialectIdsSpecifiedForTool);
            this.advanceProgress(1L);
            ((LocalInspectionTool)((InspectionContext)context).tool.getTool()).inspectionFinished(session2, ((InspectionContext)context).holder);
            if (((InspectionContext)context).holder.hasResults()) {
                List allProblems = ((InspectionContext)context).holder.getResults();
                List<ProblemDescriptor> restProblems = allProblems.subList(((InspectionContext)context).problemsSize, allProblems.size());
                this.appendDescriptors(this.getFile(), restProblems, ((InspectionContext)context).tool);
            }
            return true;
        };
        boolean result2 = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(init, indicator, this.myFailFastOnAcquireReadAction, processor2);
        if (!result2) {
            throw new ProcessCanceledException();
        }
    }

    void inspectInjectedPsi(@NotNull List<PsiElement> elements, boolean onTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<LocalInspectionToolWrapper> wrappers) {
        THashSet injected = new THashSet();
        for (PsiElement element : elements) {
            InjectedLanguageUtil.enumerate(element, this.getFile(), false, (arg_0, arg_1) -> LocalInspectionsPass.lambda$inspectInjectedPsi$5((Set)injected, arg_0, arg_1));
        }
        if (injected.isEmpty()) {
            return;
        }
        Processor processor2 = injectedPsi -> {
            this.doInspectInjectedPsi((PsiFile)injectedPsi, onTheFly, indicator, iManager, inVisibleRange, wrappers);
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(injected), indicator, this.myFailFastOnAcquireReadAction, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    private HighlightInfo highlightInfoFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightInfoType highlightInfoType, @NotNull String message2, String toolTip, PsiElement psiElement) {
        TextRange textRange = ((ProblemDescriptorBase)problemDescriptor).getTextRange();
        if (textRange == null || psiElement == null) {
            return null;
        }
        boolean isFileLevel = psiElement instanceof PsiFile && textRange.equals((Object)psiElement.getTextRange());
        HighlightSeverity severity = highlightInfoType.getSeverity(psiElement);
        TextAttributes attributes = this.mySeverityRegistrar.getTextAttributesBySeverity(severity);
        HighlightInfo.Builder b = HighlightInfo.newHighlightInfo(highlightInfoType).range(psiElement, textRange.getStartOffset(), textRange.getEndOffset()).description(message2).severity(severity);
        if (toolTip != null) {
            b.escapedToolTip(toolTip);
        }
        if (attributes != null) {
            b.textAttributes(attributes);
        }
        if (problemDescriptor.isAfterEndOfLine()) {
            b.endOfLine();
        }
        if (isFileLevel) {
            b.fileLevelAnnotation();
        }
        if (problemDescriptor.getProblemGroup() != null) {
            b.problemGroup(problemDescriptor.getProblemGroup());
        }
        return b.create();
    }

    private void addDescriptorIncrementally(@NotNull ProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper tool, @NotNull ProgressIndicator indicator) {
        if (this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed(descriptor.getPsiElement(), (LocalInspectionTool)tool.getTool())) {
            return;
        }
        this.myTransferToEDTQueue.offer((Object)Trinity.create((Object)descriptor, (Object)((Object)tool), (Object)indicator));
    }

    private void appendDescriptors(@NotNull PsiFile file2, @NotNull List<ProblemDescriptor> descriptors, @NotNull LocalInspectionToolWrapper tool) {
        for (ProblemDescriptor descriptor : descriptors) {
            if (descriptor != null) continue;
            LOG.error("null descriptor. all descriptors(" + descriptors.size() + "): " + descriptors + "; file: " + file2 + " (" + file2.getVirtualFile() + "); tool: " + (Object)((Object)tool));
        }
        InspectionResult result2 = new InspectionResult(tool, descriptors);
        this.appendResult(file2, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResult(@NotNull PsiFile file2, @NotNull InspectionResult result2) {
        List resultList = (List)this.result.get(file2);
        if (resultList == null) {
            resultList = (List)ConcurrencyUtil.cacheOrGet(this.result, (Object)file2, new ArrayList());
        }
        List list = resultList;
        synchronized (list) {
            resultList.add(result2);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myInfos, this.getColorsScheme(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightsFromResults(@NotNull List<HighlightInfo> outInfos, @NotNull ProgressIndicator indicator) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        THashSet emptyActionRegistered = new THashSet();
        for (Map.Entry entry : this.result.entrySet()) {
            List resultList;
            indicator.checkCanceled();
            PsiFile file2 = (PsiFile)entry.getKey();
            Document documentRange = documentManager.getDocument(file2);
            if (documentRange == null) continue;
            List list = resultList = (List)entry.getValue();
            synchronized (list) {
                for (InspectionResult inspectionResult : resultList) {
                    indicator.checkCanceled();
                    LocalInspectionToolWrapper tool = inspectionResult.tool;
                    HighlightSeverity severity = inspectionProfile.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)file2).getSeverity();
                    for (ProblemDescriptor descriptor : inspectionResult.foundProblems) {
                        indicator.checkCanceled();
                        PsiElement element = descriptor.getPsiElement();
                        if (element == null) continue;
                        this.createHighlightsForDescriptor(outInfos, (Set<Pair<TextRange, String>>)emptyActionRegistered, ilManager, file2, documentRange, tool, severity, descriptor, element);
                    }
                }
            }
        }
    }

    private void createHighlightsForDescriptor(@NotNull List<HighlightInfo> outInfos, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor, @NotNull PsiElement element) {
        boolean isInjected;
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        if (this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed(element, tool)) {
            return;
        }
        HighlightInfoType level = ProblemDescriptorUtil.highlightTypeFromDescriptor(descriptor, severity, this.mySeverityRegistrar);
        HighlightInfo info = this.createHighlightInfo(descriptor, toolWrapper, level, emptyActionRegistered, element);
        if (info == null) {
            return;
        }
        PsiFile context = this.getTopLevelFileInBaseLanguage(element);
        PsiFile myContext = this.getTopLevelFileInBaseLanguage((PsiElement)this.getFile());
        if (context != this.getFile()) {
            LOG.error("Reported element " + element + " is not from the file '" + file2 + "' the inspection '" + (Object)((Object)toolWrapper) + "' (" + tool.getClass() + ") was invoked for. Message: '" + descriptor + "'.\nElement' containing file: " + context + "\nInspection invoked for file: " + myContext + "\n");
        }
        boolean bl = isInjected = file2 != this.getFile();
        if (!isInjected) {
            outInfos.add(info);
            return;
        }
        List editables = ilManager.intersectWithAllEditableFragments(file2, new TextRange(info.startOffset, info.endOffset));
        for (TextRange editable : editables) {
            String toolTip;
            TextRange hostRange = ((DocumentWindow)documentRange).injectedToHost(editable);
            int start = hostRange.getStartOffset();
            int end = hostRange.getEndOffset();
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(info.type).range(element, start, end);
            String description = info.getDescription();
            if (description != null) {
                builder.description(description);
            }
            if ((toolTip = info.getToolTip()) != null) {
                builder.escapedToolTip(toolTip);
            }
            HighlightInfo patched = builder.createUnconditionally();
            if (patched.startOffset == patched.endOffset && info.startOffset != info.endOffset) continue;
            patched.setFromInjection(true);
            LocalInspectionsPass.registerQuickFixes(toolWrapper, descriptor, patched, emptyActionRegistered);
            outInfos.add(patched);
        }
    }

    private PsiFile getTopLevelFileInBaseLanguage(@NotNull PsiElement element) {
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)this.myProject).getTopLevelFile(element);
        FileViewProvider viewProvider = file2.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Nullable
    private HighlightInfo createHighlightInfo(@NotNull ProblemDescriptor descriptor, @NotNull LocalInspectionToolWrapper tool, @NotNull HighlightInfoType level, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered, @NotNull PsiElement element) {
        HighlightInfo highlightInfo;
        String message2 = ProblemDescriptorUtil.renderDescriptionMessage((CommonProblemDescriptor)descriptor, element);
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)tool.getShortName());
        InspectionProfileImpl inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key2, (PsiElement)this.getFile())) {
            return null;
        }
        HighlightInfoType.HighlightInfoTypeImpl type2 = new HighlightInfoType.HighlightInfoTypeImpl(level.getSeverity(element), level.getAttributesKey());
        String plainMessage = message2.startsWith("<html>") ? StringUtil.unescapeXml((String)XmlStringUtil.stripHtml((String)message2).replaceAll("<[^>]*>", "")) : message2;
        String link = " <a href=\"#inspection/" + tool.getShortName() + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a> " + this.myShortcutText;
        String tooltip = null;
        if (descriptor.showTooltip()) {
            tooltip = XmlStringUtil.wrapInHtml((CharSequence)((message2.startsWith("<html>") ? XmlStringUtil.stripHtml((String)message2) : XmlStringUtil.escapeString((String)message2)) + link));
        }
        if ((highlightInfo = this.highlightInfoFromDescriptor(descriptor, type2, plainMessage, tooltip, element)) != null) {
            LocalInspectionsPass.registerQuickFixes(tool, descriptor, highlightInfo, emptyActionRegistered);
        }
        return highlightInfo;
    }

    private static void registerQuickFixes(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemDescriptor descriptor, @NotNull HighlightInfo highlightInfo, @NotNull Set<Pair<TextRange, String>> emptyActionRegistered) {
        HintAction hintAction;
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)tool.getShortName());
        boolean needEmptyAction = true;
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            for (int k = 0; k < fixes.length; ++k) {
                if (fixes[k] == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixWrapper.wrap(descriptor, k), key2);
                needEmptyAction = false;
            }
        }
        HintAction hintAction2 = hintAction = descriptor instanceof ProblemDescriptorImpl ? ((ProblemDescriptorImpl)descriptor).getHintAction() : null;
        if (hintAction != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)hintAction, key2);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorBase)descriptor).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add((Pair<TextRange, String>)Pair.create((Object)highlightInfo.getFixTextRange(), (Object)tool.getShortName()))) {
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(tool.getDisplayName());
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)emptyIntentionAction, key2);
        }
    }

    private static void getElementsAndDialectsFrom(@NotNull PsiFile file2, @NotNull List<PsiElement> outElements, @NotNull Set<String> outDialects) {
        FileViewProvider viewProvider = file2.getViewProvider();
        final LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        SmartHashSet processedLanguages = new SmartHashSet();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor((Set)processedLanguages, outDialects){
            final /* synthetic */ Set val$processedLanguages;
            final /* synthetic */ Set val$outDialects;
            {
                this.val$processedLanguages = set3;
                this.val$outDialects = set4;
            }

            public void visitElement(PsiElement element) {
                PsiElement child;
                ProgressManager.checkCanceled();
                if (child != null) {
                    for (child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                        child.accept((PsiElementVisitor)this);
                        result2.add(child);
                        LocalInspectionsPass.appendDialects(child, this.val$processedLanguages, this.val$outDialects);
                    }
                }
            }
        };
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            psiRoot.accept((PsiElementVisitor)visitor);
            result2.add(psiRoot);
            LocalInspectionsPass.appendDialects((PsiElement)psiRoot, (Set<Language>)processedLanguages, outDialects);
        }
        outElements.addAll(result2);
    }

    static void appendDialects(PsiElement element, Set<Language> outProcessedLanguages, Set<String> outDialectIds) {
        Language language = element.getLanguage();
        outDialectIds.add(language.getID());
        if (outProcessedLanguages.add(language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    @NotNull
    List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile2) {
        InspectionToolWrapper[] toolWrappers = profile2.getInspectionProfile().getInspectionTools((PsiElement)this.getFile());
        InspectionProfileWrapper.checkInspectionsDuplicates(toolWrappers);
        ArrayList<LocalInspectionToolWrapper> enabled = new ArrayList<LocalInspectionToolWrapper>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            String language;
            ProgressManager.checkCanceled();
            HighlightDisplayKey key2 = HighlightDisplayKey.find((String)toolWrapper.getShortName());
            if (!profile2.isToolEnabled(key2, (PsiElement)this.getFile()) || HighlightDisplayLevel.DO_NOT_SHOW.equals(profile2.getErrorLevel(key2, (PsiElement)this.getFile()))) continue;
            LocalInspectionToolWrapper wrapper = null;
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                wrapper = (LocalInspectionToolWrapper)toolWrapper;
            } else if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionToolWrapper globalInspectionToolWrapper = (GlobalInspectionToolWrapper)toolWrapper;
                wrapper = globalInspectionToolWrapper.getSharedLocalInspectionToolWrapper();
            }
            if (wrapper == null || (language = wrapper.getLanguage()) != null && Language.findLanguageByID((String)language) == null || this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed((PsiElement)this.getFile(), (LocalInspectionTool)wrapper.getTool())) continue;
            enabled.add(wrapper);
        }
        return enabled;
    }

    private void doInspectInjectedPsi(@NotNull PsiFile injectedPsi, final boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, final boolean inVisibleRange, @NotNull List<LocalInspectionToolWrapper> wrappers) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)injectedPsi.getProject()).getInjectionHost((PsiElement)injectedPsi);
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        SmartHashSet elementDialectIds = new SmartHashSet();
        LocalInspectionsPass.getElementsAndDialectsFrom(injectedPsi, elements, (Set<String>)elementDialectIds);
        if (elements.isEmpty()) {
            return;
        }
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedLanguageIds = InspectionEngine.getToolsToSpecifiedLanguages(wrappers);
        for (Map.Entry<LocalInspectionToolWrapper, Set<String>> pair : toolToSpecifiedLanguageIds.entrySet()) {
            indicator.checkCanceled();
            final LocalInspectionToolWrapper wrapper = pair.getKey();
            LocalInspectionTool tool = (LocalInspectionTool)wrapper.getTool();
            if (host != null && this.myIgnoreSuppressed && SuppressionUtil.inspectionResultSuppressed((PsiElement)host, tool)) continue;
            ProblemsHolder holder = new ProblemsHolder(iManager, injectedPsi, isOnTheFly){

                public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                    super.registerProblem(descriptor);
                    if (isOnTheFly && inVisibleRange) {
                        LocalInspectionsPass.this.addDescriptorIncrementally(descriptor, wrapper, indicator);
                    }
                }
            };
            LocalInspectionToolSession injSession = new LocalInspectionToolSession(injectedPsi, 0, injectedPsi.getTextLength());
            Set<String> dialectIdsSpecifiedForTool = pair.getValue();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, injSession, elements, (Set<String>)elementDialectIds, dialectIdsSpecifiedForTool);
            tool.inspectionFinished(injSession, holder);
            List problems = holder.getResults();
            if (problems.isEmpty()) continue;
            this.appendDescriptors(injectedPsi, problems, wrapper);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        return this.myInfos;
    }

    private static /* synthetic */ void lambda$inspectInjectedPsi$5(Set injected, PsiFile injectedPsi, List places) {
        injected.add(injectedPsi);
    }

    private static class InspectionContext {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final ProblemsHolder holder;
        private final int problemsSize;
        @NotNull
        private final PsiElementVisitor visitor;
        @Nullable
        private final Set<String> dialectIdsSpecifiedForTool;

        private InspectionContext(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemsHolder holder, int problemsSize, @NotNull PsiElementVisitor visitor, @Nullable Set<String> dialectIdsSpecifiedForTool) {
            this.tool = tool;
            this.holder = holder;
            this.problemsSize = problemsSize;
            this.visitor = visitor;
            this.dialectIdsSpecifiedForTool = dialectIdsSpecifiedForTool;
        }
    }

    private static class InspectionResult {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final List<ProblemDescriptor> foundProblems;

        private InspectionResult(@NotNull LocalInspectionToolWrapper tool, @NotNull List<ProblemDescriptor> foundProblems) {
            this.tool = tool;
            this.foundProblems = new ArrayList<ProblemDescriptor>(foundProblems);
        }
    }
}

