/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;

public class SdkSetupNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    static final Key<EditorNotificationPanel> KEY = Key.create((String)"SdkSetupNotification");
    private final Project myProject;

    public SdkSetupNotificationProvider(Project project2, final EditorNotifications notifications) {
        this.myProject = project2;
        this.myProject.getMessageBus().connect((Disposable)project2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        ProjectSdkSetupValidator[] validators;
        for (ProjectSdkSetupValidator validator : validators = (ProjectSdkSetupValidator[])Extensions.getExtensions(ProjectSdkSetupValidator.PROJECT_SDK_SETUP_VALIDATOR_EP)) {
            if (!validator.isApplicableFor(this.myProject, file2)) continue;
            String errorMessage = validator.getErrorMessage(this.myProject, file2);
            if (errorMessage != null) {
                return SdkSetupNotificationProvider.createPanel(errorMessage, () -> validator.doFix(this.myProject, file2));
            }
            return null;
        }
        return null;
    }

    @NotNull
    private static EditorNotificationPanel createPanel(@NotNull String message2, @NotNull Runnable fix) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(message2);
        panel2.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), fix);
        return panel2;
    }
}

