/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SeverityUtil {
    @NotNull
    public static Collection<SeverityRegistrar.SeverityBasedTextAttributes> getRegisteredHighlightingInfoTypes(@NotNull SeverityRegistrar registrar) {
        Collection<SeverityRegistrar.SeverityBasedTextAttributes> collection = registrar.allRegisteredAttributes();
        for (HighlightInfoType type2 : registrar.standardSeverities()) {
            if (HighlightInfoType.INFORMATION.equals(type2)) continue;
            collection.add(SeverityUtil.getSeverityBasedTextAttributes(registrar, type2));
        }
        return collection;
    }

    private static SeverityRegistrar.SeverityBasedTextAttributes getSeverityBasedTextAttributes(@NotNull SeverityRegistrar registrar, @NotNull HighlightInfoType type2) {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = scheme2.getAttributes(type2.getAttributesKey());
        if (textAttributes != null) {
            return new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes, (HighlightInfoType.HighlightInfoTypeImpl)type2);
        }
        TextAttributes severity = registrar.getTextAttributesBySeverity(type2.getSeverity(null));
        return new SeverityRegistrar.SeverityBasedTextAttributes(severity, (HighlightInfoType.HighlightInfoTypeImpl)type2);
    }
}

