/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

abstract class ThreadLocalAnnotatorMap<K, V> {
    private volatile int version;
    private final ThreadLocal<VersionedMap<K, V>> CACHE = new ThreadLocal<VersionedMap<K, V>>(){

        @Override
        protected VersionedMap<K, V> initialValue() {
            return new VersionedMap(ThreadLocalAnnotatorMap.this.version);
        }
    };

    ThreadLocalAnnotatorMap() {
    }

    @NotNull
    public abstract Collection<V> initialValue(@NotNull K var1);

    @NotNull
    private List<V> cloneTemplates(@NotNull Collection<V> templates) {
        ArrayList<Object> result2 = new ArrayList<Object>(templates.size());
        PicoContainer container = ApplicationManager.getApplication().getPicoContainer();
        for (V template : templates) {
            Class<?> aClass = template.getClass();
            Object clone = new CachingConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(container);
            result2.add(clone);
        }
        return result2;
    }

    @NotNull
    public List<V> get(@NotNull K key2) {
        List<V> cached;
        VersionedMap<K, V> map2 = this.CACHE.get();
        if (this.version != ((VersionedMap)map2).version) {
            this.CACHE.remove();
            map2 = this.CACHE.get();
        }
        if ((cached = (List<V>)map2.get(key2)) == null) {
            Collection<V> templates = this.initialValue(key2);
            cached = this.cloneTemplates(templates);
            map2.put(key2, cached);
        }
        return cached;
    }

    public void clear() {
        ++this.version;
    }

    private static class VersionedMap<K, V>
    extends THashMap<K, List<V>> {
        private final int version;

        private VersionedMap(int version) {
            this.version = version;
        }
    }
}

