/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBatchSuppressByNoInspectionCommentFix
implements ContainerBasedSuppressQuickFix,
InjectionAwareSuppressQuickFix,
Iconable {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;
    private ThreeState myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;
    private String myText = "";

    @Nullable
    public abstract PsiElement getContainer(PsiElement var1);

    public AbstractBatchSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
        this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
    }

    @NotNull
    public ThreeState isShouldBeAppliedToInjectionHost() {
        return this.myShouldBeAppliedToInjectionHost;
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public Icon getIcon(int flags) {
        return AllIcons.General.InspectionsOff;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    protected void setText(@NotNull String text) {
        this.myText = text;
    }

    public String toString() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getStartElement();
        if (element == null) {
            return;
        }
        this.invoke(project2, element);
    }

    public boolean isSuppressAll() {
        return "ALL".equals(this.myID);
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{comment})) {
            return;
        }
        WriteAction.run(() -> SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment)));
    }

    protected void createSuppression(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        SuppressionUtil.createSuppression(project2, container, this.myID, this.getCommentLanguage(element));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element) {
        return element.getLanguage();
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
        return context.isValid() && this.getContainer(context) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!this.isAvailable(project2, element)) {
            return;
        }
        PsiElement container = this.getContainer(element);
        if (container == null) {
            return;
        }
        if (this.replaceSuppressionComments(container)) {
            return;
        }
        this.createSuppression(project2, element, container);
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        List<? extends PsiElement> comments = this.getCommentsFor(container);
        if (comments != null) {
            for (PsiElement psiElement : comments) {
                if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                this.replaceSuppressionComment(psiElement);
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)container, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @NotNull
    public String getFamilyName() {
        String text = this.getText();
        return StringUtil.isEmpty((String)text) ? InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]) : text;
    }
}

