/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressFix(@NotNull HighlightDisplayKey key2) {
        this(key2.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key2);
    }

    public SuppressFix(@NotNull String ID2) {
        super(ID2, false);
    }

    @Override
    @NotNull
    public String getText() {
        String myText = super.getText();
        return StringUtil.isEmpty((String)myText) ? InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]) : myText;
    }

    @Nullable
    public PsiDocCommentOwner getContainer(PsiElement context) {
        if (context == null || !context.getManager().isInProject(context)) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!containingFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container = context;
        while (container instanceof PsiAnonymousClass || !(container instanceof PsiDocCommentOwner) || container instanceof PsiTypeParameter) {
            if ((container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiDocCommentOwner.class)) != null) continue;
            return null;
        }
        return (PsiDocCommentOwner)container;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
        boolean isValid;
        PsiDocCommentOwner container = this.getContainer(context);
        boolean bl = isValid = container != null && (!(container instanceof PsiMethod) || !(container instanceof SyntheticElement));
        if (!isValid) {
            return false;
        }
        this.setText(container instanceof PsiClass ? InspectionsBundle.message((String)"suppress.inspection.class", (Object[])new Object[0]) : (container instanceof PsiMethod ? InspectionsBundle.message((String)"suppress.inspection.method", (Object[])new Object[0]) : InspectionsBundle.message((String)"suppress.inspection.field", (Object[])new Object[0])));
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiElement element) throws IncorrectOperationException {
        if (this.doSuppress(project2, this.getContainer(element))) {
            return;
        }
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]);
    }

    private boolean doSuppress(@NotNull Project project2, PsiDocCommentOwner container) {
        assert (container != null);
        if (this.use15Suppressions(container)) {
            PsiModifierList modifierList = container.getModifierList();
            if (modifierList != null) {
                JavaSuppressionUtil.addSuppressAnnotation(project2, (PsiElement)container, (PsiModifierListOwner)container, this.getID((PsiElement)container));
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)project2, null, null, () -> this.suppressByDocComment(project2, container), (PsiFile[])new PsiFile[]{container.getContainingFile()});
        }
        return false;
    }

    private void suppressByDocComment(@NotNull Project project2, PsiDocCommentOwner container) {
        PsiDocComment docComment = container.getDocComment();
        PsiManager manager = PsiManager.getInstance((Project)project2);
        if (docComment == null) {
            String commentText = "/** @noinspection " + this.getID((PsiElement)container) + "*/";
            docComment = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocCommentFromText(commentText);
            PsiElement firstChild = container.getFirstChild();
            container.addBefore((PsiElement)docComment, firstChild);
        } else {
            PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
            if (noInspectionTag != null) {
                String tagText = noInspectionTag.getText() + ", " + this.getID((PsiElement)container);
                noInspectionTag.replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocTagFromText(tagText));
            } else {
                String tagText = "@noinspection " + this.getID((PsiElement)container);
                docComment.add((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocTagFromText(tagText));
            }
        }
    }

    protected boolean use15Suppressions(@NotNull PsiDocCommentOwner container) {
        return JavaSuppressionUtil.canHave15Suppressions((PsiElement)container) && !JavaSuppressionUtil.alreadyHas14Suppressions(container);
    }

    private String getID(@NotNull PsiElement place) {
        String id = SuppressFix.getID(place, this.myAlternativeID);
        return id != null ? id : this.myID;
    }

    @Nullable
    static String getID(@NotNull PsiElement place, String alternativeID) {
        Module module2;
        if (alternativeID != null && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)place)) != null && !ClassPathStorageUtil.isDefaultStorage(module2)) {
            return alternativeID;
        }
        return null;
    }
}

