/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.XmlSettings;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.daemon.impl.analysis.ImportNSAction;
import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNSDeclarationIntentionFix
implements HintAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix");
    private final String myNamespacePrefix;
    private final PsiAnchor myElement;
    private final PsiAnchor myToken;

    @NotNull
    private XmlFile getFile() {
        return (XmlFile)this.myElement.getFile();
    }

    @Nullable
    public static CreateNSDeclarationIntentionFix createFix(@NotNull PsiElement element, @NotNull String namespacePrefix) {
        PsiFile file2 = element.getContainingFile();
        return file2 instanceof XmlFile ? new CreateNSDeclarationIntentionFix(element, namespacePrefix) : null;
    }

    protected CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix) {
        this(element, namespacePrefix, null);
    }

    public CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix, @Nullable XmlToken token) {
        this.myNamespacePrefix = namespacePrefix;
        this.myElement = PsiAnchor.create(element);
        this.myToken = token == null ? null : PsiAnchor.create((PsiElement)token);
    }

    @NotNull
    public String getText() {
        String alias = this.getXmlNamespaceHelper().getNamespaceAlias(this.getFile());
        return XmlErrorMessages.message("create.namespace.declaration.quickfix", alias);
    }

    private XmlNamespaceHelper getXmlNamespaceHelper() {
        return XmlNamespaceHelper.getHelper((PsiFile)this.getFile());
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiFile file2;
        PsiFile containingFile = descriptor.getPsiElement().getContainingFile();
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        PsiFile psiFile = file2 = editor != null ? PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument()) : null;
        if (file2 == null || !Comparing.equal((Object)file2.getVirtualFile(), (Object)containingFile.getVirtualFile())) {
            return;
        }
        try {
            this.invoke(project2, editor, containingFile);
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement element = this.myElement.retrieve();
        return element != null && element.isValid();
    }

    @NotNull
    private List<String> getNamespaces(PsiElement element, XmlFile xmlFile) {
        Set<String> set2;
        String match;
        if (element instanceof XmlAttribute) {
            element = element.getParent();
        }
        if ((match = CreateNSDeclarationIntentionFix.getUnboundNamespaceForPrefix(this.myNamespacePrefix, xmlFile, set2 = this.getXmlNamespaceHelper().guessUnboundNamespaces(element, xmlFile))) != null) {
            return Collections.singletonList(match);
        }
        ArrayList<String> namespaces = new ArrayList<String>(set2);
        Collections.sort(namespaces);
        return namespaces;
    }

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2) throws IncorrectOperationException {
        final PsiElement element = this.myElement.retrieve();
        if (element == null) {
            return;
        }
        XmlFile xmlFile = this.getFile();
        String[] namespaces = ArrayUtil.toStringArray(this.getNamespaces(element, xmlFile));
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(namespaces, project2, new StringToAttributeProcessor(){

            @Override
            public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(final @NotNull String namespace) throws IncorrectOperationException {
                String prefix = CreateNSDeclarationIntentionFix.this.myNamespacePrefix;
                if (StringUtil.isEmpty((String)prefix)) {
                    XmlFile xmlFile = XmlExtension.getExtension(file2).getContainingFile(element);
                    prefix = ExtendedTagInsertHandler.getPrefixByNamespace(xmlFile, namespace);
                    if (StringUtil.isNotEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, element);
                        return;
                    }
                    prefix = ExtendedTagInsertHandler.suggestPrefix(xmlFile, namespace);
                    if (!StringUtil.isEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, element);
                        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    }
                }
                int offset = editor.getCaretModel().getOffset();
                final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
                XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper(file2);
                helper.insertNamespaceDeclaration((XmlFile)file2, editor, Collections.singleton(namespace), prefix, new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

                    @Override
                    public void run(String param) throws IncorrectOperationException {
                        if (!namespace.isEmpty()) {
                            editor.getCaretModel().moveToOffset(marker.getStartOffset());
                        }
                    }
                });
            }
        }, this.getTitle(), (IntentionAction)this, editor);
    }

    @Nullable
    public static String getUnboundNamespaceForPrefix(String prefix, XmlFile xmlFile, Set<String> namespaces) {
        List providers = XmlSchemaProvider.getAvailableProviders((XmlFile)xmlFile);
        for (XmlSchemaProvider provider2 : providers) {
            for (String namespace : namespaces) {
                if (!prefix.equals(provider2.getDefaultPrefix(namespace, xmlFile))) continue;
                return namespace;
            }
        }
        return null;
    }

    private String getTitle() {
        return XmlErrorMessages.message("select.namespace.title", StringUtil.capitalize((String)this.getXmlNamespaceHelper().getNamespaceAlias(this.getFile())));
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        XmlToken token = null;
        if (this.myToken != null && (token = (XmlToken)this.myToken.retrieve()) == null) {
            return false;
        }
        if (!XmlSettings.getInstance().SHOW_XML_ADD_IMPORT_HINTS || this.myNamespacePrefix.isEmpty()) {
            return false;
        }
        PsiElement element = this.myElement.retrieve();
        if (element == null) {
            return false;
        }
        List<String> namespaces = this.getNamespaces(element, this.getFile());
        if (!namespaces.isEmpty()) {
            String message2 = ShowAutoImportPass.getMessage(namespaces.size() > 1, namespaces.iterator().next());
            String title = this.getTitle();
            ImportNSAction action = new ImportNSAction(namespaces, this.getFile(), element, editor, title);
            if (element instanceof XmlTag && token != null) {
                if (VisibleHighlightingPassFactory.calculateVisibleRange(editor).contains(token.getTextRange())) {
                    HintManager.getInstance().showQuestionHint(editor, message2, token.getTextOffset(), token.getTextOffset() + this.myNamespacePrefix.length(), (QuestionAction)action);
                    return true;
                }
            } else {
                HintManager.getInstance().showQuestionHint(editor, message2, element.getTextOffset(), element.getTextRange().getEndOffset(), (QuestionAction)action);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfGivenXmlHasTheseWords(String name, XmlFile tldFileByUri) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        List list = StringUtil.getWordsIn((String)name);
        final String[] words = ArrayUtil.toStringArray((Collection)list);
        final boolean[] wordsFound = new boolean[words.length];
        final int[] wordsFoundCount = new int[1];
        IdTableBuilding.ScanWordProcessor wordProcessor = new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars, @Nullable char[] charsArray, int start, int end) {
                if (wordsFoundCount[0] == words.length) {
                    return;
                }
                int foundWordLen = end - start;
                block0: for (int i2 = 0; i2 < words.length; ++i2) {
                    String localName = words[i2];
                    if (wordsFound[i2] || localName.length() != foundWordLen) continue;
                    for (int j = 0; j < localName.length(); ++j) {
                        if (chars.charAt(start + j) != localName.charAt(j)) continue block0;
                    }
                    wordsFound[i2] = true;
                    wordsFoundCount[0] = wordsFoundCount[0] + 1;
                    break;
                }
            }
        };
        CharSequence contents = tldFileByUri.getViewProvider().getContents();
        IdTableBuilding.scanWords(wordProcessor, contents, 0, contents.length());
        return wordsFoundCount[0] == words.length;
    }

    public static void runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(@NotNull String[] namespacesToChooseFrom, Project project2, StringToAttributeProcessor onSelection, String title, IntentionAction requestor, Editor editor) throws IncorrectOperationException {
        if (namespacesToChooseFrom.length > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            JBList list = new JBList((Object[])namespacesToChooseFrom);
            list.setCellRenderer(XmlNSRenderer.INSTANCE);
            Runnable runnable2 = () -> CreateNSDeclarationIntentionFix.lambda$runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne$2((JList)list, project2, onSelection, namespacesToChooseFrom, requestor);
            new PopupChooserBuilder((JList)list).setTitle(title).setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(editor);
        } else {
            onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(namespacesToChooseFrom.length == 0 ? "" : namespacesToChooseFrom[0]);
        }
    }

    public static void processExternalUris(MetaHandler metaHandler, PsiFile file2, ExternalUriProcessor processor2, boolean showProgress) {
        if (!showProgress || ApplicationManager.getApplication().isUnitTestMode()) {
            CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file2, processor2);
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file2, processor2), XmlErrorMessages.message("finding.acceptable.uri", new Object[0]), false, file2.getProject());
        }
    }

    private static void processExternalUrisImpl(MetaHandler metaHandler, PsiFile file2, ExternalUriProcessor processor2) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        String searchFor = metaHandler.searchFor();
        if (pi != null) {
            pi.setText(XmlErrorMessages.message("looking.in.schemas", new Object[0]));
        }
        ExternalResourceManager instanceEx = ExternalResourceManager.getInstance();
        String[] availableUrls = instanceEx.getResourceUrls(null, true);
        int i2 = 0;
        for (String url : availableUrls) {
            String defaultNamespace;
            boolean wordFound;
            XmlFile xmlFile;
            if (pi != null) {
                pi.setFraction((double)i2 / (double)availableUrls.length);
                pi.setText2(url);
                ++i2;
            }
            if ((xmlFile = XmlUtil.findNamespace(file2, url)) == null || !(wordFound = CreateNSDeclarationIntentionFix.checkIfGivenXmlHasTheseWords(searchFor, xmlFile))) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            PsiMetaData metaData = document.getMetaData();
            if (!metaHandler.isAcceptableMetaData(metaData, url)) continue;
            XmlNSDescriptorImpl descriptor = metaData instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)metaData : null;
            String string = defaultNamespace = descriptor != null ? descriptor.getDefaultNamespace() : url;
            if ("http://www.w3.org/1999/XMLSchema".equals(defaultNamespace) || "http://www.w3.org/2000/10/XMLSchema".equals(defaultNamespace)) continue;
            processor2.process(defaultNamespace, url);
        }
    }

    private static /* synthetic */ void lambda$runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne$2(JList list, Project project2, StringToAttributeProcessor onSelection, @NotNull String[] namespacesToChooseFrom, IntentionAction requestor) {
        int index = list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(namespacesToChooseFrom[index]);
            }
            catch (IncorrectOperationException ex) {
                throw new RuntimeException(ex);
            }
        }), requestor.getText(), (Object)requestor.getFamilyName());
    }

    public static interface ExternalUriProcessor {
        public void process(@NotNull String var1, @Nullable String var2);
    }

    public static class TagMetaHandler
    implements MetaHandler {
        private final String myName;

        public TagMetaHandler(String name) {
            this.myName = name;
        }

        @Override
        public boolean isAcceptableMetaData(PsiMetaData metaData, String url) {
            if (metaData instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
                XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(this.searchFor(), url);
                return descriptor != null && !(descriptor instanceof AnyXmlElementDescriptor);
            }
            return false;
        }

        @Override
        public String searchFor() {
            return this.myName;
        }
    }

    public static interface MetaHandler {
        public boolean isAcceptableMetaData(PsiMetaData var1, String var2);

        public String searchFor();
    }

    public static interface StringToAttributeProcessor {
        public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NonNls @NotNull String var1) throws IncorrectOperationException;
    }
}

