/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightControlFlowUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    private HighlightControlFlowUtil() {
    }

    @Nullable
    static HighlightInfo checkMissingReturnStatement(@Nullable PsiCodeBlock body2, @Nullable PsiType returnType) {
        if (body2 == null || returnType == null || PsiType.VOID.equals((Object)returnType.getDeepComponentType())) {
            return null;
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body2);
            if (!ControlFlowUtil.returnPresent(controlFlow)) {
                PsiJavaToken rBrace = body2.getRBrace();
                PsiJavaToken context = rBrace == null ? body2.getLastChild() : rBrace;
                String message2 = JavaErrorMessages.message("missing.return.statement", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(message2).create();
                PsiElement parent = body2.getParent();
                if (parent instanceof PsiMethod) {
                    PsiMethod method2 = (PsiMethod)parent;
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddReturnFix(method2));
                    QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method2, (PsiType)PsiType.VOID, true));
                }
                return info;
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static ControlFlow getControlFlowNoConstantEvaluate(@NotNull PsiElement body2) throws AnalysisCanceledException {
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        return ControlFlowFactory.getInstance(body2.getProject()).getControlFlow(body2, policy, false, false);
    }

    @NotNull
    private static ControlFlow getControlFlow(@NotNull PsiElement context) throws AnalysisCanceledException {
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        return ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, policy);
    }

    static HighlightInfo checkUnreachableStatement(@Nullable PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return null;
        }
        try {
            AllVariablesControlFlowPolicy policy = AllVariablesControlFlowPolicy.getInstance();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow((PsiElement)codeBlock, policy, false, false);
            PsiElement unreachableStatement = ControlFlowUtil.getUnreachableStatement(controlFlow);
            if (unreachableStatement != null) {
                String description = JavaErrorMessages.message("unreachable.statement", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(unreachableStatement).descriptionAndTooltip(description).create();
            }
        }
        catch (IndexNotReadyException | AnalysisCanceledException throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean isFieldInitializedAfterObjectConstruction(@NotNull PsiField field) {
        if (field.hasInitializer()) {
            return true;
        }
        boolean isFieldStatic = field.hasModifierProperty("static");
        PsiClass aClass = field.getContainingClass();
        if (aClass != null && HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, isFieldStatic)) {
            return true;
        }
        if (aClass == null) {
            return false;
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (HighlightControlFlowUtil.isFieldInitializedInClassInitializer(field, isFieldStatic, Arrays.stream(initializers))) {
            return true;
        }
        if (isFieldStatic) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        block0: for (PsiMethod constructor : constructors) {
            PsiCodeBlock ctrBody = constructor.getBody();
            if (ctrBody == null) {
                return false;
            }
            List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
            for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                PsiCodeBlock body2 = redirectedConstructor.getBody();
                if (body2 != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body2)) continue block0;
            }
            if (!ctrBody.isValid() || HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)ctrBody)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldInitializedInClassInitializer(@NotNull PsiField field, boolean isFieldStatic, Stream<PsiClassInitializer> initializers) {
        return initializers.anyMatch(initializer -> initializer.hasModifierProperty("static") == isFieldStatic && HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)initializer.getBody()));
    }

    private static boolean isFieldInitializedInOtherFieldInitializer(@NotNull PsiClass aClass, @NotNull PsiField field, boolean fieldStatic) {
        PsiField[] fields;
        for (PsiField psiField : fields = aClass.getFields()) {
            if (psiField == field || psiField.hasModifierProperty("static") != fieldStatic || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)psiField)) continue;
            return true;
        }
        return false;
    }

    static boolean isRecursivelyCalledConstructor(@NotNull PsiMethod constructor) {
        JavaHighlightUtil.ConstructorVisitorInfo info = new JavaHighlightUtil.ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.recursivelyCalledConstructor == null) {
            return false;
        }
        return info.visitedConstructors.indexOf(info.recursivelyCalledConstructor) <= info.visitedConstructors.indexOf(constructor);
    }

    public static boolean isAssigned(@NotNull PsiParameter parameter) {
        ParamWriteProcessor processor2 = new ParamWriteProcessor();
        ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(parameter.getDeclarationScope()), (boolean)true).forEach((Processor)processor2);
        return processor2.isWriteRefFound();
    }

    private static boolean variableDefinitelyAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    private static boolean variableDefinitelyNotAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyNotAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    @Nullable
    static HighlightInfo checkFinalFieldInitialized(@NotNull PsiField field) {
        if (!field.hasModifierProperty("final")) {
            return null;
        }
        if (HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return null;
        }
        String description = JavaErrorMessages.message("variable.not.initialized", field.getName());
        TextRange range = HighlightNamesUtil.getFieldDeclarationTextRange(field);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), QUICK_FIX_FACTORY.createCreateConstructorParameterFromFieldFix(field));
        QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), QUICK_FIX_FACTORY.createInitializeFinalFieldInConstructorFix(field));
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !containingClass.isInterface()) {
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "final", false, false));
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddVariableInitializerFix((PsiVariable)field));
        return highlightInfo;
    }

    @Nullable
    public static HighlightInfo checkVariableInitializedBeforeUsage(@NotNull PsiReferenceExpression expression2, @NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems, @NotNull PsiFile containingFile) {
        PsiElement topBlock;
        if (variable instanceof ImplicitVariable) {
            return null;
        }
        if (!PsiUtil.isAccessedForReading((PsiExpression)expression2)) {
            return null;
        }
        int startOffset = expression2.getTextRange().getStartOffset();
        if (variable.hasInitializer()) {
            topBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)variable);
            if (topBlock == null) {
                return null;
            }
        } else {
            PsiClass scope;
            Object object = variable instanceof PsiField ? ((PsiField)variable).getContainingClass() : (scope = variable.getParent() != null ? variable.getParent().getParent() : null);
            if (scope instanceof PsiCodeBlock && scope.getParent() instanceof PsiSwitchStatement) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)scope, PsiCodeBlock.class);
            }
            Object object2 = topBlock = FileTypeUtils.isInServerPageFile((PsiElement)scope) && scope instanceof PsiFile ? scope : PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression2, (PsiElement)scope);
            if (variable instanceof PsiField) {
                PsiClass aClass;
                PsiCodeBlock block;
                if (!variable.hasModifierProperty("final")) {
                    return null;
                }
                if (PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression2) == null && HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression2) == null) {
                    return null;
                }
                if (topBlock == null) {
                    return null;
                }
                PsiElement parent = topBlock.getParent();
                if (HighlightControlFlowUtil.inInnerClass((PsiElement)expression2, ((PsiField)variable).getContainingClass())) {
                    return null;
                }
                if (parent instanceof PsiMethod) {
                    PsiMethod constructor = (PsiMethod)parent;
                    if (!containingFile.getManager().areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    if (variable.hasModifierProperty("static")) {
                        return null;
                    }
                    List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
                    for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                        PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                        PsiMethod[] body2 = redirectedConstructor.getBody();
                        if (body2 == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body2)) continue;
                        return null;
                    }
                    block = constructor.getBody();
                    aClass = constructor.getContainingClass();
                } else if (parent instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)parent;
                    if (!containingFile.getManager().areElementsEquivalent((PsiElement)classInitializer.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    block = classInitializer.getBody();
                    aClass = classInitializer.getContainingClass();
                } else {
                    PsiMethod[] constructors;
                    PsiField field = (PsiField)variable;
                    aClass = field.getContainingClass();
                    PsiField anotherField = (PsiField)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression2, PsiField.class);
                    if (aClass == null || HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, field.hasModifierProperty("static"))) {
                        return null;
                    }
                    if (anotherField != null && !anotherField.hasModifierProperty("static") && field.hasModifierProperty("static") && HighlightControlFlowUtil.isFieldInitializedInClassInitializer(field, true, Arrays.stream(aClass.getInitializers()))) {
                        return null;
                    }
                    int offset = startOffset;
                    if (anotherField != null && anotherField.getContainingClass() == aClass && !field.hasModifierProperty("static")) {
                        offset = 0;
                    }
                    block = null;
                    for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                        if (offset < constructor.getTextRange().getStartOffset()) continue;
                        PsiCodeBlock body3 = constructor.getBody();
                        if (body3 != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body3)) {
                            return null;
                        }
                        List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
                        for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                            PsiCodeBlock redirectedBody;
                            PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                            if (offset < redirectedConstructor.getTextRange().getStartOffset() || (redirectedBody = redirectedConstructor.getBody()) == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)redirectedBody)) continue;
                            return null;
                        }
                    }
                }
                if (aClass != null) {
                    PsiClassInitializer initializer;
                    PsiCodeBlock body4;
                    PsiClassInitializer[] initializers;
                    PsiClassInitializer[] psiClassInitializerArray = initializers = aClass.getInitializers();
                    int n = psiClassInitializerArray.length;
                    for (int i = 0; i < n && (body4 = (initializer = psiClassInitializerArray[i]).getBody()) != block; ++i) {
                        boolean shouldCheckInitializerOrder;
                        boolean bl = shouldCheckInitializerOrder = block == null || block.getParent() instanceof PsiClassInitializer;
                        if (shouldCheckInitializerOrder && startOffset < initializer.getTextRange().getStartOffset() || initializer.hasModifierProperty("static") != variable.hasModifierProperty("static") || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body4)) continue;
                        return null;
                    }
                }
            }
        }
        if (topBlock == null) {
            return null;
        }
        Collection<PsiReferenceExpression> codeBlockProblems = uninitializedVarProblems.get(topBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(topBlock);
                codeBlockProblems = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
            }
            catch (IndexNotReadyException | AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            uninitializedVarProblems.put(topBlock, codeBlockProblems);
        }
        if (codeBlockProblems.contains(expression2)) {
            String name = expression2.getElement().getText();
            String description = JavaErrorMessages.message("variable.not.initialized", name);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddVariableInitializerFix(variable));
            if (variable instanceof PsiField) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean inInnerClass(@NotNull PsiElement psiElement, @Nullable PsiClass containingClass) {
        for (PsiElement element = psiElement; element != null; element = element.getParent()) {
            boolean innerClass;
            if (!(element instanceof PsiClass)) continue;
            boolean bl = innerClass = !psiElement.getManager().areElementsEquivalent(element, (PsiElement)containingClass);
            if (innerClass) {
                if (element instanceof PsiAnonymousClass) {
                    return !PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)element).getArgumentList(), (PsiElement)psiElement, (boolean)false) && !HighlightControlFlowUtil.insideClassInitialization(containingClass, (PsiClass)element);
                }
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLambdaExpression.class);
                return lambdaExpression == null || !HighlightControlFlowUtil.insideClassInitialization(containingClass, (PsiClass)element);
            }
            return false;
        }
        return false;
    }

    private static boolean insideClassInitialization(@Nullable PsiClass containingClass, PsiClass aClass) {
        PsiClass member = aClass;
        while (member != null) {
            if (member.getContainingClass() == containingClass) {
                return member instanceof PsiField || member instanceof PsiMethod && ((PsiMethod)member).isConstructor() || member instanceof PsiClassInitializer;
            }
            member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class, (boolean)true);
        }
        return false;
    }

    public static boolean isReassigned(@NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (variable instanceof PsiLocalVariable) {
            PsiElement parent = variable.getParent();
            if (parent == null) {
                return false;
            }
            PsiElement declarationScope = parent.getParent();
            if (declarationScope == null) {
                return false;
            }
            Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, declarationScope);
            return codeBlockProblems.contains(new ControlFlowUtil.VariableInfo(variable, null));
        }
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            return HighlightControlFlowUtil.isAssigned(parameter);
        }
        return false;
    }

    @Nullable
    public static HighlightInfo checkFinalVariableMightAlreadyHaveBeenAssignedTo(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression2, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (!PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
            return null;
        }
        Object scope = variable instanceof PsiField ? variable.getParent() : (variable.getParent() == null ? null : variable.getParent().getParent());
        PsiElement codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression2, (PsiElement)scope);
        if (codeBlock == null) {
            return null;
        }
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, codeBlock);
        boolean alreadyAssigned = false;
        for (ControlFlowUtil.VariableInfo variableInfo : codeBlockProblems) {
            if (variableInfo.expression != expression2) continue;
            alreadyAssigned = true;
            break;
        }
        if (!alreadyAssigned) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField[] fields = aClass.getFields();
            boolean isFieldStatic = field.hasModifierProperty("static");
            for (PsiField psiField : fields) {
                PsiExpression initializer = psiField.getInitializer();
                if (psiField == field || psiField.hasModifierProperty("static") != isFieldStatic || initializer == null || initializer == codeBlock || HighlightControlFlowUtil.variableDefinitelyNotAssignedIn((PsiVariable)field, (PsiElement)initializer)) continue;
                alreadyAssigned = true;
                break;
            }
            if (!alreadyAssigned) {
                PsiClassInitializer[] initializers;
                PsiMember enclosingConstructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression2);
                if (enclosingConstructorOrInitializer == null || !aClass.getManager().areElementsEquivalent((PsiElement)enclosingConstructorOrInitializer.getContainingClass(), (PsiElement)aClass)) {
                    return null;
                }
                for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                    if (initializer.hasModifierProperty("static") != field.hasModifierProperty("static")) continue;
                    PsiCodeBlock body2 = initializer.getBody();
                    if (body2 == codeBlock) {
                        return null;
                    }
                    try {
                        ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow((PsiElement)body2);
                        if (ControlFlowUtil.isVariableDefinitelyNotAssigned((PsiVariable)field, controlFlow)) continue;
                        alreadyAssigned = true;
                        break;
                    }
                    catch (AnalysisCanceledException e) {
                        return null;
                    }
                }
            }
            if (!alreadyAssigned && !field.hasModifierProperty("static")) {
                PsiMethod ctr = codeBlock.getParent() instanceof PsiMethod ? (PsiMethod)codeBlock.getParent() : null;
                List<PsiMethod> redirectedConstructors = ctr != null && ctr.isConstructor() ? JavaHighlightUtil.getChainedConstructors(ctr) : null;
                for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                    PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                    PsiCodeBlock body3 = redirectedConstructor.getBody();
                    if (body3 == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body3)) continue;
                    alreadyAssigned = true;
                    break;
                }
            }
        }
        if (alreadyAssigned) {
            String description = JavaErrorMessages.message("variable.already.assigned", variable.getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeferFinalAssignmentFix(variable, expression2));
            return highlightInfo;
        }
        return null;
    }

    @NotNull
    private static Collection<ControlFlowUtil.VariableInfo> getFinalVariableProblemsInBlock(@NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems, @NotNull PsiElement codeBlock) {
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = finalVarProblems.get(codeBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate(codeBlock);
                codeBlockProblems = ControlFlowUtil.getInitializedTwice(controlFlow);
            }
            catch (AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            finalVarProblems.put(codeBlock, codeBlockProblems);
        }
        return codeBlockProblems;
    }

    @Nullable
    static HighlightInfo checkFinalVariableInitializedInLoop(@NotNull PsiReferenceExpression expression2, @NotNull PsiElement resolved) {
        if (ControlFlowUtil.isVariableAssignedInLoop(expression2, resolved)) {
            String description = JavaErrorMessages.message("variable.assigned.in.loop", ((PsiVariable)resolved).getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)((PsiVariable)resolved), "final", false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCannotWriteToFinal(@NotNull PsiExpression expression2, @NotNull PsiFile containingFile) {
        boolean canWrite;
        PsiVariable variable;
        IElementType sign;
        PsiExpression operand2;
        PsiReferenceExpression reference = null;
        boolean readBeforeWrite = false;
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
            if (left instanceof PsiReferenceExpression) {
                reference = (PsiReferenceExpression)left;
            }
            readBeforeWrite = assignmentExpression.getOperationTokenType() != JavaTokenType.EQ;
        } else if (expression2 instanceof PsiPostfixExpression) {
            operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiPostfixExpression)expression2).getOperand());
            sign = ((PsiPostfixExpression)expression2).getOperationTokenType();
            if (operand2 instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand2;
            }
            readBeforeWrite = true;
        } else if (expression2 instanceof PsiPrefixExpression) {
            operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiPrefixExpression)expression2).getOperand());
            sign = ((PsiPrefixExpression)expression2).getOperationTokenType();
            if (operand2 instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand2;
            }
            readBeforeWrite = true;
        }
        PsiElement resolved = reference == null ? null : reference.resolve();
        PsiVariable psiVariable = variable = resolved instanceof PsiVariable ? (PsiVariable)resolved : null;
        if (variable == null || !variable.hasModifierProperty("final")) {
            return null;
        }
        boolean bl = canWrite = HighlightControlFlowUtil.canWriteToFinal(variable, expression2, reference, containingFile) && HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, (PsiJavaCodeReferenceElement)reference) == null;
        if (readBeforeWrite || !canWrite) {
            String name = variable.getName();
            String description = JavaErrorMessages.message(canWrite ? "variable.not.initialized" : "assignment.to.final.variable", name);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(reference.getTextRange()).descriptionAndTooltip(description).create();
            PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression2);
            if (innerClass == null || variable instanceof PsiField) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false));
            } else {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean canWriteToFinal(@NotNull PsiVariable variable, @NotNull PsiExpression expression2, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (variable.hasInitializer()) {
            return false;
        }
        if (variable instanceof PsiParameter) {
            return false;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression2);
        if (variable instanceof PsiField) {
            if (HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression2) != null) {
                return true;
            }
            PsiField field = (PsiField)variable;
            if (innerClass != null && !containingFile.getManager().areElementsEquivalent(innerClass, (PsiElement)field.getContainingClass())) {
                return false;
            }
            PsiMember enclosingCtrOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression2);
            return enclosingCtrOrInitializer != null && HighlightControlFlowUtil.isSameField(enclosingCtrOrInitializer, field, reference, containingFile);
        }
        if (variable instanceof PsiLocalVariable) {
            boolean isAccessedFromOtherClass;
            boolean bl = isAccessedFromOtherClass = innerClass != null;
            if (isAccessedFromOtherClass) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSameField(@NotNull PsiMember enclosingCtrOrInitializer, @NotNull PsiField field, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (!containingFile.getManager().areElementsEquivalent((PsiElement)enclosingCtrOrInitializer.getContainingClass(), (PsiElement)field.getContainingClass())) {
            return false;
        }
        PsiExpression qualifierExpression2 = reference.getQualifierExpression();
        return qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression;
    }

    @Nullable
    static HighlightInfo checkVariableMustBeFinal(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context, @NotNull LanguageLevel languageLevel) {
        if (variable.hasModifierProperty("final")) {
            return null;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)context);
        if (innerClass instanceof PsiClass) {
            PsiElement parent;
            if (variable instanceof PsiParameter && (parent = variable.getParent()) instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression && HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()))) {
                return null;
            }
            boolean isToBeEffectivelyFinal = languageLevel.isAtLeast(LanguageLevel.JDK_1_8);
            if (isToBeEffectivelyFinal && HighlightControlFlowUtil.isEffectivelyFinal(variable, innerClass, context)) {
                return null;
            }
            String description = JavaErrorMessages.message(isToBeEffectivelyFinal ? "variable.must.be.final.or.effectively.final" : "variable.must.be.final", context.getText());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
            return highlightInfo;
        }
        return HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, context);
    }

    private static HighlightInfo checkWriteToFinalInsideLambda(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context) {
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class);
        if (lambdaExpression != null && !PsiTreeUtil.isAncestor((PsiElement)lambdaExpression, (PsiElement)variable, (boolean)true)) {
            PsiElement parent = variable.getParent();
            if (parent instanceof PsiParameterList && parent.getParent() == lambdaExpression) {
                return null;
            }
            if (!HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)lambdaExpression, context)) {
                String text = JavaErrorMessages.message("lambda.variable.must.be.final", new Object[0]);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)context).descriptionAndTooltip(text).create();
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, (PsiElement)lambdaExpression));
                return highlightInfo;
            }
        }
        return null;
    }

    public static boolean isEffectivelyFinal(@NotNull PsiVariable variable, @NotNull PsiElement scope, @Nullable PsiJavaCodeReferenceElement context) {
        boolean effectivelyFinal;
        if (variable instanceof PsiParameter) {
            effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()));
        } else {
            ControlFlow controlFlow;
            try {
                PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)context);
                if (codeBlock == null) {
                    return true;
                }
                controlFlow = HighlightControlFlowUtil.getControlFlow(codeBlock);
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
            Collection<ControlFlowUtil.VariableInfo> initializedTwice = ControlFlowUtil.getInitializedTwice(controlFlow);
            boolean bl = effectivelyFinal = !initializedTwice.contains(new ControlFlowUtil.VariableInfo(variable, null));
            if (effectivelyFinal) {
                List<PsiReferenceExpression> readBeforeWriteLocals = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
                for (PsiReferenceExpression expression2 : readBeforeWriteLocals) {
                    if (expression2.resolve() != variable) continue;
                    return PsiUtil.isAccessedForReading((PsiExpression)expression2);
                }
                effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(scope));
            }
        }
        return effectivelyFinal;
    }

    private static boolean notAccessedForWriting(@NotNull PsiVariable variable, @NotNull LocalSearchScope searchScope) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope)) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiElement getInnerClassVariableReferencedFrom(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        PsiElement parent;
        PsiElement[] scope;
        if (variable instanceof PsiResourceVariable) {
            scope = ((PsiResourceVariable)variable).getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            parent = variable.getParent();
            scope = new PsiElement[]{parent != null ? parent.getParent() : null};
        } else {
            scope = variable instanceof PsiParameter ? new PsiElement[]{((PsiParameter)variable).getDeclarationScope()} : new PsiElement[]{variable.getParent()};
        }
        if (scope.length < 1 || scope[0] == null || scope[0].getContainingFile() != context.getContainingFile()) {
            return null;
        }
        PsiElement prevParent = context;
        block0: for (parent = context.getParent(); parent != null; parent = parent.getParent()) {
            for (PsiElement scopeElement : scope) {
                if (parent.equals(scopeElement)) break block0;
            }
            if (!(!(parent instanceof PsiClass) || prevParent instanceof PsiExpressionList && parent instanceof PsiAnonymousClass)) {
                return parent;
            }
            if (parent instanceof PsiLambdaExpression) {
                return parent;
            }
            prevParent = parent;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInitializerCompleteNormally(@NotNull PsiClassInitializer initializer) {
        PsiCodeBlock body2 = initializer.getBody();
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body2);
            int completionReasons = ControlFlowUtil.getCompletionReasons(controlFlow, 0, controlFlow.getSize());
            if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                String description = JavaErrorMessages.message("initializer.must.be.able.to.complete.normally", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)body2).descriptionAndTooltip(description).create();
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    private static class ParamWriteProcessor
    implements Processor<PsiReference> {
        private volatile boolean myIsWriteRefFound;

        private ParamWriteProcessor() {
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            if (element instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                this.myIsWriteRefFound = true;
                return false;
            }
            return true;
        }

        private boolean isWriteRefFound() {
            return this.myIsWriteRefFound;
        }
    }
}

