/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightNamesUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + HighlightNamesUtil.class.getName()));

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMethod method2, @NotNull PsiElement elementToHighlight, boolean isDeclaration, @NotNull TextAttributesScheme colorsScheme) {
        return HighlightNamesUtil.highlightMethodName((PsiMember)method2, elementToHighlight, elementToHighlight.getTextRange(), colorsScheme, isDeclaration);
    }

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMember methodOrClass, @NotNull PsiElement elementToHighlight, @NotNull TextRange range, @NotNull TextAttributesScheme colorsScheme, boolean isDeclaration) {
        HighlightInfoType type2;
        boolean isInherited = false;
        if (!isDeclaration && HighlightNamesUtil.isCalledOnThis(elementToHighlight)) {
            PsiClass enclosingClass;
            PsiClass containingClass = methodOrClass instanceof PsiMethod ? methodOrClass.getContainingClass() : null;
            PsiClass psiClass = enclosingClass = containingClass == null ? null : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiClass.class);
            while (enclosingClass != null && !(isInherited = enclosingClass.isInheritor(containingClass, true))) {
                enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)enclosingClass, PsiClass.class, (boolean)true);
            }
        }
        LOG.assertTrue(methodOrClass instanceof PsiMethod || !isDeclaration);
        HighlightInfoType highlightInfoType = type2 = methodOrClass instanceof PsiMethod ? HighlightNamesUtil.getMethodNameHighlightType((PsiMethod)methodOrClass, isDeclaration, isInherited) : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        if (type2 != null) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)methodOrClass, type2, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type2).range(range);
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        return null;
    }

    private static boolean isCalledOnThis(@NotNull PsiElement elementToHighlight) {
        PsiElement qualifier;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiMethodCallExpression.class);
        return methodCallExpression != null && ((qualifier = methodCallExpression.getMethodExpression().getQualifier()) == null || qualifier instanceof PsiThisExpression);
    }

    private static TextAttributes mergeWithScopeAttributes(@Nullable PsiElement element, @NotNull HighlightInfoType type2, @NotNull TextAttributesScheme colorsScheme) {
        TextAttributes regularAttributes = HighlightInfo.getAttributesByType(element, type2, colorsScheme);
        if (element == null) {
            return regularAttributes;
        }
        TextAttributes scopeAttributes = HighlightNamesUtil.getScopeAttributes(element, colorsScheme);
        return TextAttributes.merge((TextAttributes)scopeAttributes, (TextAttributes)regularAttributes);
    }

    @NotNull
    static HighlightInfo highlightClassName(@Nullable PsiClass aClass, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement parent;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement identifier;
        TextRange range = elementToHighlight.getTextRange();
        if (elementToHighlight instanceof PsiJavaCodeReferenceElement && (identifier = (referenceElement = (PsiJavaCodeReferenceElement)elementToHighlight).getReferenceNameElement()) != null) {
            range = identifier.getTextRange();
        }
        if ((parent = elementToHighlight.getParent()) instanceof PsiAnnotation) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)parent;
            range = new TextRange(psiAnnotation.getTextRange().getStartOffset(), range.getEndOffset());
        }
        HighlightInfoType type2 = HighlightNamesUtil.getClassNameHighlightType(aClass, elementToHighlight);
        TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)aClass, type2, colorsScheme);
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type2).range(range);
        if (attributes != null) {
            builder.textAttributes(attributes);
        }
        return builder.createUnconditionally();
    }

    @Nullable
    static HighlightInfo highlightVariableName(@NotNull PsiVariable variable, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        HighlightInfoType varType = HighlightNamesUtil.getVariableNameHighlightType(variable);
        if (varType == null) {
            return null;
        }
        if (variable instanceof PsiField) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)variable, varType, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(varType).range(elementToHighlight.getTextRange());
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(varType).range(elementToHighlight);
        return RainbowHighlighter.isRainbowEnabledWithInheritance(colorsScheme, (Language)JavaLanguage.INSTANCE) ? builder.createUnconditionally() : builder.create();
    }

    @Nullable
    static HighlightInfo highlightClassNameInQualifier(@NotNull PsiJavaCodeReferenceElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement resolved;
        PsiElement qualifierExpression2 = element.getQualifier();
        if (qualifierExpression2 instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifierExpression2).resolve()) instanceof PsiClass) {
            return HighlightNamesUtil.highlightClassName((PsiClass)resolved, qualifierExpression2, colorsScheme);
        }
        return null;
    }

    private static HighlightInfoType getMethodNameHighlightType(@NotNull PsiMethod method2, boolean isDeclaration, boolean isInheritedMethod) {
        if (method2.isConstructor()) {
            return isDeclaration ? JavaHighlightInfoTypes.CONSTRUCTOR_DECLARATION : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        }
        if (isDeclaration) {
            return JavaHighlightInfoTypes.METHOD_DECLARATION;
        }
        if (method2.hasModifierProperty("static")) {
            return JavaHighlightInfoTypes.STATIC_METHOD;
        }
        if (isInheritedMethod) {
            return JavaHighlightInfoTypes.INHERITED_METHOD;
        }
        if (method2.hasModifierProperty("abstract")) {
            return JavaHighlightInfoTypes.ABSTRACT_METHOD;
        }
        return JavaHighlightInfoTypes.METHOD_CALL;
    }

    @Nullable
    private static HighlightInfoType getVariableNameHighlightType(@NotNull PsiVariable var) {
        if (var instanceof PsiLocalVariable || var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement) {
            return JavaHighlightInfoTypes.LOCAL_VARIABLE;
        }
        if (var instanceof PsiField) {
            return var.hasModifierProperty("static") ? (var.hasModifierProperty("final") ? JavaHighlightInfoTypes.STATIC_FINAL_FIELD : JavaHighlightInfoTypes.STATIC_FIELD) : (var.hasModifierProperty("final") ? JavaHighlightInfoTypes.INSTANCE_FINAL_FIELD : JavaHighlightInfoTypes.INSTANCE_FIELD);
        }
        if (var instanceof PsiParameter) {
            return ((PsiParameter)var).getDeclarationScope() instanceof PsiLambdaExpression ? JavaHighlightInfoTypes.LAMBDA_PARAMETER : JavaHighlightInfoTypes.PARAMETER;
        }
        return null;
    }

    @NotNull
    private static HighlightInfoType getClassNameHighlightType(@Nullable PsiClass aClass, @Nullable PsiElement element) {
        if (element instanceof PsiJavaCodeReferenceElement && element.getParent() instanceof PsiAnonymousClass) {
            return JavaHighlightInfoTypes.ANONYMOUS_CLASS_NAME;
        }
        if (aClass != null) {
            if (aClass.isAnnotationType()) {
                return JavaHighlightInfoTypes.ANNOTATION_NAME;
            }
            if (aClass.isInterface()) {
                return JavaHighlightInfoTypes.INTERFACE_NAME;
            }
            if (aClass.isEnum()) {
                return JavaHighlightInfoTypes.ENUM_NAME;
            }
            if (aClass instanceof PsiTypeParameter) {
                return JavaHighlightInfoTypes.TYPE_PARAMETER_NAME;
            }
            PsiModifierList modList = aClass.getModifierList();
            if (modList != null && modList.hasModifierProperty("abstract")) {
                return JavaHighlightInfoTypes.ABSTRACT_CLASS_NAME;
            }
        }
        return JavaHighlightInfoTypes.CLASS_NAME;
    }

    @Nullable
    static HighlightInfo highlightReassignedVariable(@NotNull PsiVariable variable, @NotNull PsiElement elementToHighlight) {
        if (variable instanceof PsiLocalVariable) {
            return HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.REASSIGNED_LOCAL_VARIABLE).range(elementToHighlight).create();
        }
        if (variable instanceof PsiParameter) {
            return HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.REASSIGNED_PARAMETER).range(elementToHighlight).create();
        }
        return null;
    }

    private static TextAttributes getScopeAttributes(@NotNull PsiElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        TextAttributes result2 = null;
        DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)file2.getProject());
        List<Pair<NamedScope, NamedScopesHolder>> scopes = validationManager.getScopeBasedHighlightingCachedScopes();
        for (Pair<NamedScope, NamedScopesHolder> scope : scopes) {
            PackageSet packageSet;
            NamedScope namedScope = (NamedScope)scope.getFirst();
            TextAttributesKey scopeKey = ScopeAttributesUtil.getScopeTextAttributeKey(namedScope.getName());
            TextAttributes attributes = colorsScheme.getAttributes(scopeKey);
            if (attributes == null || attributes.isEmpty() || (packageSet = namedScope.getValue()) == null || !packageSet.contains(file2, (NamedScopesHolder)scope.getSecond())) continue;
            result2 = TextAttributes.merge((TextAttributes)attributes, result2);
        }
        return result2;
    }

    @NotNull
    public static TextRange getMethodDeclarationTextRange(@NotNull PsiMethod method2) {
        if (method2 instanceof SyntheticElement) {
            return TextRange.EMPTY_RANGE;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)method2.getModifierList());
        TextRange throwsRange = method2.getThrowsList().getTextRange();
        LOG.assertTrue(throwsRange != null, (Object)method2);
        int end = throwsRange.getEndOffset();
        return new TextRange(start, end);
    }

    @NotNull
    public static TextRange getFieldDeclarationTextRange(@NotNull PsiField field) {
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)field.getModifierList());
        int end = field.getNameIdentifier().getTextRange().getEndOffset();
        return new TextRange(start, end);
    }

    @NotNull
    public static TextRange getClassDeclarationTextRange(@NotNull PsiClass aClass) {
        PsiReferenceList endElement;
        PsiJavaCodeReferenceElement psiElement;
        if (aClass instanceof PsiEnumConstantInitializer) {
            return ((PsiEnumConstantInitializer)aClass).getEnumConstant().getNameIdentifier().getTextRange();
        }
        Object object = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : (psiElement = aClass.getModifierList() == null ? aClass.getNameIdentifier() : aClass.getModifierList());
        if (psiElement == null) {
            return new TextRange(aClass.getTextRange().getStartOffset(), aClass.getTextRange().getStartOffset());
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)psiElement);
        Object object2 = endElement = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : aClass.getImplementsList();
        if (endElement == null) {
            endElement = aClass.getNameIdentifier();
        }
        TextRange endTextRange = endElement == null ? null : endElement.getTextRange();
        int end = endTextRange == null ? start : endTextRange.getEndOffset();
        return new TextRange(start, end);
    }

    private static int stripAnnotationsFromModifierList(@NotNull PsiElement element) {
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return 0;
        }
        PsiAnnotation lastAnnotation = null;
        for (PsiElement child : element.getChildren()) {
            if (!(child instanceof PsiAnnotation)) continue;
            lastAnnotation = (PsiAnnotation)child;
        }
        if (lastAnnotation == null) {
            return textRange.getStartOffset();
        }
        ASTNode node = lastAnnotation.getNode();
        if (node != null) {
            while ((node = TreeUtil.nextLeaf(node)) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(node.getElementType())) {
            }
        }
        if (node != null) {
            return node.getTextRange().getStartOffset();
        }
        return textRange.getStartOffset();
    }

    static HighlightInfo highlightPackage(@NotNull PsiElement resolved, @NotNull PsiJavaCodeReferenceElement elementToHighlight, @NotNull TextAttributesScheme scheme2) {
        TextRange range;
        PsiElement referenceNameElement = elementToHighlight.getReferenceNameElement();
        if (referenceNameElement == null) {
            range = elementToHighlight.getTextRange();
        } else {
            PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)referenceNameElement);
            if (nextSibling != null && nextSibling.getTextRange().isEmpty()) {
                nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
            }
            range = nextSibling instanceof PsiJavaToken && ((PsiJavaToken)nextSibling).getTokenType() == JavaTokenType.DOT ? new TextRange(referenceNameElement.getTextRange().getStartOffset(), nextSibling.getTextRange().getEndOffset()) : referenceNameElement.getTextRange();
        }
        HighlightInfoType type2 = JavaHighlightInfoTypes.CLASS_NAME;
        TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes(resolved, type2, scheme2);
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type2).range(range);
        if (attributes != null) {
            builder.textAttributes(attributes);
        }
        return builder.createUnconditionally();
    }
}

