/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertRequiredAttributeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myAttrName;
    private final String[] myValues;
    @NonNls
    private static final String NAME_TEMPLATE_VARIABLE = "name";

    public InsertRequiredAttributeFix(@NotNull XmlTag tag, @NotNull String attrName, String ... values) {
        super((PsiElement)tag);
        this.myAttrName = attrName;
        this.myValues = values;
    }

    @NotNull
    public String getText() {
        return XmlErrorMessages.message("insert.required.attribute.quickfix.text", this.myAttrName);
    }

    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("insert.required.attribute.quickfix.family", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        boolean anchorIsEmptyTag;
        XmlTag myTag = (XmlTag)startElement;
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)myTag);
        XmlElementDescriptor descriptor = myTag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor attrDescriptor = descriptor.getAttributeDescriptor(this.myAttrName, myTag);
        boolean indirectSyntax = XmlExtension.getExtension(myTag.getContainingFile()).isIndirectSyntax(attrDescriptor);
        boolean insertShorthand = myTag instanceof HtmlTag && attrDescriptor != null && HtmlUtil.isBooleanAttribute(attrDescriptor, (PsiElement)myTag);
        PsiElement anchor = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.EMPTY_TAG_END_FINDER.findChild(treeElement));
        boolean bl = anchorIsEmptyTag = anchor != null;
        if (anchor == null) {
            anchor = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.START_TAG_END_FINDER.findChild(treeElement));
        }
        if (anchor == null) {
            return;
        }
        Template template = TemplateManager.getInstance(project2).createTemplate("", "");
        if (indirectSyntax) {
            if (anchorIsEmptyTag) {
                template.addTextSegment(">");
            }
            template.addTextSegment("<jsp:attribute name=\"" + this.myAttrName + "\">");
        } else {
            template.addTextSegment(" " + this.myAttrName + (!insertShorthand ? "=\"" : ""));
        }
        Expression expression2 = new Expression(){
            final TextResult result = new TextResult("");

            public Result calculateResult(ExpressionContext context) {
                return this.result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                LookupElement[] items = new LookupElement[InsertRequiredAttributeFix.this.myValues.length];
                for (int i2 = 0; i2 < items.length; ++i2) {
                    items[i2] = LookupElementBuilder.create((String)InsertRequiredAttributeFix.this.myValues[i2]);
                }
                return items;
            }
        };
        if (!insertShorthand) {
            template.addVariable(NAME_TEMPLATE_VARIABLE, expression2, expression2, true);
        }
        if (indirectSyntax) {
            template.addTextSegment("</jsp:attribute>");
            template.addEndVariable();
            if (anchorIsEmptyTag) {
                template.addTextSegment("</" + myTag.getName() + ">");
            }
        } else if (!insertShorthand) {
            template.addTextSegment("\"");
        }
        PsiElement anchor1 = anchor;
        Runnable runnable2 = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            int textOffset = anchor1.getTextOffset();
            if (!anchorIsEmptyTag && indirectSyntax) {
                ++textOffset;
            }
            editor.getCaretModel().moveToOffset(textOffset);
            if (anchorIsEmptyTag && indirectSyntax) {
                editor.getDocument().deleteString(textOffset, textOffset + 2);
            }
            TemplateManager.getInstance(project2).startTemplate(editor, template);
        });
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Runnable commandRunnable = () -> CommandProcessor.getInstance().executeCommand(project2, runnable2, this.getText(), (Object)this.getFamilyName());
            ApplicationManager.getApplication().invokeLater(commandRunnable);
        } else {
            runnable2.run();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

