/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHighlightUtil {
    public static boolean isSerializable(@NotNull PsiClass aClass) {
        return JavaHighlightUtil.isSerializable(aClass, "java.io.Serializable");
    }

    public static boolean isSerializable(@NotNull PsiClass aClass, String serializableClassName) {
        Project project2 = aClass.getManager().getProject();
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)project2).findClass(serializableClassName, aClass.getResolveScope());
        return serializableClass != null && aClass.isInheritor(serializableClass, true);
    }

    public static boolean isSerializationRelatedMethod(PsiMethod method2, PsiClass containingClass) {
        if (containingClass == null) {
            return false;
        }
        if (method2.isConstructor()) {
            return JavaHighlightUtil.isSerializable(containingClass, "java.io.Externalizable") && method2.getParameterList().getParametersCount() == 0 && method2.hasModifierProperty("public");
        }
        if (method2.hasModifierProperty("static")) {
            return false;
        }
        String name = method2.getName();
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        PsiType returnType = method2.getReturnType();
        if ("readObjectNoData".equals(name)) {
            return parameters2.length == 0 && TypeConversionUtil.isVoidType((PsiType)returnType) && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readObject".equals(name)) {
            return parameters2.length == 1 && parameters2[0].getType().equalsToText("java.io.ObjectInputStream") && TypeConversionUtil.isVoidType((PsiType)returnType) && method2.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readResolve".equals(name)) {
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeReplace".equals(name)) {
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeObject".equals(name)) {
            return parameters2.length == 1 && TypeConversionUtil.isVoidType((PsiType)returnType) && parameters2[0].getType().equalsToText("java.io.ObjectOutputStream") && method2.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        return false;
    }

    @NotNull
    public static String formatType(@Nullable PsiType type2) {
        return type2 == null ? "null" : type2.getInternalCanonicalText();
    }

    @Nullable
    private static PsiType getArrayInitializerType(@NotNull PsiArrayInitializerExpression element) {
        PsiType typeCheckResult = JavaHighlightUtil.sameType(element.getInitializers());
        return typeCheckResult != null ? typeCheckResult.createArrayType() : null;
    }

    @Nullable
    public static PsiType sameType(@NotNull PsiExpression[] expressions2) {
        PsiType type2 = null;
        for (PsiExpression expression2 : expressions2) {
            PsiType currentType = expression2 instanceof PsiArrayInitializerExpression ? JavaHighlightUtil.getArrayInitializerType((PsiArrayInitializerExpression)expression2) : expression2.getType();
            if (type2 == null) {
                type2 = currentType;
                continue;
            }
            if (type2.equals(currentType)) continue;
            return null;
        }
        return type2;
    }

    @NotNull
    public static String formatMethod(@NotNull PsiMethod method2) {
        return PsiFormatUtil.formatMethod((PsiMethod)method2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
    }

    public static boolean isSuperOrThisCall(PsiStatement statement2, boolean testForSuper, boolean testForThis) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statement2).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression2).getMethodExpression();
        if (testForSuper && "super".equals(methodExpression.getText())) {
            return true;
        }
        return testForThis && "this".equals(methodExpression.getText());
    }

    @Nullable
    public static List<PsiMethod> getChainedConstructors(PsiMethod constructor) {
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.visitedConstructors != null) {
            info.visitedConstructors.remove(constructor);
        }
        return info.visitedConstructors;
    }

    static void visitConstructorChain(PsiMethod constructor, @NotNull ConstructorVisitorInfo info) {
        while (constructor != null) {
            PsiCodeBlock body2 = constructor.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement[] statements = body2.getStatements();
            if (statements.length == 0) {
                return;
            }
            PsiStatement statement2 = statements[0];
            PsiElement element = new PsiMatcherImpl((PsiElement)statement2).dot(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).dot(PsiMatchers.hasText("this")).parent(null).parent(null).getElement();
            if (element == null) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiMethod method2 = methodCall.resolveMethod();
            if (method2 == null) {
                return;
            }
            if (info.visitedConstructors != null && info.visitedConstructors.contains(method2)) {
                info.recursivelyCalledConstructor = method2;
                return;
            }
            if (info.visitedConstructors == null) {
                info.visitedConstructors = new ArrayList<PsiMethod>(5);
            }
            info.visitedConstructors.add(method2);
            constructor = method2;
        }
        return;
    }

    @Nullable
    public static String checkPsiTypeUseInContext(@Nullable PsiType type2, @NotNull PsiElement context) {
        if (type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            return JavaHighlightUtil.checkPsiTypeUseInContext(((PsiArrayType)type2).getComponentType(), context);
        }
        if (PsiUtil.resolveClassInType((PsiType)type2) != null) {
            return null;
        }
        if (type2 instanceof PsiClassType) {
            return JavaHighlightUtil.checkClassType((PsiClassType)type2, context);
        }
        return "Invalid Java type";
    }

    private static String checkClassType(@NotNull PsiClassType type2, @NotNull PsiElement context) {
        String className = PsiNameHelper.getQualifiedClassName((String)type2.getCanonicalText(false), (boolean)true);
        if (JavaHighlightUtil.classExists(context, className)) {
            return JavaHighlightUtil.getClassInaccessibleMessage(context, className);
        }
        return "Invalid Java type";
    }

    private static boolean classExists(@NotNull PsiElement context, String className) {
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className, GlobalSearchScope.allScope((Project)context.getProject())) != null;
    }

    @NotNull
    private static String getClassInaccessibleMessage(@NotNull PsiElement context, String className) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        return "Class '" + className + "' is not accessible " + (module2 == null ? "here" : "from module '" + module2.getName() + "'");
    }

    static class ConstructorVisitorInfo {
        List<PsiMethod> visitedConstructors;
        PsiMethod recursivelyCalledConstructor;

        ConstructorVisitorInfo() {
        }
    }
}

