/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiredModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ModuleHighlightUtil {
    @Nullable
    static PsiJavaModule getModuleDescriptor(@NotNull PsiFileSystemItem fsItem) {
        VirtualFile file2 = fsItem.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        Project project2 = fsItem.getProject();
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        if (index.isInLibraryClasses(file2)) {
            VirtualFile classRoot = index.getClassRootForFile(file2);
            if (classRoot != null) {
                VirtualFile descriptorFile = classRoot.findChild("module-info.class");
                if (descriptorFile == null) {
                    descriptorFile = classRoot.findFileByRelativePath("META-INF/versions/9/module-info.class");
                }
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (classRoot.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(classRoot.getExtension())) {
                    return LightJavaModule.getModule(PsiManager.getInstance((Project)project2), classRoot);
                }
            }
            return null;
        }
        return ModuleHighlightUtil.getModuleDescriptor(index.getModuleForFile(file2));
    }

    static PsiJavaModule getModuleDescriptor(Module module2) {
        return Optional.ofNullable(module2).map(m -> FilenameIndex.getVirtualFilesByName(module2.getProject(), "module-info.java", m.getModuleScope(false))).map(c -> c.size() == 1 ? (VirtualFile)c.iterator().next() : null).map(f -> PsiManager.getInstance((Project)module2.getProject()).findFile(f)).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).orElse(null);
    }

    static HighlightInfo checkPackageStatement(@NotNull PsiPackageStatement statement2, @NotNull PsiFile file2, @Nullable PsiJavaModule module2) {
        PsiJavaModule origin;
        String packageName;
        if (PsiUtil.isModuleFile((PsiFile)file2)) {
            String message2 = JavaErrorMessages.message("module.no.package", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement2).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement2));
            return info;
        }
        if (module2 != null && (packageName = statement2.getPackageName()) != null && (origin = JavaModuleGraphUtil.findOrigin(module2, packageName)) != null) {
            String message3 = JavaErrorMessages.message("module.conflicting.packages", packageName, origin.getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement2).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file2) {
        if (!"module-info.java".equals(file2.getName())) {
            String message2 = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file2) {
        Project project2;
        Collection<VirtualFile> others;
        Module module2 = ModuleHighlightUtil.findModule((PsiElement)file2);
        if (module2 != null && (others = FilenameIndex.getVirtualFilesByName(project2 = file2.getProject(), "module-info.java", module2.getModuleScope(false))).size() > 1) {
            String message2 = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            others.stream().map(f -> PsiManager.getInstance((Project)project2).findFile(f)).filter(f -> f != file2).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction(info, new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module2) {
        List results = ContainerUtil.newSmartList();
        ModuleHighlightUtil.checkDuplicateRefs(module2.getRequires(), st -> Optional.ofNullable(st.getReferenceElement()).map(PsiJavaModuleReferenceElement::getReferenceText), "module.duplicate.requires", results);
        ModuleHighlightUtil.checkDuplicateRefs(module2.getExports(), st -> Optional.ofNullable(st.getPackageReference()).map(ModuleHighlightUtil::refText), "module.duplicate.exports", results);
        ModuleHighlightUtil.checkDuplicateRefs(module2.getOpens(), st -> Optional.ofNullable(st.getPackageReference()).map(ModuleHighlightUtil::refText), "module.duplicate.opens", results);
        ModuleHighlightUtil.checkDuplicateRefs(module2.getUses(), st -> Optional.ofNullable(st.getClassReference()).map(ModuleHighlightUtil::refText), "module.duplicate.uses", results);
        ModuleHighlightUtil.checkDuplicateRefs(module2.getProvides(), st -> Optional.ofNullable(st.getInterfaceReference()).map(ModuleHighlightUtil::refText), "module.duplicate.provides", results);
        return results;
    }

    private static <T extends PsiElement> void checkDuplicateRefs(Iterable<T> statements, Function<T, Optional<String>> ref, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key2, List<HighlightInfo> results) {
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiElement statement2 : statements) {
            String refText = ref.apply(statement2).orElse(null);
            if (refText == null || filter.add(refText)) continue;
            String message2 = JavaErrorMessages.message(key2, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement2).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix(statement2));
            results.add(info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module2) {
        List results = ContainerUtil.newSmartList();
        Set exports = JBIterable.from((Iterable)module2.getExports()).map(st -> ModuleHighlightUtil.refText(st.getPackageReference())).filter(Objects::nonNull).toSet();
        Set uses = JBIterable.from((Iterable)module2.getUses()).map(st -> ModuleHighlightUtil.refText(st.getClassReference())).filter(Objects::nonNull).toSet();
        Module host = ModuleHighlightUtil.findModule((PsiElement)module2);
        for (PsiProvidesStatement statement2 : module2.getProvides()) {
            String className;
            String packageName;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = statement2.getInterfaceReference();
            if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleHighlightUtil.findModule(target) != host || exports.contains(packageName = StringUtil.getPackageName((String)(className = ModuleHighlightUtil.refText(ref)))) || uses.contains(className)) continue;
            String message2 = JavaErrorMessages.message("module.service.unused", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).descriptionAndTooltip(message2).create());
        }
        return results;
    }

    private static String refText(PsiJavaCodeReferenceElement ref) {
        return ref != null ? PsiNameHelper.getQualifiedClassName((String)ref.getText(), (boolean)true) : null;
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file2) {
        VirtualFile root;
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile != null && (root = ProjectFileIndex.SERVICE.getInstance((Project)file2.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message2 = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction(info, new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@Nullable PsiJavaModuleReferenceElement refElement, @NotNull PsiJavaModule container) {
        if (refElement != null) {
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                return ModuleHighlightUtil.moduleResolveError(refElement, ref);
            }
            if (target == container) {
                String message2 = JavaErrorMessages.message("module.cyclic.dependence", container.getName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle((PsiJavaModule)target);
            if (cycle != null && cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message3 = JavaErrorMessages.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkHostModuleStrength(@NotNull PsiPackageAccessibilityStatement statement2) {
        PsiElement parent;
        if (statement2.getRole() == PsiPackageAccessibilityStatement.Role.OPENS && (parent = statement2.getParent()) instanceof PsiJavaModule && ((PsiJavaModule)parent).hasModifierProperty("open")) {
            String message2 = JavaErrorMessages.message("module.opens.in.weak.module", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement2).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)ModuleHighlightUtil.factory().createModifierListFix((PsiModifierListOwner)parent, "open", false, false));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement2) {
        PsiJavaCodeReferenceElement refElement = statement2.getPackageReference();
        if (refElement != null) {
            HighlightInfoType type2;
            PsiElement target = refElement.resolve();
            Module module2 = ModuleHighlightUtil.findModule((PsiElement)refElement);
            PsiDirectory[] directories = target instanceof PsiPackage && module2 != null ? ((PsiPackage)target).getDirectories(module2.getModuleScope(false)) : null;
            String packageName = ModuleHighlightUtil.refText(refElement);
            HighlightInfoType highlightInfoType = type2 = statement2.getRole() == PsiPackageAccessibilityStatement.Role.OPENS ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            if (directories == null || directories.length == 0) {
                String message2 = JavaErrorMessages.message("package.not.found", packageName);
                return HighlightInfo.newHighlightInfo(type2).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
            }
            if (PsiUtil.isPackageEmpty((PsiDirectory[])directories, (String)packageName)) {
                String message3 = JavaErrorMessages.message("package.is.empty", packageName);
                return HighlightInfo.newHighlightInfo(type2).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
            }
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkPackageAccessTargets(@NotNull PsiPackageAccessibilityStatement statement2) {
        List results = ContainerUtil.newSmartList();
        THashSet targets = ContainerUtil.newTroveSet();
        for (PsiJavaModuleReferenceElement refElement : statement2.getModuleReferences()) {
            String refText = refElement.getReferenceText();
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : statement2;
            if (!targets.add(refText)) {
                boolean exports = statement2.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS;
                String message2 = JavaErrorMessages.message(exports ? "module.duplicate.exports.target" : "module.duplicate.opens.target", refText);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)refElement, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
                results.add(info);
                continue;
            }
            if (ref.multiResolve(true).length != 0) continue;
            String message3 = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create());
        }
        return results;
    }

    @Nullable
    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        if (refElement != null) {
            PsiElement target = refElement.resolve();
            if (target == null) {
                String message2 = JavaErrorMessages.message("cannot.resolve.symbol", refElement.getReferenceName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message2).create();
            }
            if (target instanceof PsiClass && ((PsiClass)target).isEnum()) {
                String message3 = JavaErrorMessages.message("module.service.enum", ((PsiClass)target).getName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message3).create();
            }
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkServiceImplementations(@NotNull PsiProvidesStatement statement2) {
        PsiReferenceList implRefList = statement2.getImplementationList();
        if (implRefList == null) {
            return null;
        }
        List results = ContainerUtil.newSmartList();
        PsiJavaCodeReferenceElement intRef = statement2.getInterfaceReference();
        PsiElement intTarget = intRef != null ? intRef.resolve() : null;
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiJavaCodeReferenceElement implRef : implRefList.getReferenceElements()) {
            String message2;
            PsiMethod provider2;
            PsiElement implTarget;
            String refText = ModuleHighlightUtil.refText(implRef);
            if (!filter.add(refText)) {
                String message3 = JavaErrorMessages.message("module.duplicate.impl", refText);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)implRef).descriptionAndTooltip(message3).create();
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)implRef, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
                results.add(info);
                continue;
            }
            if (!(intTarget instanceof PsiClass) || !((implTarget = implRef.resolve()) instanceof PsiClass)) continue;
            PsiClass implClass = (PsiClass)implTarget;
            if (ModuleHighlightUtil.findModule((PsiElement)statement2) != ModuleHighlightUtil.findModule((PsiElement)implClass)) {
                String message4 = JavaErrorMessages.message("module.service.alien", new Object[0]);
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message4).create());
            }
            if ((provider2 = (PsiMethod)ContainerUtil.find((Object[])implClass.findMethodsByName("provider", false), m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().getParametersCount() == 0)) != null) {
                PsiClass typeClass;
                PsiType type2 = provider2.getReturnType();
                PsiClass psiClass = typeClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)typeClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) continue;
                String message5 = JavaErrorMessages.message("module.service.provider.type", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message5).create());
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)implClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) {
                if (implClass.hasModifierProperty("abstract")) {
                    message2 = JavaErrorMessages.message("module.service.abstract", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (!ClassUtil.isTopLevelClass((PsiClass)implClass) && !implClass.hasModifierProperty("static")) {
                    message2 = JavaErrorMessages.message("module.service.inner", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (PsiUtil.hasDefaultConstructor((PsiClass)implClass)) continue;
                message2 = JavaErrorMessages.message("module.service.no.ctor", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                continue;
            }
            message2 = JavaErrorMessages.message("module.service.impl", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
        }
        return results;
    }

    @Nullable
    static HighlightInfo checkPackageAccessibility(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiElement target, @NotNull PsiJavaModule refModule) {
        Module module2;
        if (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiDocComment.class) == null && (module2 = ModuleHighlightUtil.findModule((PsiElement)refModule)) != null) {
            PsiDirectory[] dirs;
            PsiElement refImport;
            if (target instanceof PsiClass) {
                PsiElement targetFile = target.getParent();
                if (targetFile instanceof PsiClassOwner) {
                    PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor((PsiFileSystemItem)targetFile);
                    String packageName = ((PsiClassOwner)targetFile).getPackageName();
                    return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
                }
            } else if (target instanceof PsiPackage && (refImport = ref.getParent()) instanceof PsiImportStatementBase && ((PsiImportStatementBase)refImport).isOnDemand() && (dirs = ((PsiPackage)target).getDirectories(module2.getModuleWithDependenciesAndLibrariesScope(false))).length == 1) {
                PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor((PsiFileSystemItem)dirs[0]);
                String packageName = ((PsiPackage)target).getQualifiedName();
                return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
            }
        }
        return null;
    }

    private static HighlightInfo checkPackageAccessibility(PsiJavaCodeReferenceElement ref, PsiJavaModule refModule, PsiJavaModule targetModule, String packageName) {
        if (!refModule.equals(targetModule)) {
            if (targetModule == null) {
                String message2 = JavaErrorMessages.message("module.package.on.classpath", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)ref).descriptionAndTooltip(message2).create();
            }
            String refModuleName = refModule.getName();
            String requiredName = targetModule.getName();
            if (!(targetModule instanceof LightJavaModule) && !JavaModuleGraphUtil.exports(targetModule, packageName, refModule)) {
                String message3 = JavaErrorMessages.message("module.package.not.exported", requiredName, packageName, refModuleName);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)ref).descriptionAndTooltip(message3).create();
            }
            if (!"java.base".equals(requiredName) && !JavaModuleGraphUtil.reads(refModule, targetModule)) {
                String message4 = JavaErrorMessages.message("module.not.in.requirements", refModuleName, requiredName);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)ref).descriptionAndTooltip(message4).create();
                QuickFixAction.registerQuickFixAction(info, new AddRequiredModuleFix(refModule, requiredName));
                return info;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClashingReads(@NotNull PsiJavaModule module2) {
        Trinity<String, PsiJavaModule, PsiJavaModule> conflict = JavaModuleGraphUtil.findConflict(module2);
        if (conflict != null) {
            String message2 = JavaErrorMessages.message("module.conflicting.reads", module2.getName(), conflict.first, ((PsiJavaModule)conflict.second).getName(), ((PsiJavaModule)conflict.third).getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(module2)).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    private static Module findModule(PsiElement element) {
        return Optional.ofNullable(element.getContainingFile()).map(PsiFile::getVirtualFile).map(f -> ModuleUtilCore.findModuleForFile((VirtualFile)f, (Project)element.getProject())).orElse(null);
    }

    private static HighlightInfo moduleResolveError(PsiJavaModuleReferenceElement refElement, PsiPolyVariantReference ref) {
        if (ref.multiResolve(true).length == 0) {
            String message2 = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
        }
        if (ref.multiResolve(false).length > 1) {
            String message3 = JavaErrorMessages.message("module.ambiguous", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
        }
        String message4 = JavaErrorMessages.message("module.not.on.path", refElement.getReferenceText());
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message4).create();
        ModuleHighlightUtil.factory().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info), (PsiReference)ref);
        return info;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module2) {
        PsiKeyword kw = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)module2, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module2.getTextOffset(), module2.getNameIdentifier().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return (PsiElement)ObjectUtils.notNull((Object)refElement.getReferenceNameElement(), (Object)refElement);
    }
}

