/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAttributeIntentionFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myLocalName;

    public RemoveAttributeIntentionFix(String localName, @NotNull XmlAttribute attribute) {
        super((PsiElement)attribute);
        this.myLocalName = localName;
    }

    @NotNull
    public String getText() {
        return XmlErrorMessages.message("remove.attribute.quickfix.text", this.myLocalName);
    }

    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement next = RemoveAttributeIntentionFix.findNextAttribute((XmlAttribute)startElement);
        startElement.delete();
        if (next != null && editor != null) {
            editor.getCaretModel().moveToOffset(next.getTextRange().getStartOffset());
        }
    }

    @Nullable
    private static PsiElement findNextAttribute(XmlAttribute attribute) {
        for (PsiElement nextSibling = attribute.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof XmlAttribute)) continue;
            return nextSibling;
        }
        return null;
    }
}

