/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveTagIntentionFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myTagName;

    public RemoveTagIntentionFix(String name, @NotNull XmlTag tag) {
        super((PsiElement)tag);
        this.myTagName = name;
    }

    @NotNull
    public String getText() {
        return XmlErrorMessages.message("remove.tag.quickfix.text", this.myTagName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("remove.tag.quickfix.family", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        XmlTag next = editor != null ? (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)startElement, XmlTag.class) : null;
        XmlTag prev = editor != null ? (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)startElement, XmlTag.class) : null;
        startElement.delete();
        if (editor != null) {
            if (next != null) {
                editor.getCaretModel().moveToOffset(next.getTextRange().getStartOffset());
            } else if (prev != null) {
                editor.getCaretModel().moveToOffset(prev.getTextRange().getEndOffset());
            }
        }
    }
}

