/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlErrorQuickFixProvider
implements ErrorQuickFixProvider {
    @NonNls
    private static final String AMP_ENTITY = "&amp;";

    @Override
    public void registerErrorQuickFix(@NotNull PsiErrorElement element, @NotNull HighlightInfo highlightInfo) {
        if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) != null) {
            XmlErrorQuickFixProvider.registerXmlErrorQuickFix(element, highlightInfo);
        }
    }

    private static void registerXmlErrorQuickFix(final PsiErrorElement element, HighlightInfo highlightInfo) {
        String text = element.getErrorDescription();
        if (text != null && text.startsWith(XmlErrorMessages.message("unescaped.ampersand", new Object[0]))) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new IntentionAction(){

                @NotNull
                public String getText() {
                    return XmlErrorMessages.message("escape.ampersand.quickfix", new Object[0]);
                }

                @NotNull
                public String getFamilyName() {
                    return this.getText();
                }

                public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                    return true;
                }

                public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
                    int textOffset = element.getTextOffset();
                    editor.getDocument().replaceString(textOffset, textOffset + 1, (CharSequence)XmlErrorQuickFixProvider.AMP_ENTITY);
                }

                public boolean startInWriteAction() {
                    return true;
                }
            });
        }
    }
}

