/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlRefCountHolder;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlUnusedNamespaceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiFile file2 = holder.getFile();
                if (!(file2 instanceof XmlFile)) {
                    return;
                }
                XmlRefCountHolder refCountHolder = XmlRefCountHolder.getRefCountHolder((XmlFile)file2);
                if (refCountHolder == null) {
                    return;
                }
                if (!attribute.isNamespaceDeclaration()) {
                    XmlUnusedNamespaceInspection.checkUnusedLocations(attribute, holder, refCountHolder);
                    return;
                }
                String namespace = attribute.getValue();
                String declaredPrefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
                if (namespace != null && !refCountHolder.isInUse(declaredPrefix)) {
                    ImplicitUsageProvider[] implicitUsageProviders;
                    for (ImplicitUsageProvider provider2 : implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
                        if (!provider2.isImplicitUsage((PsiElement)attribute)) continue;
                        return;
                    }
                    XmlAttributeValue value2 = attribute.getValueElement();
                    assert (value2 != null);
                    holder.registerProblem((PsiElement)attribute, XmlBundle.message((String)"xml.inspections.unused.schema.declaration", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, false, !refCountHolder.isUsedNamespace(namespace))});
                    XmlTag parent = attribute.getParent();
                    if (declaredPrefix.isEmpty()) {
                        XmlAttribute location = XmlUnusedNamespaceInspection.getDefaultLocation(parent);
                        if (location != null) {
                            holder.registerProblem((PsiElement)location, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, true, true)});
                        }
                    } else if (!refCountHolder.isUsedNamespace(namespace)) {
                        for (PsiReference reference : XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent)) {
                            if (XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
                            holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, true, true)});
                        }
                    }
                }
            }
        };
    }

    private static void removeReferencesOrAttribute(PsiReference[] references) {
        if (references.length == 0) {
            return;
        }
        XmlAttributeValue element = (XmlAttributeValue)references[0].getElement();
        XmlAttribute attribute = (XmlAttribute)element.getParent();
        if (element.getReferences().length == references.length) {
            attribute.delete();
            return;
        }
        PsiFile file2 = element.getContainingFile();
        Project project2 = file2.getProject();
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)attribute);
        for (PsiReference reference : references) {
            RemoveNamespaceDeclarationFix.removeReferenceText(reference);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = documentManager.getDocument(file2);
        assert (document != null);
        documentManager.commitDocument(document);
        String trimmed = element.getValue().trim();
        XmlAttribute pointerElement = (XmlAttribute)pointer.getElement();
        assert (pointerElement != null);
        pointerElement.setValue(trimmed);
    }

    private static void checkUnusedLocations(XmlAttribute attribute, ProblemsHolder holder, @NotNull XmlRefCountHolder refCountHolder) {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            if ("noNamespaceSchemaLocation".equals(attribute.getLocalName())) {
                if (refCountHolder.isInUse("")) {
                    return;
                }
                holder.registerProblem((PsiElement)attribute, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceLocationFix("")});
            } else if ("schemaLocation".equals(attribute.getLocalName())) {
                XmlAttributeValue value2 = attribute.getValueElement();
                if (value2 == null) {
                    return;
                }
                PsiReference[] references = value2.getReferences();
                int referencesLength = references.length;
                for (int i2 = 0; i2 < referencesLength; ++i2) {
                    PsiReference nextRef;
                    PsiReference reference = references[i2];
                    if (!(reference instanceof URLReference)) continue;
                    String ns = XmlUnusedNamespaceInspection.getNamespaceFromReference(reference);
                    if (ArrayUtil.indexOf((Object[])attribute.getParent().knownNamespaces(), (Object)ns) != -1 || refCountHolder.isUsedNamespace(ns)) continue;
                    if (!XmlHighlightVisitor.hasBadResolve(reference, false)) {
                        holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceLocationFix(ns)});
                    }
                    for (int j = i2 + 1; j < referencesLength && !((nextRef = references[j]) instanceof URLReference); ++j) {
                        if (XmlHighlightVisitor.hasBadResolve(nextRef, false)) continue;
                        holder.registerProblemForReference(nextRef, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceLocationFix(ns)});
                    }
                }
            }
        }
    }

    private static String getDeclaredPrefix(XmlAttribute attribute) {
        return attribute.getName().contains(":") ? attribute.getLocalName() : "";
    }

    @Nullable
    private static XmlAttribute getDefaultLocation(XmlTag parent) {
        return parent.getAttribute("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlTag tag) {
        XmlAttribute locationAttr = tag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (locationAttr == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttributeValue value2 = locationAttr.getValueElement();
        return value2 == null ? PsiReference.EMPTY_ARRAY : XmlUnusedNamespaceInspection.getLocationReferences(namespace, value2);
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlAttributeValue value2) {
        PsiReference[] references = value2.getReferences();
        int referencesLength = references.length;
        for (int i2 = 0; i2 < referencesLength; i2 += 2) {
            PsiReference reference = references[i2];
            if (!namespace.equals(XmlUnusedNamespaceInspection.getNamespaceFromReference(reference))) continue;
            if (i2 + 1 < referencesLength) {
                return new PsiReference[]{references[i2 + 1], reference};
            }
            return new PsiReference[]{reference};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static String getNamespaceFromReference(PsiReference reference) {
        return reference.getRangeInElement().substring(reference.getElement().getText());
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return XmlInspectionGroupNames.XML_INSPECTIONS;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return XmlBundle.message((String)"xml.inspections.unused.schema", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "XmlUnusedNamespaceDeclaration";
    }

    public static class RemoveNamespaceLocationFix
    extends RemoveNamespaceDeclarationFix {
        public static final String NAME = "Remove unused namespace location";

        private RemoveNamespaceLocationFix(String namespace) {
            super(namespace, true, true);
        }

        @Override
        @NotNull
        public String getName() {
            return NAME;
        }

        @Override
        protected void doRemove(Project project2, XmlAttribute attribute, XmlTag parent) {
            if (StringUtil.isEmpty((String)this.myPrefix)) {
                attribute.delete();
            } else {
                XmlAttributeValue value2 = attribute.getValueElement();
                if (value2 == null) {
                    return;
                }
                PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(this.myPrefix, value2);
                XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    public static class RemoveNamespaceDeclarationFix
    implements LocalQuickFix {
        protected final String myPrefix;
        private final boolean myLocationFix;
        private final boolean myRemoveLocation;

        private RemoveNamespaceDeclarationFix(@Nullable String prefix, boolean locationFix, boolean removeLocation) {
            this.myPrefix = prefix;
            this.myLocationFix = locationFix;
            this.myRemoveLocation = removeLocation;
        }

        @NotNull
        public String getName() {
            return XmlBundle.message((String)"xml.inspections.unused.schema.remove", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return XmlInspectionGroupNames.XML_INSPECTIONS;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            this.doFix(project2, descriptor, true);
        }

        @Nullable
        public SmartPsiElementPointer<XmlTag> doFix(Project project2, ProblemDescriptor descriptor, boolean reformat) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof XmlAttributeValue) {
                element = element.getParent();
            } else if (!(element instanceof XmlAttribute)) {
                return null;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag parent = attribute.getParent();
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)parent);
            this.doRemove(project2, attribute, parent);
            if (reformat) {
                RemoveNamespaceDeclarationFix.reformatStartTag(project2, (SmartPsiElementPointer<XmlTag>)pointer);
            }
            return pointer;
        }

        public static void reformatStartTag(Project project2, SmartPsiElementPointer<XmlTag> pointer) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project2);
            PsiFile file2 = pointer.getContainingFile();
            assert (file2 != null);
            Document document = manager.getDocument(file2);
            assert (document != null);
            manager.commitDocument(document);
            XmlTag tag = (XmlTag)pointer.getElement();
            assert (tag != null);
            XmlUtil.reformatTagStart(tag);
        }

        protected void doRemove(Project project2, XmlAttribute attribute, XmlTag parent) {
            if (!attribute.isNamespaceDeclaration()) {
                SchemaPrefix schemaPrefix = DefaultXmlExtension.DEFAULT_EXTENSION.getPrefixDeclaration(parent, this.myPrefix);
                if (schemaPrefix != null) {
                    attribute = schemaPrefix.getDeclaration();
                } else {
                    return;
                }
            }
            String namespace = attribute.getValue();
            String prefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            Document document = documentManager.getDocument(parent.getContainingFile());
            assert (document != null);
            attribute.delete();
            if (this.myRemoveLocation) {
                if (prefix.isEmpty()) {
                    XmlAttribute locationAttr = XmlUnusedNamespaceInspection.getDefaultLocation(parent);
                    if (locationAttr != null) {
                        locationAttr.delete();
                    }
                } else {
                    documentManager.doPostponedOperationsAndUnblockDocument(document);
                    PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent);
                    XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
                    documentManager.commitDocument(document);
                }
            }
        }

        public static void removeReferenceText(PsiReference ref) {
            PsiElement element = ref.getElement();
            PsiFile file2 = element.getContainingFile();
            TextRange range = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
            Document document = manager.getDocument(file2);
            assert (document != null);
            manager.doPostponedOperationsAndUnblockDocument(document);
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }

        public boolean equals(Object obj) {
            return obj instanceof RemoveNamespaceDeclarationFix && Comparing.equal((String)this.myPrefix, (String)((RemoveNamespaceDeclarationFix)obj).myPrefix) && (this.myLocationFix || ((RemoveNamespaceDeclarationFix)obj).myLocationFix);
        }

        public int hashCode() {
            return this.myPrefix == null ? 0 : this.myPrefix.hashCode();
        }
    }
}

