/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToThrowsFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix");
    private final PsiElement myWrongElement;

    public AddExceptionToThrowsFix(@NotNull PsiElement wrongElement) {
        this.myWrongElement = wrongElement;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        PsiMethod targetMethod = this.collectExceptions(exceptions);
        if (targetMethod == null) {
            return;
        }
        THashSet unhandledExceptions = new THashSet(exceptions);
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project2, targetMethod, (Set<PsiClassType>)unhandledExceptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addExceptionsToThrowsList(@NotNull Project project2, @NotNull PsiMethod targetMethod, @NotNull Set<PsiClassType> unhandledExceptions) {
        boolean processSuperMethods;
        PsiMethod[] superMethods = AddExceptionToThrowsFix.getSuperMethods(targetMethod);
        boolean hasSuperMethodsWithoutExceptions = AddExceptionToThrowsFix.hasSuperMethodsWithoutExceptions(superMethods, unhandledExceptions);
        if (hasSuperMethodsWithoutExceptions && superMethods.length > 0) {
            int result2;
            int n = result2 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)QuickFixBundle.message("add.exception.to.throws.inherited.method.warning.text", targetMethod.getName()), (String)QuickFixBundle.message("method.is.inherited.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result2 == 0) {
                processSuperMethods = true;
            } else {
                if (result2 != true) return;
                processSuperMethods = false;
            }
        } else {
            processSuperMethods = false;
        }
        ArrayList<PsiMethod> toModify = new ArrayList<PsiMethod>();
        toModify.add(targetMethod);
        if (processSuperMethods) {
            Collections.addAll(toModify, superMethods);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(toModify)) {
            return;
        }
        WriteAction.run(() -> {
            AddExceptionToThrowsFix.processMethod(project2, targetMethod, unhandledExceptions);
            if (processSuperMethods) {
                for (PsiMethod superMethod : superMethods) {
                    AddExceptionToThrowsFix.processMethod(project2, superMethod, unhandledExceptions);
                }
            }
        });
    }

    private static PsiMethod[] getSuperMethods(@NotNull PsiMethod targetMethod) {
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        AddExceptionToThrowsFix.collectSuperMethods(targetMethod, result2);
        return result2.toArray(new PsiMethod[result2.size()]);
    }

    private static void collectSuperMethods(@NotNull PsiMethod method2, @NotNull List<PsiMethod> result2) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method2.findSuperMethods()) {
            result2.add(superMethod);
            AddExceptionToThrowsFix.collectSuperMethods(superMethod, result2);
        }
    }

    private static boolean hasSuperMethodsWithoutExceptions(@NotNull PsiMethod[] superMethods, @NotNull Set<PsiClassType> unhandledExceptions) {
        for (PsiMethod superMethod : superMethods) {
            PsiClassType[] referencedTypes = superMethod.getThrowsList().getReferencedTypes();
            HashSet<PsiClassType> exceptions = new HashSet<PsiClassType>(unhandledExceptions);
            for (PsiClassType referencedType : referencedTypes) {
                for (PsiClassType exception : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)exception)) continue;
                    exceptions.remove(exception);
                }
            }
            if (exceptions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void processMethod(@NotNull Project project2, @NotNull PsiMethod targetMethod, @NotNull Set<PsiClassType> unhandledExceptions) throws IncorrectOperationException {
        for (PsiClassType unhandledException : unhandledExceptions) {
            PsiClass exceptionClass = unhandledException.resolve();
            if (exceptionClass == null) continue;
            PsiUtil.addException((PsiMethod)targetMethod, (PsiClass)exceptionClass);
        }
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)targetMethod.getThrowsList());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        if (!this.myWrongElement.isValid()) {
            return false;
        }
        ArrayList<PsiClassType> unhandled = new ArrayList<PsiClassType>();
        if (this.collectExceptions(unhandled) == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.exception.to.throws.text", unhandled.size()));
        return true;
    }

    @Nullable
    private PsiMethod collectExceptions(List<PsiClassType> unhandled) {
        PsiElement psiElement;
        PsiElement targetElement = null;
        PsiMethod targetMethod = null;
        PsiElement psiElement2 = psiElement = this.myWrongElement instanceof PsiMethodReferenceExpression ? this.myWrongElement : PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMethod.class});
        if (psiElement instanceof PsiFunctionalExpression) {
            targetMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)psiElement);
            targetElement = psiElement instanceof PsiLambdaExpression ? ((PsiLambdaExpression)psiElement).getBody() : psiElement;
        } else if (psiElement instanceof PsiMethod) {
            targetMethod = (PsiMethod)psiElement;
            targetElement = psiElement;
        }
        if (targetElement == null || targetMethod == null || !targetMethod.getThrowsList().isPhysical()) {
            return null;
        }
        List<PsiClassType> exceptions = AddExceptionToThrowsFix.getUnhandledExceptions(this.myWrongElement, targetElement, targetMethod);
        if (exceptions == null || exceptions.isEmpty()) {
            return null;
        }
        unhandled.addAll(exceptions);
        return targetMethod;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.exception.to.throws.family", new Object[0]);
    }

    @Nullable
    private static List<PsiClassType> getUnhandledExceptions(@Nullable PsiElement element, PsiElement topElement, PsiMethod targetMethod) {
        if (element == null || element == topElement && !(topElement instanceof PsiMethodReferenceExpression)) {
            return null;
        }
        List<PsiClassType> unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element);
        if (!AddExceptionToThrowsFix.filterInProjectExceptions(targetMethod, unhandledExceptions).isEmpty()) {
            return unhandledExceptions;
        }
        if (topElement instanceof PsiMethodReferenceExpression) {
            return null;
        }
        return AddExceptionToThrowsFix.getUnhandledExceptions(element.getParent(), topElement, targetMethod);
    }

    @NotNull
    private static Set<PsiClassType> filterInProjectExceptions(@Nullable PsiMethod targetMethod, @NotNull List<PsiClassType> unhandledExceptions) {
        if (targetMethod == null) {
            return Collections.emptySet();
        }
        HashSet<PsiClassType> result2 = new HashSet<PsiClassType>();
        if (targetMethod.getManager().isInProject((PsiElement)targetMethod)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = targetMethod.findSuperMethods()) {
                Set<PsiClassType> classTypes = AddExceptionToThrowsFix.filterInProjectExceptions(superMethod, unhandledExceptions);
                result2.addAll(classTypes);
            }
            if (superMethods.length == 0) {
                result2.addAll(unhandledExceptions);
            }
        } else {
            PsiClassType[] referencedTypes;
            for (PsiClassType referencedType : referencedTypes = targetMethod.getThrowsList().getReferencedTypes()) {
                PsiClass psiClass = referencedType.resolve();
                if (psiClass == null) continue;
                for (PsiClassType exception : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)exception)) continue;
                    result2.add(exception);
                }
            }
        }
        return result2;
    }
}

