/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.AddOrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddExternalLibraryToDependenciesQuickFix
extends AddOrderEntryFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddExternalLibraryToDependenciesQuickFix");
    private final Module myCurrentModule;
    private final ExternalLibraryDescriptor myLibraryDescriptor;
    private final String myQualifiedClassName;

    public AddExternalLibraryToDependenciesQuickFix(@NotNull Module currentModule, @NotNull ExternalLibraryDescriptor libraryDescriptor, @NotNull PsiReference reference, @Nullable String qualifiedClassName) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myLibraryDescriptor = libraryDescriptor;
        this.myQualifiedClassName = qualifiedClassName;
    }

    @Nls
    @NotNull
    public String getText() {
        return "Add '" + this.myLibraryDescriptor.getPresentableName() + "' to classpath";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return !project2.isDisposed() && !this.myCurrentModule.isDisposed();
    }

    public void invoke(@NotNull Project project2, final Editor editor, PsiFile file2) throws IncorrectOperationException {
        DependencyScope scope = AddExternalLibraryToDependenciesQuickFix.suggestScopeByLocation(this.myCurrentModule, this.myReference.getElement());
        JavaProjectModelModificationService.getInstance(project2).addDependency(this.myCurrentModule, this.myLibraryDescriptor, scope).done(aVoid -> new WriteAction(){

            protected void run(@NotNull Result result2) {
                try {
                    OrderEntryFix.importClass(AddExternalLibraryToDependenciesQuickFix.this.myCurrentModule, editor, AddExternalLibraryToDependenciesQuickFix.this.myReference, AddExternalLibraryToDependenciesQuickFix.this.myQualifiedClassName);
                }
                catch (IndexNotReadyException e) {
                    LOG.info((Throwable)e);
                }
            }
        }.execute());
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

