/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class AddMethodBodyFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public AddMethodBodyFix(@NotNull PsiMethod method2) {
        this.myMethod = method2;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("add.method.body.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myMethod.isValid() && this.myMethod.getBody() == null && this.myMethod.getContainingClass() != null && this.myMethod.getManager().isInProject((PsiElement)this.myMethod);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.myMethod;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiUtil.setModifierProperty((PsiModifierListOwner)this.myMethod, (String)"abstract", (boolean)false);
        CreateFromUsageUtils.setupMethodBody(this.myMethod);
        CreateFromUsageUtils.setupEditor(this.myMethod, editor);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

