/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.AddOrderEntryFix;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddModuleDependencyFix
extends AddOrderEntryFix {
    private static final Logger LOG = Logger.getInstance(AddModuleDependencyFix.class);
    private final Module myCurrentModule;
    private final VirtualFile myRefVFile;
    private final List<PsiClass> myClasses;
    private final Set<Module> myModules;

    public AddModuleDependencyFix(Module currentModule, VirtualFile refVFile, List<PsiClass> classes2, PsiReference reference) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myRefVFile = refVFile;
        this.myClasses = classes2;
        this.myModules = new LinkedHashSet<Module>();
        PsiElement psiElement = reference.getElement();
        Project project2 = psiElement.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)currentModule);
        for (PsiClass aClass : classes2) {
            Module classModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == currentModule || rootManager.isDependsOn(classModule)) continue;
            this.myModules.add(classModule);
        }
    }

    public AddModuleDependencyFix(Module currentModule, VirtualFile refVFile, Set<Module> modules, PsiReference reference) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myRefVFile = refVFile;
        this.myClasses = Collections.emptyList();
        this.myModules = modules;
    }

    @NotNull
    public String getText() {
        if (this.myModules.size() == 1) {
            Module module2 = (Module)ContainerUtil.getFirstItem(this.myModules);
            LOG.assertTrue(module2 != null);
            return QuickFixBundle.message("orderEntry.fix.add.dependency.on.module", module2.getName());
        }
        return QuickFixBundle.message("orderEntry.fix.add.dependency.on.module.choose", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("orderEntry.fix.family.add.module.dependency", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return !project2.isDisposed() && !this.myCurrentModule.isDisposed() && !this.myModules.isEmpty() && this.myModules.stream().noneMatch(Module::isDisposed);
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) {
        if (this.myModules.size() == 1) {
            this.addDependencyOnModule(project2, editor, (Module)ContainerUtil.getFirstItem(this.myModules));
        } else {
            JBList list = new JBList(this.myModules);
            list.setCellRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer()));
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(QuickFixBundle.message("orderEntry.fix.choose.module.to.add.dependency.on", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> this.addDependencyOnModule(project2, editor, (Module)list.getSelectedValue())).createPopup();
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project2);
            }
        }
    }

    private void addDependencyOnModule(Project project2, Editor editor, @Nullable Module module2) {
        if (module2 == null) {
            return;
        }
        Couple circularModules = ModuleCompilerUtil.addingDependencyFormsCircularity((Module)this.myCurrentModule, (Module)module2);
        if (circularModules == null || AddModuleDependencyFix.showCircularWarning(project2, (Couple<Module>)circularModules, module2)) {
            WriteAction.run(() -> {
                PsiClass[] targetClasses;
                boolean test = ModuleRootManager.getInstance((Module)this.myCurrentModule).getFileIndex().isInTestSourceContent(this.myRefVFile);
                DependencyScope scope = test ? DependencyScope.TEST : DependencyScope.COMPILE;
                JavaProjectModelModificationService.getInstance(project2).addDependency(this.myCurrentModule, module2, scope);
                if (editor != null && !this.myClasses.isEmpty() && (targetClasses = (PsiClass[])this.myClasses.stream().filter(c -> ModuleUtilCore.findModuleForPsiElement((PsiElement)c) == module2).toArray(PsiClass[]::new)).length > 0 && !DumbService.isDumb((Project)project2)) {
                    new AddImportAction(project2, this.myReference, editor, targetClasses).execute();
                }
            });
        }
    }

    private static boolean showCircularWarning(Project project2, Couple<Module> circle, Module classModule) {
        String title;
        String message2 = QuickFixBundle.message("orderEntry.fix.circular.dependency.warning", classModule.getName(), ((Module)circle.getFirst()).getName(), ((Module)circle.getSecond()).getName());
        return Messages.showOkCancelDialog((Project)project2, (String)message2, (String)(title = QuickFixBundle.message("orderEntry.fix.title.circular.dependency.warning", new Object[0])), (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

