/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddNewArrayExpressionFix
implements IntentionAction {
    private final PsiArrayInitializerExpression myInitializer;

    public AddNewArrayExpressionFix(@NotNull PsiArrayInitializerExpression initializer) {
        this.myInitializer = initializer;
    }

    @NotNull
    public String getText() {
        PsiType type2 = this.getType();
        return QuickFixBundle.message("add.new.array.text", type2.getPresentableText());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.new.array.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!this.myInitializer.isValid() || !this.myInitializer.getManager().isInProject((PsiElement)this.myInitializer)) {
            return false;
        }
        return this.getType() != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.myInitializer;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiManager manager = file2.getManager();
        PsiType type2 = this.getType();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String text = "new " + type2.getCanonicalText() + "[]{}";
        PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText(text, null);
        newExpr.getArrayInitializer().replace((PsiElement)this.myInitializer);
        newExpr = (PsiNewExpression)CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)newExpr);
        this.myInitializer.replace((PsiElement)newExpr);
    }

    private PsiType getType() {
        PsiExpression[] initializers = this.myInitializer.getInitializers();
        PsiElement parent = this.myInitializer.getParent();
        if (!(parent instanceof PsiAssignmentExpression)) {
            if (initializers.length <= 0) {
                return null;
            }
            return AddNewArrayExpressionFix.validateType(initializers[0].getType());
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
        PsiType type2 = assignmentExpression.getType();
        if (!(type2 instanceof PsiArrayType)) {
            if (initializers.length <= 0) {
                return null;
            }
            return AddNewArrayExpressionFix.validateType(initializers[0].getType());
        }
        return AddNewArrayExpressionFix.validateType(((PsiArrayType)type2).getComponentType());
    }

    private static PsiType validateType(PsiType type2) {
        if (PsiType.NULL.equals((Object)type2)) {
            return null;
        }
        return LambdaUtil.notInferredType((PsiType)type2) || !PsiTypesUtil.isDenotableType((PsiType)type2) ? null : TypeConversionUtil.erasure((PsiType)type2);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

