/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddRequiredModuleFix
implements IntentionAction {
    private final SmartPsiElementPointer<PsiJavaModule> myModulePointer;
    private final String myRequiredName;

    public AddRequiredModuleFix(PsiJavaModule module2, String requiredName) {
        this.myModulePointer = SmartPointerManager.getInstance((Project)module2.getProject()).createSmartPsiElementPointer((PsiElement)module2);
        this.myRequiredName = requiredName;
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("module.info.add.requires.name", this.myRequiredName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("module.info.add.requires.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)file2)) {
            return false;
        }
        PsiJavaModule module2 = (PsiJavaModule)this.myModulePointer.getElement();
        return module2 != null && module2.isValid() && module2.getManager().isInProject((PsiElement)module2) && AddRequiredModuleFix.getLBrace(module2) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiJavaModule module2 = (PsiJavaModule)this.myModulePointer.getElement();
        if (module2 == null) {
            return;
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)project2).getParserFacade();
        PsiJavaModule tempModule = parserFacade.createModuleFromText("module " + module2.getName() + " { requires " + this.myRequiredName + "; }");
        Iterable tempModuleRequires = tempModule.getRequires();
        PsiRequiresStatement requiresStatement = (PsiRequiresStatement)tempModuleRequires.iterator().next();
        PsiElement addingPlace = AddRequiredModuleFix.findAddingPlace(module2);
        if (addingPlace != null) {
            addingPlace.getParent().addAfter((PsiElement)requiresStatement, addingPlace);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static PsiElement findAddingPlace(@NotNull PsiJavaModule module2) {
        PsiElement addingPlace = (PsiElement)ContainerUtil.iterateAndGetLastItem((Iterable)module2.getRequires());
        return addingPlace != null ? addingPlace : AddRequiredModuleFix.getLBrace(module2);
    }

    @Nullable
    private static PsiElement getLBrace(@NotNull PsiJavaModule module2) {
        PsiJavaModuleReferenceElement nameElement = module2.getNameIdentifier();
        for (PsiElement element = nameElement.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (!PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.LBRACE)) continue;
            return element;
        }
        return null;
    }
}

