/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddReturnFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public AddReturnFix(@NotNull PsiMethod method2) {
        this.myMethod = method2;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("add.return.statement.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myMethod.getBody() != null && this.myMethod.getBody().getRBrace() != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.myMethod;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        String value2 = this.suggestReturnValue();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
        PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return " + value2 + ";", (PsiElement)this.myMethod);
        PsiCodeBlock body2 = this.myMethod.getBody();
        returnStatement = (PsiReturnStatement)body2.addBefore((PsiElement)returnStatement, (PsiElement)body2.getRBrace());
        MethodReturnTypeFix.selectReturnValueInEditor(returnStatement, editor);
    }

    private String suggestReturnValue() {
        String conversion;
        PsiVariable[] variables;
        PsiType type2 = this.myMethod.getReturnType();
        for (PsiVariable variable : variables = AddReturnFix.getDeclaredVariables(this.myMethod)) {
            PsiType varType = variable.getType();
            if (!varType.equals(type2)) continue;
            return variable.getName();
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type2, true);
            if (conversion == null) continue;
            return conversion;
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type2, false);
            if (conversion == null) continue;
            return conversion;
        }
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
    }

    private String getConversionToType(@NotNull PsiVariable variable, @Nullable PsiType type2, boolean preciseTypeReqired) {
        PsiType arrayComponentType;
        PsiType varType = variable.getType();
        if (type2 instanceof PsiArrayType && !((arrayComponentType = ((PsiArrayType)type2).getComponentType()) instanceof PsiPrimitiveType) && !(PsiUtil.resolveClassInType((PsiType)arrayComponentType) instanceof PsiTypeParameter) && InheritanceUtil.isInheritor((PsiType)varType, (String)"java.util.Collection")) {
            PsiType collectionItemType;
            PsiType erasedComponentType = TypeConversionUtil.erasure((PsiType)arrayComponentType);
            if ((!preciseTypeReqired || arrayComponentType.equals(erasedComponentType)) && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)varType, (GlobalSearchScope)this.myMethod.getResolveScope())) != null && erasedComponentType.isAssignableFrom(collectionItemType)) {
                if (erasedComponentType.equalsToText("java.lang.Object")) {
                    return variable.getName() + ".toArray()";
                }
                return variable.getName() + ".toArray(new " + erasedComponentType.getCanonicalText() + "[0])";
            }
        }
        return null;
    }

    private static PsiVariable[] getDeclaredVariables(PsiMethod method2) {
        PsiStatement[] statements;
        ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
        for (PsiStatement statement2 : statements = method2.getBody().getStatements()) {
            PsiElement[] declaredElements;
            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
            for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)statement2).getDeclaredElements()) {
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                variables.add((PsiVariable)declaredElement);
            }
        }
        Object[] parameters2 = method2.getParameterList().getParameters();
        ContainerUtil.addAll(variables, (Object[])parameters2);
        return variables.toArray(new PsiVariable[variables.size()]);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

