/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsConditionalFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + AddTypeArgumentsConditionalFix.class.getName()));
    private final PsiSubstitutor mySubstitutor;
    private final PsiMethodCallExpression myExpression;
    private final PsiMethod myMethod;

    public AddTypeArgumentsConditionalFix(PsiSubstitutor substitutor, PsiMethodCallExpression expression2, PsiMethod method2) {
        this.mySubstitutor = substitutor;
        this.myExpression = expression2;
        this.myMethod = method2;
    }

    @NotNull
    public String getText() {
        return "Add explicit type arguments";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.mySubstitutor.isValid() && this.myExpression.isValid() && this.myMethod.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        String withTypeArgsText;
        Object[] typeParameters = this.myMethod.getTypeParameters();
        String typeArguments = "<" + StringUtil.join((Object[])typeParameters, parameter -> {
            PsiType substituteTypeParam = this.mySubstitutor.substitute(parameter);
            LOG.assertTrue(substituteTypeParam != null);
            return GenericsUtil.eliminateWildcards((PsiType)substituteTypeParam).getCanonicalText();
        }, (String)", ") + ">";
        PsiExpression expression2 = this.myExpression.getMethodExpression().getQualifierExpression();
        if (expression2 != null) {
            withTypeArgsText = expression2.getText();
        } else if (AddTypeArgumentsConditionalFix.isInStaticContext((PsiElement)this.myExpression, null) || this.myMethod.hasModifierProperty("static")) {
            PsiClass aClass = this.myMethod.getContainingClass();
            LOG.assertTrue(aClass != null);
            withTypeArgsText = aClass.getQualifiedName();
        } else {
            withTypeArgsText = "this";
        }
        withTypeArgsText = withTypeArgsText + "." + typeArguments + this.myExpression.getMethodExpression().getReferenceName();
        PsiExpression withTypeArgs = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(withTypeArgsText + this.myExpression.getArgumentList().getText(), (PsiElement)this.myExpression);
        this.myExpression.replace((PsiElement)withTypeArgs);
    }

    public static boolean isInStaticContext(PsiElement element, @Nullable PsiClass aClass) {
        return PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)aClass) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void register(HighlightInfo highlightInfo, PsiExpression expression2, @NotNull PsiType lType) {
        if (lType != PsiType.NULL && expression2 instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expression2).getThenExpression();
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expression2).getElseExpression();
            if (thenExpression2 != null && elseExpression2 != null) {
                PsiType thenType = thenExpression2.getType();
                PsiType elseType = elseExpression2.getType();
                if (thenType != null && elseType != null) {
                    boolean thenAssignable = TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)thenType);
                    boolean elseAssignable = TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)elseType);
                    if (!thenAssignable && thenExpression2 instanceof PsiMethodCallExpression) {
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, thenExpression2);
                    }
                    if (!elseAssignable && elseExpression2 instanceof PsiMethodCallExpression) {
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, elseExpression2);
                    }
                }
            }
        }
    }

    private static void inferTypeArgs(HighlightInfo highlightInfo, PsiType lType, PsiExpression thenExpression2) {
        JavaResolveResult result2 = ((PsiMethodCallExpression)thenExpression2).resolveMethodGenerics();
        PsiMethod method2 = (PsiMethod)result2.getElement();
        if (method2 != null) {
            PsiType returnType = method2.getReturnType();
            PsiClass aClass = method2.getContainingClass();
            if (returnType != null && aClass != null && aClass.getQualifiedName() != null) {
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)method2.getProject());
                PsiDeclarationStatement variableDeclarationStatement = javaPsiFacade.getElementFactory().createVariableDeclarationStatement("xxx", lType, thenExpression2);
                PsiExpression initializer = ((PsiLocalVariable)variableDeclarationStatement.getDeclaredElements()[0]).getInitializer();
                LOG.assertTrue(initializer != null);
                PsiSubstitutor substitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(method2.getTypeParameters(), method2.getParameterList().getParameters(), ((PsiMethodCallExpression)thenExpression2).getArgumentList().getExpressions(), PsiSubstitutor.EMPTY, (PsiElement)initializer, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                PsiType substitutedType = substitutor.substitute(returnType);
                if (substitutedType != null && TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)substitutedType)) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, thenExpression2.getTextRange(), new AddTypeArgumentsConditionalFix(substitutor, (PsiMethodCallExpression)thenExpression2, method2));
                }
            }
        }
    }
}

