/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CastMethodArgumentFix
extends MethodArgumentFix
implements HighPriorityAction {
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private CastMethodArgumentFix(PsiExpressionList list, int i2, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i2, toType, factory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            return QuickFixBundle.message("cast.single.parameter.text", JavaHighlightUtil.formatType(this.myToType));
        }
        return QuickFixBundle.message("cast.parameter.text", this.myIndex + 1, JavaHighlightUtil.formatType(this.myToType));
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public CastMethodArgumentFix createFix(PsiExpressionList list, int i2, PsiType toType) {
            return new CastMethodArgumentFix(list, i2, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression2.getType();
            if (exprType instanceof PsiClassType && toType instanceof PsiPrimitiveType) {
                toType = ((PsiPrimitiveType)toType).getBoxedType((PsiElement)expression2);
                assert (toType != null);
            }
            return AddTypeCastFix.createCastExpression(expression2, expression2.getProject(), toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType instanceof PsiClassType && parameterType instanceof PsiPrimitiveType && (parameterType = ((PsiPrimitiveType)parameterType).getBoxedType(context)) == null) {
                return false;
            }
            if (exprType instanceof PsiPrimitiveType && parameterType instanceof PsiClassType) {
                if (PsiType.NULL.equals((Object)exprType)) {
                    return true;
                }
                if ((parameterType = PsiPrimitiveType.getUnboxedType((PsiType)parameterType)) == null) {
                    return false;
                }
            }
            return parameterType.isConvertibleFrom(exprType);
        }
    }
}

