/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeMethodSignatureFromUsageFix
implements IntentionAction {
    final PsiMethod myTargetMethod;
    final PsiExpression[] myExpressions;
    final PsiSubstitutor mySubstitutor;
    final PsiElement myContext;
    private final boolean myChangeAllUsages;
    private final int myMinUsagesNumberToShowDialog;
    ParameterInfoImpl[] myNewParametersInfo;
    private static final Logger LOG = Logger.getInstance(ChangeMethodSignatureFromUsageFix.class);

    public ChangeMethodSignatureFromUsageFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions2, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        this.myTargetMethod = targetMethod;
        this.myExpressions = expressions2;
        this.mySubstitutor = substitutor;
        this.myContext = context;
        this.myChangeAllUsages = changeAllUsages;
        this.myMinUsagesNumberToShowDialog = minUsagesNumberToShowDialog;
    }

    @NotNull
    public String getText() {
        String shortText = this.getShortText();
        if (shortText != null) {
            return shortText;
        }
        return QuickFixBundle.message("change.method.signature.from.usage.text", JavaHighlightUtil.formatMethod(this.myTargetMethod), this.myTargetMethod.getName(), ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext));
    }

    @Nullable
    private String getShortText() {
        StringBuilder buf = new StringBuilder();
        HashSet<ParameterInfoImpl> newParams = new HashSet<ParameterInfoImpl>();
        HashSet<ParameterInfoImpl> removedParams = new HashSet<ParameterInfoImpl>();
        HashSet<ParameterInfoImpl> changedParams = new HashSet<ParameterInfoImpl>();
        this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor, buf, newParams, removedParams, changedParams);
        String targetMethodName = this.myTargetMethod.getName();
        if (this.myTargetMethod.getContainingClass().findMethodsByName(targetMethodName, true).length == 1) {
            if (newParams.size() == 1) {
                ParameterInfoImpl p = newParams.iterator().next();
                return QuickFixBundle.message("add.parameter.from.usage.text", p.getTypeText(), ArrayUtil.find((Object[])this.myNewParametersInfo, (Object)p) + 1, targetMethodName);
            }
            if (removedParams.size() == 1) {
                ParameterInfoImpl p = removedParams.iterator().next();
                return QuickFixBundle.message("remove.parameter.from.usage.text", p.getOldIndex() + 1, targetMethodName);
            }
            if (changedParams.size() == 1) {
                ParameterInfoImpl p = changedParams.iterator().next();
                return QuickFixBundle.message("change.parameter.from.usage.text", p.getOldIndex() + 1, targetMethodName, this.myTargetMethod.getParameterList().getParameters()[p.getOldIndex()].getType().getPresentableText(), p.getTypeText());
            }
        }
        return "<html> Change signature of " + targetMethodName + "(" + buf.toString() + ")</html>";
    }

    @Nullable
    private static String formatTypesList(ParameterInfoImpl[] infos, PsiElement context) {
        if (infos == null) {
            return null;
        }
        StringBuilder result2 = new StringBuilder();
        try {
            for (ParameterInfoImpl info : infos) {
                PsiType type2 = info.createType(context);
                if (type2 == null) {
                    return null;
                }
                if (result2.length() != 0) {
                    result2.append(", ");
                }
                result2.append(type2.getPresentableText());
            }
            return result2.toString();
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.method.signature.from.usage.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!this.myTargetMethod.isValid() || this.myTargetMethod.getContainingClass() == null) {
            return false;
        }
        for (PsiExpression expression2 : this.myExpressions) {
            if (expression2.isValid()) continue;
            return false;
        }
        if (!this.mySubstitutor.isValid()) {
            return false;
        }
        this.myNewParametersInfo = this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor);
        if (this.myNewParametersInfo == null || ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext) == null) {
            return false;
        }
        return !this.isMethodSignatureExists();
    }

    public boolean isMethodSignatureExists() {
        PsiMethod[] methods;
        PsiClass target = this.myTargetMethod.getContainingClass();
        LOG.assertTrue(target != null);
        for (PsiMethod method2 : methods = target.findMethodsByName(this.myTargetMethod.getName(), false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpression[])this.myExpressions)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiMethod method2 = SuperMethodWarningUtil.checkSuperMethod(this.myTargetMethod, RefactoringBundle.message((String)"to.refactor"));
        if (method2 == null) {
            return;
        }
        this.myNewParametersInfo = this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor);
        List<ParameterInfoImpl> parameterInfos = ChangeMethodSignatureFromUsageFix.performChange(project2, editor, file2, method2, this.myMinUsagesNumberToShowDialog, this.myNewParametersInfo, this.myChangeAllUsages, false);
        if (parameterInfos != null) {
            this.myNewParametersInfo = parameterInfos.toArray(new ParameterInfoImpl[parameterInfos.size()]);
        }
    }

    public static List<ParameterInfoImpl> performChange(Project project2, Editor editor, PsiFile file2, PsiMethod method2, int minUsagesNumber, ParameterInfoImpl[] newParametersInfo, final boolean changeAllUsages, boolean allowDelegation) {
        if (!FileModificationService.getInstance().prepareFileForWrite(method2.getContainingFile())) {
            return null;
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler((PsiElement)method2, false);
        if (handler2 == null) {
            return null;
        }
        JavaMethodFindUsagesOptions options = new JavaMethodFindUsagesOptions(project2);
        options.isImplementingMethods = true;
        options.isOverridingMethods = true;
        options.isUsages = true;
        options.isSearchForTextOccurrences = false;
        int[] usagesFound = new int[1];
        Runnable runnable2 = () -> {
            Processor processor2 = t -> {
                usagesFound[0] = usagesFound[0] + 1;
                return usagesFound[0] < minUsagesNumber;
            };
            handler2.processElementUsages((PsiElement)method2, (Processor<UsageInfo>)processor2, options);
        };
        String progressTitle = QuickFixBundle.message("searching.for.usages.progress.title", new Object[0]);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, progressTitle, true, project2)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || usagesFound[0] < minUsagesNumber) {
            ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(project2, method2, false, null, method2.getName(), method2.getReturnType(), newParametersInfo){

                @Override
                @NotNull
                protected UsageInfo[] findUsages() {
                    return changeAllUsages ? super.findUsages() : UsageInfo.EMPTY_ARRAY;
                }

                @Override
                protected void performRefactoring(@NotNull UsageInfo[] usages) {
                    CommandProcessor.getInstance().setCurrentCommandName(this.getCommandName());
                    super.performRefactoring(usages);
                }
            };
            processor2.run();
            ApplicationManager.getApplication().runWriteAction(() -> UndoUtil.markPsiFileForUndo((PsiFile)file2));
            return Arrays.asList(newParametersInfo);
        }
        ArrayList<ParameterInfoImpl> parameterInfos = newParametersInfo != null ? new ArrayList<ParameterInfoImpl>(Arrays.asList(newParametersInfo)) : new ArrayList();
        PsiReferenceExpression refExpr = JavaTargetElementEvaluator.findReferenceExpression(editor);
        JavaChangeSignatureDialog dialog2 = JavaChangeSignatureDialog.createAndPreselectNew(project2, method2, parameterInfos, allowDelegation, refExpr);
        dialog2.setParameterInfos(parameterInfos);
        dialog2.show();
        return dialog2.isOK() ? dialog2.getParameters() : null;
    }

    public static String getNewParameterNameByOldIndex(int oldIndex, ParameterInfoImpl[] parametersInfo) {
        if (parametersInfo == null) {
            return null;
        }
        for (ParameterInfoImpl info : parametersInfo) {
            if (info.oldParameterIndex != oldIndex) continue;
            return info.getName();
        }
        return null;
    }

    protected ParameterInfoImpl[] getNewParametersInfo(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor) {
        return this.getNewParametersInfo(expressions2, targetMethod, substitutor, new StringBuilder(), new HashSet<ParameterInfoImpl>(), new HashSet<ParameterInfoImpl>(), new HashSet<ParameterInfoImpl>());
    }

    private ParameterInfoImpl[] getNewParametersInfo(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<ParameterInfoImpl> newParams, HashSet<ParameterInfoImpl> removedParams, HashSet<ParameterInfoImpl> changedParams) {
        PsiParameter[] parameters2 = targetMethod.getParameterList().getParameters();
        ArrayList<ParameterInfoImpl> result2 = new ArrayList<ParameterInfoImpl>();
        if (expressions2.length < parameters2.length) {
            int ei = 0;
            int pi = 0;
            while (ei < expressions2.length && pi < parameters2.length) {
                PsiExpression expression2 = expressions2[ei];
                PsiParameter parameter = parameters2[pi];
                PsiType paramType = substitutor.substitute(parameter.getType());
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                PsiType parameterType = PsiUtil.convertAnonymousToBaseType((PsiType)paramType);
                String presentableText = ChangeMethodSignatureFromUsageFix.escapePresentableType(parameterType);
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(pi, parameter.getName(), parameter.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2)) {
                    buf.append(presentableText);
                    result2.add(parameterInfo);
                    ++pi;
                    ++ei;
                    continue;
                }
                buf.append("<s>").append(presentableText).append("</s>");
                removedParams.add(parameterInfo);
                ++pi;
            }
            if (result2.size() != expressions2.length) {
                return null;
            }
            for (int i2 = pi; i2 < parameters2.length; ++i2) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append("<s>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(parameters2[i2].getType())).append("</s>");
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(pi, parameters2[i2].getName(), parameters2[i2].getType());
                removedParams.add(parameterInfo);
            }
        } else if (expressions2.length > parameters2.length) {
            if (!this.findNewParamsPlace(expressions2, targetMethod, substitutor, buf, newParams, parameters2, result2)) {
                return null;
            }
        } else {
            PsiType paramType;
            for (int i3 = 0; i3 < parameters2.length; ++i3) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                PsiParameter parameter = parameters2[i3];
                PsiExpression expression3 = expressions2[i3];
                paramType = substitutor.substitute(parameter.getType());
                String presentableText = ChangeMethodSignatureFromUsageFix.escapePresentableType(paramType);
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression3)) {
                    result2.add(new ParameterInfoImpl(i3, parameter.getName(), paramType));
                    buf.append(presentableText);
                    continue;
                }
                if (PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression3)) {
                    return null;
                }
                PsiType exprType = RefactoringUtil.getTypeByExpression(expression3);
                if (exprType == null) {
                    return null;
                }
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                ParameterInfoImpl changedParameterInfo = new ParameterInfoImpl(i3, parameter.getName(), exprType);
                result2.add(changedParameterInfo);
                changedParams.add(changedParameterInfo);
                buf.append("<s>").append(presentableText).append("</s> <b>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(exprType)).append("</b>");
            }
            boolean isSilly = true;
            for (int i4 = 0; i4 < result2.size(); ++i4) {
                ParameterInfoImpl parameterInfo;
                String typeText;
                PsiParameter parameter = parameters2[i4];
                paramType = substitutor.substitute(parameter.getType());
                if (paramType.equalsToText(typeText = (parameterInfo = (ParameterInfoImpl)result2.get(i4)).getTypeText()) || paramType.getPresentableText().equals(typeText)) continue;
                isSilly = false;
                break;
            }
            if (isSilly) {
                return null;
            }
        }
        return result2.toArray(new ParameterInfoImpl[result2.size()]);
    }

    protected static String escapePresentableType(PsiType exprType) {
        return StringUtil.escapeXml((String)exprType.getPresentableText());
    }

    protected boolean findNewParamsPlace(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<ParameterInfoImpl> newParams, PsiParameter[] parameters2, List<ParameterInfoImpl> result2) {
        PsiParameter varargParam;
        HashSet<String> existingNames = new HashSet<String>();
        for (PsiParameter parameter : parameters2) {
            existingNames.add(parameter.getName());
        }
        int ei = 0;
        int pi = 0;
        PsiParameter psiParameter = varargParam = targetMethod.isVarArgs() ? parameters2[parameters2.length - 1] : null;
        while (ei < expressions2.length || pi < parameters2.length) {
            PsiType type2;
            boolean parameterAssignable;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            PsiExpression expression2 = ei < expressions2.length ? expressions2[ei] : null;
            PsiParameter parameter = pi < parameters2.length ? parameters2[pi] : null;
            PsiType paramType = parameter == null ? null : substitutor.substitute(parameter.getType());
            boolean bl = parameterAssignable = paramType != null && (expression2 == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2));
            if (parameterAssignable) {
                type2 = parameter.getType();
                result2.add(new ParameterInfoImpl(pi, parameter.getName(), type2));
                buf.append(ChangeMethodSignatureFromUsageFix.escapePresentableType(type2));
                ++pi;
                ++ei;
                continue;
            }
            if (ChangeMethodSignatureFromUsageFix.isArgumentInVarargPosition(expressions2, ei, varargParam, substitutor)) {
                if (pi == parameters2.length - 1) {
                    assert (varargParam != null);
                    type2 = varargParam.getType();
                    result2.add(new ParameterInfoImpl(pi, varargParam.getName(), type2));
                    buf.append(ChangeMethodSignatureFromUsageFix.escapePresentableType(type2));
                }
                ++pi;
                ++ei;
                continue;
            }
            if (expression2 == null) continue;
            if (varargParam != null && pi >= parameters2.length) {
                return false;
            }
            if (PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression2)) {
                return false;
            }
            PsiType exprType = RefactoringUtil.getTypeByExpression(expression2);
            if (exprType == null) {
                return false;
            }
            if (exprType instanceof PsiDisjunctionType) {
                exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
            String name = ChangeMethodSignatureFromUsageFix.suggestUniqueParameterName(codeStyleManager, expression2, exprType, existingNames);
            ParameterInfoImpl newParameterInfo = new ParameterInfoImpl(-1, name, exprType, expression2.getText().replace('\n', ' '));
            result2.add(newParameterInfo);
            newParams.add(newParameterInfo);
            buf.append("<b>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(exprType)).append("</b>");
            ++ei;
        }
        return result2.size() == expressions2.length || varargParam != null;
    }

    static boolean isArgumentInVarargPosition(PsiExpression[] expressions2, int ei, PsiParameter varargParam, PsiSubstitutor substitutor) {
        if (varargParam == null) {
            return false;
        }
        PsiExpression expression2 = expressions2[ei];
        if (expression2 == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)substitutor.substitute(((PsiEllipsisType)varargParam.getType()).getComponentType()), (PsiExpression)expression2)) {
            int lastExprIdx = expressions2.length - 1;
            if (ei == lastExprIdx) {
                return true;
            }
            return expressions2[lastExprIdx].getType() != PsiType.NULL;
        }
        return false;
    }

    static String suggestUniqueParameterName(JavaCodeStyleManager codeStyleManager, PsiExpression expression2, PsiType exprType, Set<String> existingNames) {
        PsiElement resolve2;
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, expression2, exprType);
        String[] names = nameInfo.names;
        if (expression2 instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable) {
            VariableKind variableKind = codeStyleManager.getVariableKind((PsiVariable)resolve2);
            String propertyName = codeStyleManager.variableNameToPropertyName(((PsiVariable)resolve2).getName(), variableKind);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            names = ArrayUtil.mergeArrays((String[])new String[]{parameterName}, (String[])names);
        }
        if (names.length == 0) {
            names = new String[]{"param"};
        }
        int suffix = 0;
        while (true) {
            for (String name : names) {
                String suggested = name + (suffix == 0 ? "" : String.valueOf(suffix));
                if (!existingNames.add(suggested)) continue;
                return suggested;
            }
            ++suffix;
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

