/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeMethodSignatureFromUsageReverseOrderFix
extends ChangeMethodSignatureFromUsageFix {
    public ChangeMethodSignatureFromUsageReverseOrderFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions2, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        super(targetMethod, expressions2, substitutor, context, changeAllUsages, minUsagesNumberToShowDialog);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (this.myTargetMethod.isValid() && this.myExpressions.length > this.myTargetMethod.getParameterList().getParametersCount() && super.isAvailable(project2, editor, file2)) {
            ArrayList<ParameterInfoImpl> result2 = new ArrayList<ParameterInfoImpl>();
            if (super.findNewParamsPlace(this.myExpressions, this.myTargetMethod, this.mySubstitutor, new StringBuilder(), new HashSet<ParameterInfoImpl>(), this.myTargetMethod.getParameterList().getParameters(), result2)) {
                if (this.myNewParametersInfo.length != result2.size()) {
                    return true;
                }
                int size = result2.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ParameterInfoImpl info = result2.get(i2);
                    info.setName(this.myNewParametersInfo[i2].getName());
                    if (this.myNewParametersInfo[i2].equals(info)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean findNewParamsPlace(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<ParameterInfoImpl> newParams, PsiParameter[] parameters2, List<ParameterInfoImpl> result2) {
        HashSet<String> existingNames = new HashSet<String>();
        for (PsiParameter parameter : parameters2) {
            existingNames.add(parameter.getName());
        }
        int ei = expressions2.length - 1;
        int pi = parameters2.length - 1;
        PsiParameter varargParam = targetMethod.isVarArgs() ? parameters2[parameters2.length - 1] : null;
        ArrayList<String> params = new ArrayList<String>();
        while (ei >= 0 || pi >= 0) {
            PsiType type2;
            boolean parameterAssignable;
            PsiExpression expression2 = ei >= 0 ? expressions2[ei] : null;
            PsiParameter parameter = pi >= 0 ? parameters2[pi] : null;
            PsiType paramType = parameter == null ? null : substitutor.substitute(parameter.getType());
            boolean bl = parameterAssignable = paramType != null && (expression2 == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2));
            if (parameterAssignable) {
                type2 = parameter.getType();
                result2.add(0, new ParameterInfoImpl(pi, parameter.getName(), type2));
                params.add(0, ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(type2));
                --pi;
                --ei;
                continue;
            }
            if (ChangeMethodSignatureFromUsageReverseOrderFix.isArgumentInVarargPosition(expressions2, ei, varargParam, substitutor)) {
                if (pi == parameters2.length - 1) {
                    assert (varargParam != null);
                    type2 = varargParam.getType();
                    result2.add(0, new ParameterInfoImpl(pi, varargParam.getName(), type2));
                    params.add(0, ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(type2));
                }
                --pi;
                --ei;
                continue;
            }
            if (expression2 == null) continue;
            if (varargParam != null && pi >= parameters2.length) {
                return false;
            }
            PsiType exprType = RefactoringUtil.getTypeByExpression(expression2);
            if (exprType == null) {
                return false;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
            String name = ChangeMethodSignatureFromUsageReverseOrderFix.suggestUniqueParameterName(codeStyleManager, expression2, exprType, existingNames);
            ParameterInfoImpl newParameterInfo = new ParameterInfoImpl(-1, name, exprType, expression2.getText().replace('\n', ' '));
            result2.add(0, newParameterInfo);
            newParams.add(newParameterInfo);
            params.add(0, "<b>" + ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(exprType) + "</b>");
            --ei;
        }
        if (result2.size() != expressions2.length && varargParam == null) {
            return false;
        }
        buf.append(StringUtil.join(params, (String)", "));
        return true;
    }
}

