/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertDoubleToFloatFix
implements IntentionAction {
    private final PsiExpression myExpression;

    public ConvertDoubleToFloatFix(PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @NotNull
    public String getText() {
        return "Convert '" + this.myExpression.getText() + "' to float";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (this.myExpression.isValid() && !StringUtil.endsWithIgnoreCase((String)this.myExpression.getText(), (String)"f")) {
            PsiLiteralExpression expression2 = (PsiLiteralExpression)this.createFloatingPointExpression(project2);
            Object value2 = expression2.getValue();
            return value2 instanceof Float && !((Float)value2).isInfinite() && (((Float)value2).floatValue() != 0.0f || TypeConversionUtil.isFPZero((String)expression2.getText()));
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.myExpression.replace((PsiElement)this.createFloatingPointExpression(project2));
    }

    private PsiExpression createFloatingPointExpression(Project project2) {
        String text = this.myExpression.getText();
        if (StringUtil.endsWithIgnoreCase((String)text, (String)"d")) {
            return JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(text.substring(0, text.length() - 1) + "f", (PsiElement)this.myExpression);
        }
        return JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(text + "f", (PsiElement)this.myExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ConvertDoubleToFloatFix.registerIntention(expressions2, highlightInfo, fixRange, candidate, (PsiElement)list);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions2, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        PsiParameter[] parameters2;
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method2 = (PsiMethod)candidate.getElement();
        if (method2 != null && context.getManager().isInProject((PsiElement)method2) && (parameters2 = method2.getParameterList().getParameters()).length == expressions2.length) {
            int length = parameters2.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiParameter parameter = parameters2[i2];
                PsiExpression expression2 = expressions2[i2];
                if (!(expression2 instanceof PsiLiteralExpression) || !PsiType.FLOAT.equals((Object)parameter.getType()) || !PsiType.DOUBLE.equals((Object)expression2.getType())) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new ConvertDoubleToFloatFix(expression2));
            }
        }
    }
}

