/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.DeclarationSearcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConvertReturnStatementsVisitor
implements ReturnStatementsVisitor {
    @NotNull
    private final PsiElementFactory myFactory;
    @NotNull
    private final PsiMethod myMethod;
    @NotNull
    private final DeclarationSearcher mySearcher;
    @NotNull
    private final String myDefaultValue;
    private PsiReturnStatement myLatestReturn;

    ConvertReturnStatementsVisitor(@NotNull PsiElementFactory factory, @NotNull PsiMethod method2, @NotNull PsiType targetType) {
        this.myFactory = factory;
        this.myMethod = method2;
        this.mySearcher = new DeclarationSearcher(method2, targetType);
        this.myDefaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)targetType);
    }

    @Override
    public void visit(final List<PsiReturnStatement> returnStatements) throws IncorrectOperationException {
        PsiReturnStatement statement2 = (PsiReturnStatement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiReturnStatement>(){

            public PsiReturnStatement compute() {
                return ConvertReturnStatementsVisitor.this.replaceReturnStatements(returnStatements);
            }
        });
        if (statement2 != null) {
            this.myLatestReturn = statement2;
        }
    }

    public PsiReturnStatement getLatestReturn() {
        return this.myLatestReturn;
    }

    private String generateValue(@NotNull PsiElement stopElement) {
        PsiVariable variable = this.mySearcher.getDeclaration(stopElement);
        return variable != null ? variable.getName() : this.myDefaultValue;
    }

    public PsiReturnStatement createReturnInLastStatement() throws IncorrectOperationException {
        return (PsiReturnStatement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiReturnStatement>(){

            public PsiReturnStatement compute() {
                PsiCodeBlock body2 = ConvertReturnStatementsVisitor.this.myMethod.getBody();
                PsiJavaToken rBrace = body2.getRBrace();
                if (rBrace == null) {
                    return null;
                }
                String value2 = ConvertReturnStatementsVisitor.this.generateValue((PsiElement)rBrace);
                PsiReturnStatement returnStatement = (PsiReturnStatement)ConvertReturnStatementsVisitor.this.myFactory.createStatementFromText("return " + value2 + ";", (PsiElement)ConvertReturnStatementsVisitor.this.myMethod);
                return (PsiReturnStatement)body2.addBefore((PsiElement)returnStatement, (PsiElement)rBrace);
            }
        });
    }

    @Nullable
    public PsiReturnStatement replaceReturnStatements(List<PsiReturnStatement> currentStatements) throws IncorrectOperationException {
        PsiReturnStatement latestReplaced = null;
        for (PsiReturnStatement returnStatement : currentStatements) {
            if (returnStatement.getReturnValue() != null) continue;
            String value2 = this.generateValue((PsiElement)returnStatement);
            latestReplaced = (PsiReturnStatement)this.myFactory.createStatementFromText("return " + value2 + ";", returnStatement.getParent());
            latestReplaced = (PsiReturnStatement)returnStatement.replace((PsiElement)latestReplaced);
        }
        return latestReplaced;
    }
}

