/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateAbstractMethodFromUsageFix
extends CreateMethodFromUsageFix {
    public CreateAbstractMethodFromUsageFix(@NotNull PsiMethodCallExpression methodCall) {
        super(methodCall);
    }

    @Override
    protected String getDisplayString(String name) {
        return QuickFixBundle.message("create.abstract.method.from.usage.text", name);
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        PsiReferenceExpression expr = this.getMethodCall().getMethodExpression();
        for (PsiClass each : super.getTargetClasses(element)) {
            if (!PsiUtil.isAbstractClass((PsiClass)each) || each.isInterface() || CreateAbstractMethodFromUsageFix.shouldCreateStaticMember(expr, each)) continue;
            result2.add(each);
        }
        return result2;
    }

    @Override
    protected String getVisibility(PsiClass parentClass, @NotNull PsiClass targetClass) {
        String result2 = super.getVisibility(parentClass, targetClass);
        return "public".equals(result2) ? result2 : "protected";
    }

    @Override
    protected boolean shouldBeAbstract(PsiReferenceExpression expression2, PsiClass targetClass) {
        return true;
    }
}

