/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateAnnotationMethodFromUsageFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)("#" + CreateAnnotationMethodFromUsageFix.class.getName()));
    private final SmartPsiElementPointer<PsiNameValuePair> myNameValuePair;

    public CreateAnnotationMethodFromUsageFix(@NotNull PsiNameValuePair valuePair) {
        this.myNameValuePair = SmartPointerManager.getInstance((Project)valuePair.getProject()).createSmartPsiElementPointer((PsiElement)valuePair);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiNameValuePair call = this.getNameValuePair();
        if (call == null || !call.isValid()) {
            return false;
        }
        String name = call.getName();
        if (name == null || !PsiNameHelper.getInstance((Project)call.getProject()).isIdentifier(name)) {
            return false;
        }
        if (CreateAnnotationMethodFromUsageFix.getAnnotationValueType(call.getValue()) == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("create.method.from.usage.text", name));
        return true;
    }

    @Override
    protected PsiElement getElement() {
        PsiNameValuePair call = this.getNameValuePair();
        if (call == null || !call.getManager().isInProject((PsiElement)call)) {
            return null;
        }
        return call;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        if (targetClass == null) {
            return;
        }
        PsiNameValuePair nameValuePair = this.getNameValuePair();
        if (nameValuePair == null || this.isValidElement((PsiElement)nameValuePair)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)nameValuePair.getProject()).getElementFactory();
        String methodName = nameValuePair.getName();
        LOG.assertTrue(methodName != null);
        PsiMethod method2 = factory.createMethod(methodName, (PsiType)PsiType.VOID);
        method2 = (PsiMethod)targetClass.add((PsiElement)method2);
        PsiCodeBlock body2 = method2.getBody();
        assert (body2 != null);
        body2.delete();
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)nameValuePair, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        PsiType type2 = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(nameValuePair.getValue());
        LOG.assertTrue(type2 != null);
        ExpectedTypeInfo[] expectedTypes = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfo(type2, 1, type2, TailType.NONE)};
        CreateMethodFromUsageFix.doCreate(targetClass, method2, true, ContainerUtil.map2List((Object[])PsiExpression.EMPTY_ARRAY, (Function)Pair.createFunction(null)), CreateAnnotationMethodFromUsageFix.getTargetSubstitutor((PsiElement)nameValuePair), expectedTypes, context);
    }

    @Nullable
    public static PsiType getAnnotationValueType(PsiAnnotationMemberValue value2) {
        PsiType type2 = null;
        if (value2 instanceof PsiExpression) {
            type2 = ((PsiExpression)value2).getType();
        } else if (value2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers();
            PsiType currentType = null;
            for (PsiAnnotationMemberValue initializer : initializers) {
                if (initializer instanceof PsiArrayInitializerMemberValue) {
                    return null;
                }
                if (!(initializer instanceof PsiExpression)) {
                    return null;
                }
                PsiType psiType = ((PsiExpression)initializer).getType();
                if (psiType == null) continue;
                if (currentType == null) {
                    currentType = psiType;
                    continue;
                }
                if (TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)psiType)) continue;
                if (TypeConversionUtil.isAssignable((PsiType)psiType, (PsiType)currentType)) {
                    currentType = psiType;
                    continue;
                }
                return null;
            }
            if (currentType != null) {
                type2 = currentType.createArrayType();
            }
        }
        if (type2 != null && ((Boolean)type2.accept((PsiTypeVisitor)AnnotationsHighlightUtil.AnnotationReturnTypeVisitor.INSTANCE)).booleanValue()) {
            return type2;
        }
        return null;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiReference reference = element.getReference();
        return reference != null && reference.resolve() != null;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
    }

    @Nullable
    protected PsiNameValuePair getNameValuePair() {
        return (PsiNameValuePair)this.myNameValuePair.getElement();
    }
}

