/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;

public class CreateConstantFieldFromUsageFix
extends CreateFieldFromUsageFix {
    @Override
    protected boolean createConstantField() {
        return true;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        String refName = this.myReferenceExpression.getReferenceName();
        return refName.toUpperCase().equals(refName);
    }

    public CreateConstantFieldFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected String getText(String varName) {
        return QuickFixBundle.message("create.constant.from.usage.text", varName);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.constant.from.usage.family", new Object[0]);
    }
}

