/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromUsageBaseFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix");

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement element = this.getElement();
        if (element == null || this.isValidElement(element)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (!this.isAvailableImpl(offset)) {
            return false;
        }
        List<PsiClass> targetClasses = this.filterTargetClasses(element, project2);
        return !targetClasses.isEmpty();
    }

    protected abstract boolean isAvailableImpl(int var1);

    protected abstract void invokeImpl(PsiClass var1);

    protected abstract boolean isValidElement(PsiElement var1);

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement element = this.getElement();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CreateFromUsage: element =" + element);
        }
        if (element == null) {
            return;
        }
        List<PsiClass> targetClasses = this.filterTargetClasses(element, project2);
        if (targetClasses.isEmpty()) {
            return;
        }
        if (targetClasses.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.doInvoke(project2, targetClasses.get(0));
        } else {
            this.chooseTargetClass(targetClasses, editor);
        }
    }

    protected List<PsiClass> filterTargetClasses(PsiElement element, Project project2) {
        return ContainerUtil.filter(this.getTargetClasses(element), psiClass -> JVMElementFactories.getFactory((Language)psiClass.getLanguage(), (Project)project2) != null);
    }

    private void doInvoke(Project project2, PsiClass targetClass) {
        if (!FileModificationService.getInstance().prepareFileForWrite(targetClass.getContainingFile())) {
            return;
        }
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        ApplicationManager.getApplication().runWriteAction(() -> this.invokeImpl(targetClass));
    }

    @Nullable
    protected abstract PsiElement getElement();

    private void chooseTargetClass(List<PsiClass> classes2, Editor editor) {
        PsiClass firstClass = classes2.get(0);
        Project project2 = firstClass.getProject();
        JBList list = new JBList(classes2);
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        renderer.installSpeedSearch(builder);
        PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes2, firstClass);
        if (preselection != null) {
            list.setSelectedValue(preselection, true);
        }
        Runnable runnable2 = () -> this.lambda$chooseTargetClass$3((JList)list, firstClass, project2);
        builder.setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(editor);
    }

    @Nullable(value="null means unable to open the editor")
    protected static Editor positionCursor(@NotNull Project project2, @NotNull PsiFile targetFile, @NotNull PsiElement element) {
        TextRange range = element.getTextRange();
        LOG.assertTrue(range != null, element.getClass());
        int textOffset = range.getStartOffset();
        VirtualFile file2 = targetFile.getVirtualFile();
        if (file2 == null && (file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, file2, textOffset);
        descriptor.setScrollType(ScrollType.MAKE_VISIBLE);
        return FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
    }

    protected void setupVisibility(PsiClass parentClass, @NotNull PsiClass targetClass, PsiModifierList list) throws IncorrectOperationException {
        if (targetClass.isInterface() && list.getFirstChild() != null) {
            list.deleteChildRange(list.getFirstChild(), list.getLastChild());
            return;
        }
        if (targetClass.isInterface()) {
            return;
        }
        String visibility = this.getVisibility(parentClass, targetClass);
        if ("EscalateVisible".equals(visibility)) {
            list.setModifierProperty("private", true);
            VisibilityUtil.escalateVisibility((PsiModifierList)list, (PsiElement)parentClass);
        } else {
            VisibilityUtil.setVisibility((PsiModifierList)list, (String)visibility);
        }
    }

    @PsiModifier.ModifierConstant
    protected String getVisibility(PsiClass parentClass, @NotNull PsiClass targetClass) {
        if (parentClass != null && (parentClass.equals(targetClass) || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)parentClass, (boolean)true))) {
            return "private";
        }
        return CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).VISIBILITY;
    }

    protected static boolean shouldCreateStaticMember(PsiReferenceExpression ref, PsiClass targetClass) {
        PsiExpression qualifierExpression2 = ref.getQualifierExpression();
        while (qualifierExpression2 instanceof PsiParenthesizedExpression) {
            qualifierExpression2 = ((PsiParenthesizedExpression)qualifierExpression2).getExpression();
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            PsiElement resolvedElement = referenceExpression.resolve();
            return resolvedElement instanceof PsiClass;
        }
        if (qualifierExpression2 != null) {
            return false;
        }
        if (ref instanceof PsiMethodReferenceExpression) {
            return true;
        }
        assert (PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)ref, (boolean)true));
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiModifierListOwner.class);
        if (owner instanceof PsiMethod && ((PsiMethod)owner).isConstructor()) {
            String calleeText;
            PsiReferenceExpression run2 = ref;
            while (run2.getParent() instanceof PsiExpression) {
                run2 = (PsiExpression)run2.getParent();
            }
            if (run2.getParent() instanceof PsiExpressionList && run2.getParent().getParent() instanceof PsiMethodCallExpression && ((calleeText = ((PsiMethodCallExpression)run2.getParent().getParent()).getMethodExpression().getText()).equals("this") || calleeText.equals("super"))) {
                return true;
            }
        }
        while (owner != null && owner != targetClass) {
            if (owner.hasModifierProperty("static")) {
                return true;
            }
            owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiModifierListOwner.class);
        }
        return false;
    }

    @Nullable
    private static PsiExpression getQualifier(PsiElement element) {
        if (element instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement ref = ((PsiNewExpression)element).getClassReference();
            if (ref instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)ref).getQualifierExpression();
            }
        } else {
            if (element instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)element).getQualifierExpression();
            }
            if (element instanceof PsiMethodCallExpression) {
                return ((PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression();
            }
        }
        return null;
    }

    protected static PsiSubstitutor getTargetSubstitutor(PsiElement element) {
        PsiType type2;
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result2 = ((PsiNewExpression)element).getClassOrAnonymousClassReference().advancedResolve(false);
            PsiSubstitutor substitutor = result2.getSubstitutor();
            return substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
        }
        PsiExpression qualifier = CreateFromUsageBaseFix.getQualifier(element);
        if (qualifier != null && (type2 = qualifier.getType()) instanceof PsiClassType) {
            return ((PsiClassType)type2).resolveGenerics().getSubstitutor();
        }
        return PsiSubstitutor.EMPTY;
    }

    protected boolean isAllowOuterTargetClass() {
        return true;
    }

    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        PsiAnnotation annotation;
        PsiClass psiClass = null;
        PsiExpression qualifier = null;
        if (element instanceof PsiNameValuePair && (annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class)) != null) {
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null) {
                return Collections.emptyList();
            }
            PsiElement resolve2 = nameRef.resolve();
            if (resolve2 instanceof PsiClass) {
                return Collections.singletonList((PsiClass)resolve2);
            }
            return Collections.emptyList();
        }
        if (element instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
            if (ref != null) {
                PsiElement refElement = ref.resolve();
                if (refElement instanceof PsiClass) {
                    psiClass = (PsiClass)refElement;
                } else {
                    PsiElement refQualifier = ref.getQualifier();
                    if (refQualifier instanceof PsiJavaCodeReferenceElement && (refElement = ((PsiJavaCodeReferenceElement)refQualifier).resolve()) instanceof PsiClass) {
                        psiClass = (PsiClass)refElement;
                    }
                }
            }
        } else if (element instanceof PsiReferenceExpression) {
            PsiExpression expression2;
            PsiSwitchStatement switchStatement;
            PsiElement parent;
            qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
            if (qualifier == null && element instanceof PsiMethodReferenceExpression) {
                PsiTypeElement qualifierTypeElement = ((PsiMethodReferenceExpression)element).getQualifierType();
                if (qualifierTypeElement != null) {
                    psiClass = PsiUtil.resolveClassInType((PsiType)qualifierTypeElement.getType());
                }
            } else if (qualifier == null && (parent = element.getParent()) instanceof PsiSwitchLabelStatement && (switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiSwitchStatement.class)) != null && (expression2 = switchStatement.getExpression()) != null) {
                psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            }
        } else if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
            qualifier = methodExpression.getQualifierExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return Collections.emptyList();
            }
        }
        boolean allowOuterClasses = false;
        if (qualifier != null) {
            PsiElement resolved;
            PsiType type2 = qualifier.getType();
            if (type2 instanceof PsiClassType) {
                psiClass = ((PsiClassType)type2).resolve();
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass && psiClass == null) {
                psiClass = (PsiClass)resolved;
            }
        } else if (psiClass == null) {
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            allowOuterClasses = true;
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiClass[] supers = psiClass.getSupers();
            ArrayList<PsiClass> filtered = new ArrayList<PsiClass>();
            for (PsiClass aSuper : supers) {
                if (!aSuper.getManager().isInProject((PsiElement)aSuper) || aSuper instanceof PsiTypeParameter) continue;
                filtered.add(aSuper);
            }
            return filtered;
        }
        if (psiClass == null || !psiClass.getManager().isInProject((PsiElement)psiClass)) {
            return Collections.emptyList();
        }
        if (!allowOuterClasses || !this.isAllowOuterTargetClass()) {
            ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
            this.collectSupers(psiClass, classes2);
            return classes2;
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        while (psiClass != null) {
            result2.add(psiClass);
            if (psiClass.hasModifierProperty("static")) break;
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
        }
        return result2;
    }

    private void collectSupers(PsiClass psiClass, ArrayList<PsiClass> classes2) {
        PsiClass[] supers;
        classes2.add(psiClass);
        for (PsiClass aSuper : supers = psiClass.getSupers()) {
            if (classes2.contains(aSuper) || !this.canBeTargetClass(aSuper)) continue;
            this.collectSupers(aSuper, classes2);
        }
    }

    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass);
    }

    protected static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project2) {
        CreateFromUsageBaseFix.startTemplate(editor, template, project2, null);
    }

    protected static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project2, TemplateEditingListener listener2) {
        CreateFromUsageBaseFix.startTemplate(editor, template, project2, listener2, null);
    }

    public static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project2, TemplateEditingListener listener2, String commandName) {
        Runnable runnable2 = () -> TemplateManager.getInstance(project2).startTemplate(editor, template, listener2);
        CommandProcessor.getInstance().executeCommand(project2, runnable2, commandName, (Object)commandName);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void setupGenericParameters(PsiClass targetClass, PsiJavaCodeReferenceElement ref) {
        int numParams = ref.getTypeParameters().length;
        if (numParams == 0) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ref.getProject()).getElementFactory();
        HashSet<String> typeParamNames = new HashSet<String>();
        for (PsiType type2 : ref.getTypeParameters()) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (!(psiClass instanceof PsiTypeParameter)) continue;
            typeParamNames.add(psiClass.getName());
        }
        int idx = 0;
        block1: for (PsiType type3 : ref.getTypeParameters()) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type3);
            if (psiClass instanceof PsiTypeParameter) {
                targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText(psiClass.getName(), null));
                continue;
            }
            while (true) {
                String paramName;
                String string = paramName = idx > 0 ? "T" + idx : "T";
                if (typeParamNames.add(paramName)) {
                    targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText(paramName, null));
                    continue block1;
                }
                ++idx;
            }
        }
    }

    private /* synthetic */ void lambda$chooseTargetClass$3(JList list, PsiClass firstClass, Project project2) {
        int index = list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        PsiClass aClass = (PsiClass)list.getSelectedValue();
        AnonymousTargetClassPreselectionUtil.rememberSelection(aClass, firstClass);
        CommandProcessor.getInstance().executeCommand(project2, () -> this.doInvoke(project2, aClass), this.getText(), null);
    }
}

