/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CreateParameterFromUsageFix
extends CreateVarFromUsageFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix");

    public CreateParameterFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        if (this.myReferenceExpression.isQualified()) {
            return false;
        }
        PsiReferenceExpression scope = this.myReferenceExpression;
        while ((scope = PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{PsiMethod.class, PsiClass.class})) instanceof PsiAnonymousClass) {
        }
        return scope instanceof PsiMethod && ((PsiMethod)scope).getParameterList().isPhysical();
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.parameter.from.usage.text", varName);
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        TransactionGuard.getInstance().submitTransactionLater((Disposable)targetClass.getProject(), () -> {
            block12: {
                if (!this.myReferenceExpression.isValid()) {
                    return;
                }
                if (CreateFromUsageUtils.isValidReference((PsiReference)this.myReferenceExpression, false)) {
                    return;
                }
                Project project2 = this.myReferenceExpression.getProject();
                PsiType[] expectedTypes = CreateFromUsageUtils.guessType((PsiExpression)this.myReferenceExpression, false);
                PsiType type2 = expectedTypes[0];
                String varName = this.myReferenceExpression.getReferenceName();
                PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myReferenceExpression, PsiMethod.class);
                LOG.assertTrue(method2 != null);
                method2 = IntroduceParameterHandler.chooseEnclosingMethod(method2);
                if (method2 == null) {
                    return;
                }
                if ((method2 = SuperMethodWarningUtil.checkSuperMethod(method2, RefactoringBundle.message((String)"to.refactor"))) == null) {
                    return;
                }
                ArrayList<ParameterInfoImpl> parameterInfos = new ArrayList<ParameterInfoImpl>(Arrays.asList(ParameterInfoImpl.fromMethod(method2)));
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(-1, varName, type2, varName, false);
                if (!method2.isVarArgs()) {
                    parameterInfos.add(parameterInfo);
                } else {
                    parameterInfos.add(parameterInfos.size() - 1, parameterInfo);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ParameterInfoImpl[] array = parameterInfos.toArray(new ParameterInfoImpl[parameterInfos.size()]);
                    String modifier = PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)method2.getModifierList()));
                    ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(project2, method2, false, modifier, method2.getName(), method2.getReturnType(), array);
                    processor2.run();
                } else {
                    try {
                        JavaChangeSignatureDialog dialog2 = JavaChangeSignatureDialog.createAndPreselectNew(project2, method2, parameterInfos, true, this.myReferenceExpression);
                        dialog2.setParameterInfos(parameterInfos);
                        if (!dialog2.showAndGet()) break block12;
                        for (ParameterInfoImpl info : parameterInfos) {
                            if (info.getOldIndex() != -1) continue;
                            String newParamName = info.getName();
                            if (!Comparing.strEqual((String)varName, (String)newParamName)) {
                                final PsiExpression newExpr = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(newParamName, (PsiElement)method2);
                                new WriteCommandAction(project2, new PsiFile[0]){

                                    protected void run(@NotNull Result result2) throws Throwable {
                                        PsiReferenceExpression[] refs;
                                        for (PsiReferenceExpression ref : refs = CreateFromUsageUtils.collectExpressions((PsiExpression)CreateParameterFromUsageFix.this.myReferenceExpression, PsiMember.class, PsiFile.class)) {
                                            ref.replace(newExpr.copy());
                                        }
                                    }
                                }.execute();
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.parameter.from.usage.family", new Object[0]);
    }
}

