/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchFix
implements IntentionAction {
    private final PsiParameter myCatchParameter;

    public DeleteCatchFix(@NotNull PsiParameter myCatchParameter) {
        this.myCatchParameter = myCatchParameter;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("delete.catch.text", JavaHighlightUtil.formatType(this.myCatchParameter.getType()));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("delete.catch.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myCatchParameter.isValid() && PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.myCatchParameter.getContainingFile());
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.myCatchParameter;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiTryStatement tryStatement = ((PsiCatchSection)this.myCatchParameter.getDeclarationScope()).getTryStatement();
        if (tryStatement.getCatchBlocks().length == 1 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null) {
            PsiElement firstElement;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            PsiCodeBlock lastAddedStatement = null;
            if (tryBlock != null && (firstElement = tryBlock.getFirstBodyElement()) != null) {
                PsiElement tryParent = tryStatement.getParent();
                if (tryParent instanceof PsiCodeBlock) {
                    PsiElement lastBodyElement = tryBlock.getLastBodyElement();
                    assert (lastBodyElement != null) : tryBlock.getText();
                    tryParent.addRangeBefore(firstElement, lastBodyElement, (PsiElement)tryStatement);
                    for (lastAddedStatement = tryStatement.getPrevSibling(); lastAddedStatement != null && (lastAddedStatement instanceof PsiWhiteSpace || lastAddedStatement.getTextLength() == 0); lastAddedStatement = lastAddedStatement.getPrevSibling()) {
                    }
                } else {
                    tryParent.addBefore((PsiElement)tryBlock, (PsiElement)tryStatement);
                    lastAddedStatement = tryBlock;
                }
            }
            tryStatement.delete();
            if (lastAddedStatement != null) {
                editor.getCaretModel().moveToOffset(lastAddedStatement.getTextRange().getEndOffset());
            }
            return;
        }
        PsiElement catchSection = this.myCatchParameter.getParent();
        assert (catchSection instanceof PsiCatchSection) : catchSection;
        PsiElement previousElement = catchSection.getPrevSibling();
        while (previousElement instanceof PsiWhiteSpace) {
            previousElement = previousElement.getPrevSibling();
        }
        catchSection.delete();
        if (previousElement != null) {
            editor.getCaretModel().moveToOffset(previousElement.getTextRange().getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

